SET NOCOUNT ON

DECLARE @errorCode  INTEGER = 0
IF object_id('CommServ.dbo.PatchUAPackageConfig') IS NOT NULL
BEGIN

	INSERT INTO PatchUAPackageConfig (UAClientId, simPackageId, OSId)
	SELECT A.UAClientId, T._ID, A.OSId
	FROM PatchUAContentConfig A CROSS APPLY dbo.SplitIDs(A.SelectedPackageList) T JOIN simPackage S WITH(NOLOCK) ON T._ID = S.id
	WHERE NOT EXISTS (SELECT * FROM PatchUAPackageConfig pkg
						WHERE pkg.UAClientID = A.UAClientId AND
							pkg.OSId = A.OSId AND
							pkg.simPackageID = t._ID)


	UPDATE PatchUAContentConfig SET SelectedPackageList = ''

	DECLARE @propName VARCHAR(1024)= 'Patch Use New Sync'
	IF EXISTS (select 1 from GXGlobalParam where name = @propName)
		UPDATE GXGlobalParam SET value = 1 WHERE name = @propName
	ELSE
		INSERT GXGlobalParam SELECT @propName, 1 , dbo.GetUnixTime(getUTCDate()), 0

END
