SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON

IF (dbo.IsOSOnCSWindows()=1)
BEGIN
	RETURN
END

-- from Schedtimezone.script
DECLARE @guidSchedtimezone uniqueidentifier = 'C00B9B60-DB0D-4906-A98D-87DD76C8184D'
DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       
DECLARE @globalParamExec INT = 0
SELECT @globalParamExec = 1
FROM
    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
WHERE
    gp.SqlScriptGUID = @guidSchedtimezone

IF (@globalParamExec = 0)        -- not done, update it for linux
BEGIN	
	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null
    		DROP TABLE #schedTimezoneTemp
	-- Copying schema from SchedTimezone table to temp table. 
	SELECT * INTO #schedTimezoneTemp FROM SchedTimezone	
	WHERE 1 = 0 
	
	-- Update flags as 1 for windows timezones but dont remove them since we may need them later for mapping to unix timezones
	UPDATE SchedTimeZone
	SET flags = Flags | 1
	
	INSERT INTO #schedTimezoneTemp ([TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]) 
	VALUES
	(1,'Pacific/Niue','Pacific/Niue','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),
	(2,'Pacific/Pago_Pago','Pacific/Pago_Pago','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),
	(3,'Pacific/Midway','Pacific/Midway','UTC-11',0,-39600,0,0,0,0,0,0,0,0,0,0,0),
	(4,'Pacific/Rarotonga','Pacific/Rarotonga','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),
	(5,'Pacific/Honolulu','Pacific/Honolulu','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),
	(6,'America/Adak','America/Adak','Aleutian Standard Time',1,-36000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(7,'Pacific/Tahiti','Pacific/Tahiti','Hawaiian Standard Time',0,-36000,0,0,0,0,0,0,0,0,0,0,0),
	(8,'Pacific/Marquesas','Pacific/Marquesas','Marquesas Standard Time',0,-34200,0,0,0,0,0,0,0,0,0,0,0),
	(9,'America/Yakutat','America/Yakutat','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(10,'America/Sitka','America/Sitka','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(11,'America/Metlakatla','America/Metlakatla','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(12,'America/Juneau','America/Juneau','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(13,'America/Nome','America/Nome','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(14,'America/Anchorage','America/Anchorage','Alaskan Standard Time',1,-32400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(15,'Pacific/Gambier','Pacific/Gambier','UTC-09',0,-32400,0,0,0,0,0,0,0,0,0,0,0),
	(16,'America/Tijuana','America/Tijuana','Pacific Standard Time (Mexico)',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),
	(17,'America/Vancouver','America/Vancouver','Pacific Standard Time',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),
	(18,'America/Los_Angeles','America/Los_Angeles','Pacific Standard Time',1,-28800,0,11,0,1,7199,3600,3,0,1,7200,0),
	(19,'Pacific/Pitcairn','Pacific/Pitcairn','UTC-08',0,-28800,0,0,0,0,0,0,0,0,0,0,0),
	(20,'America/Chihuahua','America/Chihuahua','Mountain Standard Time (Mexico)',1,-25200,0,10,0,1,7199,3600,4,0,1,7200,0),
	(21,'America/Mazatlan','America/Mazatlan','Mountain Standard Time (Mexico)',1,-25200,0,10,0,1,7199,3600,4,0,1,7200,0),
	(22,'America/Hermosillo','America/Hermosillo','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(23,'America/Denver','America/Denver','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(24,'America/Cambridge_Bay','America/Cambridge_Bay','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(25,'America/Edmonton','America/Edmonton','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(26,'America/Yellowknife','America/Yellowknife','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(27,'America/Phoenix','America/Phoenix','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(28,'America/Fort_Nelson','America/Fort_Nelson','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(29,'America/Dawson_Creek','America/Dawson_Creek','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(30,'America/Creston','America/Creston','US Mountain Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(31,'America/Ojinaga','America/Ojinaga','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(32,'America/Boise','America/Boise','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(33,'America/Inuvik','America/Inuvik','Mountain Standard Time',1,-25200,0,11,0,1,7199,3600,3,0,1,7200,0),
	(34,'America/Dawson','America/Dawson','Pacific Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(35,'America/Whitehorse','America/Whitehorse','Pacific Standard Time',0,-25200,0,0,0,0,0,0,0,0,0,0,0),
	(36,'America/Costa_Rica','America/Costa_Rica','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(37,'America/Belize','America/Belize','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(38,'America/Monterrey','America/Monterrey','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),
	(39,'America/Mexico_City','America/Mexico_City','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),
	(40,'America/Winnipeg','America/Winnipeg','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(41,'America/Rainy_River','America/Rainy_River','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(42,'America/Resolute','America/Resolute','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(43,'America/Rankin_Inlet','America/Rankin_Inlet','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(44,'America/Regina','America/Regina','Canada Central Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(45,'America/Swift_Current','America/Swift_Current','Canada Central Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(46,'America/Matamoros','America/Matamoros','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(47,'America/Chicago','America/Chicago','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(48,'America/Merida','America/Merida','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),
	(49,'America/Guatemala','America/Guatemala','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(50,'America/Tegucigalpa','America/Tegucigalpa','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(51,'America/El_Salvador','America/El_Salvador','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(52,'America/Indiana/Knox','America/Indiana/Knox','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(53,'America/Indiana/Tell_City','America/Indiana/Tell_City','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(54,'America/Menominee','America/Menominee','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(55,'America/Managua','America/Managua','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(56,'America/Bahia_Banderas','America/Bahia_Banderas','Central Standard Time (Mexico)',1,-21600,0,10,0,1,7199,3600,4,0,1,7200,0),
	(57,'America/North_Dakota/Beulah','America/North_Dakota/Beulah','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(58,'America/North_Dakota/Center','America/North_Dakota/Center','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(59,'America/North_Dakota/New_Salem','America/North_Dakota/New_Salem','Central Standard Time',1,-21600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(60,'Pacific/Easter','Pacific/Easter','Easter Island Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(61,'Pacific/Galapagos','Pacific/Galapagos','Central America Standard Time',0,-21600,0,0,0,0,0,0,0,0,0,0,0),
	(62,'America/Rio_Branco','America/Rio_Branco','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(63,'America/Eirunepe','America/Eirunepe','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(64,'America/Bogota','America/Bogota','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(65,'America/Havana','America/Havana','Cuba Standard Time',1,-18000,0,11,0,1,3599,3600,3,0,1,0,0),
	(66,'America/Kentucky/Monticello','America/Kentucky/Monticello','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(67,'America/Iqaluit','America/Iqaluit','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(68,'America/Thunder_Bay','America/Thunder_Bay','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(69,'America/Nipigon','America/Nipigon','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(70,'America/Toronto','America/Toronto','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(71,'America/Port-au-Prince','America/Port-au-Prince','Haiti Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(72,'America/Indiana/Petersburg','America/Indiana/Petersburg','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(73,'America/Indiana/Vevay','America/Indiana/Vevay','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(74,'America/Indiana/Vincennes','America/Indiana/Vincennes','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(75,'America/Panama','America/Panama','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(76,'America/Kentucky/Louisville','America/Kentucky/Louisville','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(77,'America/Jamaica','America/Jamaica','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(78,'America/Indiana/Indianapolis','America/Indiana/Indianapolis','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(79,'America/Nassau','America/Nassau','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(80,'America/Indiana/Marengo','America/Indiana/Marengo','US Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(81,'America/Indiana/Winamac','America/Indiana/Winamac','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(82,'America/Detroit','America/Detroit','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(83,'America/Grand_Turk','America/Grand_Turk','Turks And Caicos Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(84,'America/New_York','America/New_York','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(85,'America/Cancun','America/Cancun','Eastern Standard Time (Mexico)',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(86,'America/Cayman','America/Cayman','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(87,'America/Pangnirtung','America/Pangnirtung','Eastern Standard Time',1,-18000,0,11,0,1,7199,3600,3,0,1,7200,0),
	(88,'America/Atikokan','America/Atikokan','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(89,'America/Guayaquil','America/Guayaquil','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(90,'America/Lima','America/Lima','SA Pacific Standard Time',0,-18000,0,0,0,0,0,0,0,0,0,0,0),
	(91,'America/Manaus','America/Manaus','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(92,'America/Boa_Vista','America/Boa_Vista','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(93,'America/Porto_Velho','America/Porto_Velho','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(94,'America/Cuiaba','America/Cuiaba','Central Brazilian Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(95,'America/Campo_Grande','America/Campo_Grande','Central Brazilian Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(96,'America/Port_of_Spain','America/Port_of_Spain','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(97,'America/Thule','America/Thule','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(98,'America/Grenada','America/Grenada','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(99,'America/Dominica','America/Dominica','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(100,'America/Lower_Princes','America/Lower_Princes','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(101,'America/Santo_Domingo','America/Santo_Domingo','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(102,'America/St_Lucia','America/St_Lucia','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(103,'America/St_Kitts','America/St_Kitts','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(104,'America/Puerto_Rico','America/Puerto_Rico','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(105,'America/Curacao','America/Curacao','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(106,'America/Moncton','America/Moncton','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(107,'America/Goose_Bay','America/Goose_Bay','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(108,'America/St_Thomas','America/St_Thomas','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(109,'America/Tortola','America/Tortola','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(110,'America/Antigua','America/Antigua','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(111,'America/Anguilla','America/Anguilla','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(112,'America/Martinique','America/Martinique','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(113,'America/St_Vincent','America/St_Vincent','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(114,'America/Montserrat','America/Montserrat','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(115,'America/Marigot','America/Marigot','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(116,'America/Blanc-Sablon','America/Blanc-Sablon','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(117,'America/Aruba','America/Aruba','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(118,'America/Barbados','America/Barbados','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(119,'America/St_Barthelemy','America/St_Barthelemy','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(120,'Atlantic/Bermuda','Atlantic/Bermuda','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(121,'America/Kralendijk','America/Kralendijk','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(122,'America/Guadeloupe','America/Guadeloupe','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(123,'America/Glace_Bay','America/Glace_Bay','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(124,'America/Halifax','America/Halifax','Atlantic Standard Time',1,-14400,0,11,0,1,7199,3600,3,0,1,7200,0),
	(125,'America/La_Paz','America/La_Paz','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(126,'America/Santiago','America/Santiago','Pacific SA Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(127,'America/Guyana','America/Guyana','SA Western Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(128,'America/Asuncion','America/Asuncion','Paraguay Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(129,'America/Caracas','America/Caracas','Venezuela Standard Time',0,-14400,0,0,0,0,0,0,0,0,0,0,0),
	(130,'America/St_Johns','America/St_Johns','Newfoundland Standard Time',1,-12600,0,11,0,1,7199,3600,3,0,1,7200,0),
	(131,'America/Argentina/Jujuy','America/Argentina/Jujuy','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(132,'America/Argentina/Buenos_Aires','America/Argentina/Buenos_Aires','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(133,'America/Argentina/Cordoba','America/Argentina/Cordoba','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(134,'America/Argentina/Salta','America/Argentina/Salta','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(135,'America/Argentina/Tucuman','America/Argentina/Tucuman','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(136,'America/Argentina/Catamarca','America/Argentina/Catamarca','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(137,'America/Argentina/La_Rioja','America/Argentina/La_Rioja','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(138,'America/Argentina/Mendoza','America/Argentina/Mendoza','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(139,'America/Argentina/Rio_Gallegos','America/Argentina/Rio_Gallegos','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(140,'America/Argentina/Ushuaia','America/Argentina/Ushuaia','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(141,'America/Argentina/San_Juan','America/Argentina/San_Juan','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(142,'America/Araguaina','America/Araguaina','Tocantins Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(143,'America/Recife','America/Recife','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(144,'America/Maceio','America/Maceio','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(145,'America/Fortaleza','America/Fortaleza','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(146,'America/Santarem','America/Santarem','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(147,'America/Belem','America/Belem','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(148,'America/Bahia','America/Bahia','Bahia Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(149,'America/Sao_Paulo','America/Sao_Paulo','E. South America Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(150,'Atlantic/Stanley','Atlantic/Stanley','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(151,'America/Cayenne','America/Cayenne','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(152,'America/Punta_Arenas','America/Punta_Arenas','Magallanes Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(153,'Antarctica/Palmer','Antarctica/Palmer','Magallanes Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(154,'Antarctica/Rothera','Antarctica/Rothera','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(155,'America/Miquelon','America/Miquelon','Saint Pierre Standard Time',1,-10800,0,11,0,1,7199,3600,3,0,1,7200,0),
	(156,'America/Paramaribo','America/Paramaribo','SA Eastern Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(157,'America/Montevideo','America/Montevideo','Montevideo Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(158,'America/Argentina/San_Luis','America/Argentina/San_Luis','Argentina Standard Time',0,-10800,0,0,0,0,0,0,0,0,0,0,0),
	(159,'America/Noronha','America/Noronha','UTC-02',0,-7200,0,0,0,0,0,0,0,0,0,0,0),
	(160,'Atlantic/South_Georgia','Atlantic/South_Georgia','UTC-02',0,-7200,0,0,0,0,0,0,0,0,0,0,0),
	(161,'Atlantic/Azores','Atlantic/Azores','Azores Standard Time',1,-3600,0,10,0,1,3599,3600,3,0,1,0,0),
	(162,'Atlantic/Cape_Verde','Atlantic/Cape_Verde','Cape Verde Standard Time',0,-3600,0,0,0,0,0,0,0,0,0,0,0),
	(163,'America/Scoresbysund','America/Scoresbysund','Azores Standard Time',1,-3600,0,10,0,1,3599,3600,3,0,1,0,0),
	(164,'Africa/El_Aaiun','Africa/El_Aaiun','Morocco Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(165,'Africa/Casablanca','Africa/Casablanca','Morocco Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(166,'Europe/Dublin','Europe/Dublin','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(167,'Africa/Nouakchott','Africa/Nouakchott','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(168,'Atlantic/Reykjavik','Atlantic/Reykjavik','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(169,'Africa/Bissau','Africa/Bissau','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(170,'Africa/Monrovia','Africa/Monrovia','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(171,'Atlantic/St_Helena','Atlantic/St_Helena','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(172,'Europe/Isle_of_Man','Europe/Isle_of_Man','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(173,'Europe/Jersey','Europe/Jersey','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(174,'Africa/Bamako','Africa/Bamako','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(175,'Africa/Conakry','Africa/Conakry','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(176,'Africa/Banjul','Africa/Banjul','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(177,'America/Danmarkshavn','America/Danmarkshavn','UTC',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(178,'Africa/Sao_Tome','Africa/Sao_Tome','Sao Tome Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(179,'Africa/Lome','Africa/Lome','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(180,'Africa/Accra','Africa/Accra','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(181,'Europe/Guernsey','Europe/Guernsey','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(182,'Africa/Dakar','Africa/Dakar','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(183,'Africa/Abidjan','Africa/Abidjan','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(184,'Africa/Freetown','Africa/Freetown','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(185,'Africa/Ouagadougou','Africa/Ouagadougou','Greenwich Standard Time',0,0,0,0,0,0,0,0,0,0,0,0,0),
	(186,'Europe/London','Europe/London','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(187,'Atlantic/Canary','Atlantic/Canary','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(188,'Europe/Lisbon','Europe/Lisbon','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(189,'Atlantic/Faroe','Atlantic/Faroe','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(190,'Atlantic/Madeira','Atlantic/Madeira','GMT Standard Time',1,0,0,10,0,1,7199,3600,3,0,1,3600,0),
	(191,'Europe/Brussels','Europe/Brussels','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(192,'Europe/Luxembourg','Europe/Luxembourg','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(193,'Europe/Sarajevo','Europe/Sarajevo','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(194,'Europe/Vaduz','Europe/Vaduz','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(195,'Europe/Vienna','Europe/Vienna','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(196,'Europe/Zurich','Europe/Zurich','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(197,'Europe/Monaco','Europe/Monaco','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(198,'Europe/Malta','Europe/Malta','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(199,'Europe/Podgorica','Europe/Podgorica','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(200,'Europe/Skopje','Europe/Skopje','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(201,'Africa/Tunis','Africa/Tunis','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(202,'Europe/Vatican','Europe/Vatican','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(203,'Europe/Tirane','Europe/Tirane','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(204,'Europe/Prague','Europe/Prague','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(205,'Europe/Berlin','Europe/Berlin','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(206,'Europe/Amsterdam','Europe/Amsterdam','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(207,'Europe/Oslo','Europe/Oslo','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(208,'Europe/Busingen','Europe/Busingen','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(209,'Europe/Stockholm','Europe/Stockholm','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(210,'Europe/Gibraltar','Europe/Gibraltar','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(211,'Europe/Zagreb','Europe/Zagreb','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(212,'Europe/Ljubljana','Europe/Ljubljana','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(213,'Europe/Budapest','Europe/Budapest','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(214,'Europe/Belgrade','Europe/Belgrade','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(215,'Europe/Paris','Europe/Paris','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(216,'Arctic/Longyearbyen','Arctic/Longyearbyen','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(217,'Europe/San_Marino','Europe/San_Marino','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(218,'Europe/Rome','Europe/Rome','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(219,'Europe/Bratislava','Europe/Bratislava','Central Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(220,'Europe/Andorra','Europe/Andorra','W. Europe Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(221,'Africa/Ceuta','Africa/Ceuta','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(222,'Europe/Copenhagen','Europe/Copenhagen','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(223,'Africa/Algiers','Africa/Algiers','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(224,'Europe/Madrid','Europe/Madrid','Romance Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(225,'Europe/Warsaw','Europe/Warsaw','Central European Standard Time',1,3600,0,10,0,1,10799,3600,3,0,1,7200,0),
	(226,'Africa/Luanda','Africa/Luanda','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(227,'Africa/Lagos','Africa/Lagos','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(228,'Africa/Niamey','Africa/Niamey','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(229,'Africa/Ndjamena','Africa/Ndjamena','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(230,'Africa/Douala','Africa/Douala','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(231,'Africa/Porto-Novo','Africa/Porto-Novo','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(232,'Africa/Kinshasa','Africa/Kinshasa','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(233,'Africa/Malabo','Africa/Malabo','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(234,'Africa/Bangui','Africa/Bangui','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(235,'Africa/Brazzaville','Africa/Brazzaville','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(236,'Africa/Libreville','Africa/Libreville','W. Central Africa Standard Time',0,3600,0,0,0,0,0,0,0,0,0,0,0),
	(237,'Africa/Blantyre','Africa/Blantyre','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(238,'Africa/Kigali','Africa/Kigali','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(239,'Africa/Maputo','Africa/Maputo','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(240,'Africa/Khartoum','Africa/Khartoum','Sudan Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(241,'Africa/Windhoek','Africa/Windhoek','Namibia Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(242,'Africa/Harare','Africa/Harare','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(243,'Africa/Bujumbura','Africa/Bujumbura','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(244,'Africa/Lusaka','Africa/Lusaka','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(245,'Africa/Gaborone','Africa/Gaborone','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(246,'Africa/Lubumbashi','Africa/Lubumbashi','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(247,'Europe/Kaliningrad','Europe/Kaliningrad','Kaliningrad Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(248,'Europe/Sofia','Europe/Sofia','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(249,'Europe/Athens','Europe/Athens','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(250,'Europe/Helsinki','Europe/Helsinki','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(251,'Asia/Amman','Asia/Amman','Jordan Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),
	(252,'Asia/Hebron','Asia/Hebron','West Bank Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),
	(253,'Asia/Gaza','Asia/Gaza','West Bank Standard Time',1,7200,0,10,0,1,3599,3600,3,0,1,0,0),
	(254,'Africa/Cairo','Africa/Cairo','Egypt Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(255,'Europe/Mariehamn','Europe/Mariehamn','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(256,'Asia/Beirut','Asia/Beirut','Middle East Standard Time',1,7200,0,10,0,1,86399,3600,3,0,1,0,0),
	(257,'Asia/Damascus','Asia/Damascus','Syria Standard Time',1,7200,0,10,0,1,86399,3600,3,0,1,0,0),
	(258,'Europe/Tallinn','Europe/Tallinn','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(259,'Europe/Vilnius','Europe/Vilnius','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(260,'Europe/Kiev','Europe/Kiev','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(261,'Europe/Uzhgorod','Europe/Uzhgorod','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(262,'Europe/Zaporozhye','Europe/Zaporozhye','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(263,'Asia/Nicosia','Asia/Nicosia','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(264,'Europe/Bucharest','Europe/Bucharest','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(265,'Africa/Tripoli','Africa/Tripoli','Libya Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(266,'Europe/Riga','Europe/Riga','FLE Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(267,'Europe/Chisinau','Europe/Chisinau','E. Europe Standard Time',1,7200,0,10,0,1,10799,3600,3,0,1,7200,0),
	(268,'Asia/Famagusta','Asia/Famagusta','GTB Standard Time',1,7200,0,10,0,1,14399,3600,3,0,1,10800,0),
	(269,'Asia/Jerusalem','Asia/Jerusalem','Israel Standard Time',1,7200,0,10,0,1,7199,3600,3,0,1,7200,0),
	(270,'Africa/Maseru','Africa/Maseru','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(271,'Africa/Johannesburg','Africa/Johannesburg','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(272,'Africa/Mbabane','Africa/Mbabane','South Africa Standard Time',0,7200,0,0,0,0,0,0,0,0,0,0,0),
	(273,'Asia/Qatar','Asia/Qatar','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(274,'Asia/Baghdad','Asia/Baghdad','Arabic Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(275,'Asia/Kuwait','Asia/Kuwait','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(276,'Asia/Riyadh','Asia/Riyadh','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(277,'Asia/Bahrain','Asia/Bahrain','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(278,'Asia/Aden','Asia/Aden','Arab Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(279,'Africa/Addis_Ababa','Africa/Addis_Ababa','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(280,'Africa/Mogadishu','Africa/Mogadishu','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(281,'Africa/Juba','Africa/Juba','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(282,'Africa/Asmara','Africa/Asmara','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(283,'Africa/Djibouti','Africa/Djibouti','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(284,'Africa/Kampala','Africa/Kampala','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(285,'Africa/Nairobi','Africa/Nairobi','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(286,'Africa/Dar_es_Salaam','Africa/Dar_es_Salaam','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(287,'Indian/Comoro','Indian/Comoro','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(288,'Indian/Mayotte','Indian/Mayotte','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(289,'Indian/Antananarivo','Indian/Antananarivo','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(290,'Europe/Kirov','Europe/Kirov','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(291,'Europe/Minsk','Europe/Minsk','Belarus Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(292,'Europe/Simferopol','Europe/Simferopol','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(293,'Europe/Moscow','Europe/Moscow','Russian Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(294,'Antarctica/Syowa','Antarctica/Syowa','E. Africa Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(295,'Europe/Istanbul','Europe/Istanbul','Turkey Standard Time',0,10800,0,0,0,0,0,0,0,0,0,0,0),
	(296,'Asia/Tehran','Asia/Tehran','Iran Standard Time',1,12600,0,9,0,1,86399,3600,3,0,1,0,0),
	(297,'Asia/Yerevan','Asia/Yerevan','Caucasus Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(298,'Asia/Baku','Asia/Baku','Azerbaijan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(299,'Europe/Saratov','Europe/Saratov','Saratov Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(300,'Europe/Ulyanovsk','Europe/Ulyanovsk','Astrakhan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(301,'Europe/Astrakhan','Europe/Astrakhan','Astrakhan Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(302,'Asia/Tbilisi','Asia/Tbilisi','Georgian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(303,'Asia/Dubai','Asia/Dubai','Arabian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(304,'Asia/Muscat','Asia/Muscat','Arabian Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(305,'Indian/Mauritius','Indian/Mauritius','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(306,'Indian/Reunion','Indian/Reunion','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(307,'Europe/Samara','Europe/Samara','Russia Time Zone 3',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(308,'Indian/Mahe','Indian/Mahe','Mauritius Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(309,'Europe/Volgograd','Europe/Volgograd','Volgograd Standard Time',0,14400,0,0,0,0,0,0,0,0,0,0,0),
	(310,'Asia/Kabul','Asia/Kabul','Afghanistan Standard Time',0,16200,0,0,0,0,0,0,0,0,0,0,0),
	(311,'Indian/Kerguelen','Indian/Kerguelen','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(312,'Indian/Maldives','Indian/Maldives','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(313,'Antarctica/Mawson','Antarctica/Mawson','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(314,'Asia/Karachi','Asia/Karachi','Pakistan Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(315,'Asia/Dushanbe','Asia/Dushanbe','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(316,'Asia/Ashgabat','Asia/Ashgabat','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(317,'Asia/Tashkent','Asia/Tashkent','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(318,'Asia/Samarkand','Asia/Samarkand','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(319,'Asia/Oral','Asia/Oral','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(320,'Asia/Atyrau','Asia/Atyrau','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(321,'Asia/Aqtau','Asia/Aqtau','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(322,'Asia/Aqtobe','Asia/Aqtobe','West Asia Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(323,'Asia/Qyzylorda','Asia/Qyzylorda','Qyzylorda Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(324,'Asia/Yekaterinburg','Asia/Yekaterinburg','Ekaterinburg Standard Time',0,18000,0,0,0,0,0,0,0,0,0,0,0),
	(325,'Asia/Colombo','Asia/Colombo','Sri Lanka Standard Time',0,19800,0,0,0,0,0,0,0,0,0,0,0),
	(326,'Asia/Kolkata','Asia/Kolkata','India Standard Time',0,19800,0,0,0,0,0,0,0,0,0,0,0),
	(327,'Asia/Kathmandu','Asia/Kathmandu','Nepal Standard Time',0,20700,0,0,0,0,0,0,0,0,0,0,0),
	(328,'Asia/Dhaka','Asia/Dhaka','Bangladesh Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(329,'Asia/Thimphu','Asia/Thimphu','Bangladesh Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(330,'Asia/Almaty','Asia/Almaty','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(331,'Asia/Qostanay','Asia/Qostanay','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(332,'Indian/Chagos','Indian/Chagos','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(333,'Asia/Bishkek','Asia/Bishkek','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(334,'Asia/Omsk','Asia/Omsk','Omsk Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(335,'Asia/Urumqi','Asia/Urumqi','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(336,'Antarctica/Vostok','Antarctica/Vostok','Central Asia Standard Time',0,21600,0,0,0,0,0,0,0,0,0,0,0),
	(337,'Indian/Cocos','Indian/Cocos','Myanmar Standard Time',0,23400,0,0,0,0,0,0,0,0,0,0,0),
	(338,'Asia/Yangon','Asia/Yangon','Myanmar Standard Time',0,23400,0,0,0,0,0,0,0,0,0,0,0),
	(339,'Indian/Christmas','Indian/Christmas','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(340,'Antarctica/Davis','Antarctica/Davis','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(341,'Asia/Barnaul','Asia/Barnaul','Altai Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(342,'Asia/Tomsk','Asia/Tomsk','Tomsk Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(343,'Asia/Hovd','Asia/Hovd','W. Mongolia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(344,'Asia/Bangkok','Asia/Bangkok','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(345,'Asia/Phnom_Penh','Asia/Phnom_Penh','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(346,'Asia/Ho_Chi_Minh','Asia/Ho_Chi_Minh','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(347,'Asia/Vientiane','Asia/Vientiane','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(348,'Asia/Krasnoyarsk','Asia/Krasnoyarsk','North Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(349,'Asia/Novokuznetsk','Asia/Novokuznetsk','North Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(350,'Asia/Novosibirsk','Asia/Novosibirsk','N. Central Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(351,'Asia/Jakarta','Asia/Jakarta','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(352,'Asia/Pontianak','Asia/Pontianak','SE Asia Standard Time',0,25200,0,0,0,0,0,0,0,0,0,0,0),
	(353,'Antarctica/Casey','Antarctica/Casey','W. Australia Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(354,'Australia/Perth','Australia/Perth','W. Australia Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(355,'Asia/Brunei','Asia/Brunei','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(356,'Asia/Makassar','Asia/Makassar','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(357,'Asia/Shanghai','Asia/Shanghai','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(358,'Asia/Macau','Asia/Macau','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(359,'Asia/Choibalsan','Asia/Choibalsan','Ulaanbaatar Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(360,'Asia/Hong_Kong','Asia/Hong_Kong','China Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(361,'Asia/Irkutsk','Asia/Irkutsk','North Asia East Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(362,'Asia/Kuala_Lumpur','Asia/Kuala_Lumpur','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(363,'Asia/Kuching','Asia/Kuching','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(364,'Asia/Manila','Asia/Manila','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(365,'Asia/Singapore','Asia/Singapore','Singapore Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(366,'Asia/Taipei','Asia/Taipei','Taipei Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(367,'Asia/Ulaanbaatar','Asia/Ulaanbaatar','Ulaanbaatar Standard Time',0,28800,0,0,0,0,0,0,0,0,0,0,0),
	(368,'Australia/Eucla','Australia/Eucla','Aus Central W. Standard Time',0,31500,0,0,0,0,0,0,0,0,0,0,0),
	(369,'Asia/Dili','Asia/Dili','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(370,'Asia/Jayapura','Asia/Jayapura','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(371,'Asia/Tokyo','Asia/Tokyo','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(372,'Asia/Seoul','Asia/Seoul','Korea Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(373,'Asia/Pyongyang','Asia/Pyongyang','North Korea Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(374,'Pacific/Palau','Pacific/Palau','Tokyo Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(375,'Asia/Yakutsk','Asia/Yakutsk','Yakutsk Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(376,'Asia/Chita','Asia/Chita','Transbaikal Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(377,'Asia/Khandyga','Asia/Khandyga','Yakutsk Standard Time',0,32400,0,0,0,0,0,0,0,0,0,0,0),
	(378,'Australia/Broken_Hill','Australia/Broken_Hill','Cen. Australia Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),
	(379,'Australia/Adelaide','Australia/Adelaide','Cen. Australia Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),
	(380,'Australia/Darwin','Australia/Darwin','AUS Central Standard Time',0,34200,0,0,0,0,0,0,0,0,0,0,0),
	(381,'Australia/Hobart','Australia/Hobart','Tasmania Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(382,'Australia/Currie','Australia/Currie','Tasmania Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(383,'Australia/Sydney','Australia/Sydney','AUS Eastern Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(384,'Australia/Brisbane','Australia/Brisbane','E. Australia Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(385,'Australia/Lindeman','Australia/Lindeman','E. Australia Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(386,'Australia/Melbourne','Australia/Melbourne','AUS Eastern Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(387,'Pacific/Saipan','Pacific/Saipan','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(388,'Pacific/Guam','Pacific/Guam','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(389,'Pacific/Chuuk','Pacific/Chuuk','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(390,'Antarctica/DumontDUrville','Antarctica/DumontDUrville','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(391,'Pacific/Port_Moresby','Pacific/Port_Moresby','West Pacific Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(392,'Asia/Ust-Nera','Asia/Ust-Nera','Vladivostok Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(393,'Asia/Vladivostok','Asia/Vladivostok','Vladivostok Standard Time',0,36000,0,0,0,0,0,0,0,0,0,0,0),
	(394,'Australia/Lord_Howe','Australia/Lord_Howe','Lord Howe Standard Time',0,37800,0,0,0,0,0,0,0,0,0,0,0),
	(395,'Asia/Srednekolymsk','Asia/Srednekolymsk','Russia Time Zone 10',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(396,'Pacific/Bougainville','Pacific/Bougainville','Bougainville Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(397,'Pacific/Kosrae','Pacific/Kosrae','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(398,'Antarctica/Macquarie','Antarctica/Macquarie','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(399,'Asia/Magadan','Asia/Magadan','Magadan Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(400,'Pacific/Noumea','Pacific/Noumea','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(401,'Pacific/Norfolk','Pacific/Norfolk','Norfolk Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(402,'Pacific/Pohnpei','Pacific/Pohnpei','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(403,'Asia/Sakhalin','Asia/Sakhalin','Sakhalin Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(404,'Pacific/Guadalcanal','Pacific/Guadalcanal','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(405,'Pacific/Efate','Pacific/Efate','Central Pacific Standard Time',0,39600,0,0,0,0,0,0,0,0,0,0,0),
	(406,'Asia/Anadyr','Asia/Anadyr','Russia Time Zone 11',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(407,'Pacific/Fiji','Pacific/Fiji','Fiji Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(408,'Pacific/Tarawa','Pacific/Tarawa','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(409,'Pacific/Kwajalein','Pacific/Kwajalein','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(410,'Pacific/Majuro','Pacific/Majuro','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(411,'Pacific/Nauru','Pacific/Nauru','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(412,'Pacific/Auckland','Pacific/Auckland','New Zealand Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(413,'Antarctica/McMurdo','Antarctica/McMurdo','New Zealand Standard Time',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(414,'Asia/Kamchatka','Asia/Kamchatka','Russia Time Zone 11',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(415,'Pacific/Funafuti','Pacific/Funafuti','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(416,'Pacific/Wake','Pacific/Wake','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(417,'Pacific/Wallis','Pacific/Wallis','UTC+12',0,43200,0,0,0,0,0,0,0,0,0,0,0),
	(418,'Pacific/Chatham','Pacific/Chatham','Chatham Islands Standard Time',0,45900,0,0,0,0,0,0,0,0,0,0,0),
	(419,'Pacific/Apia','Pacific/Apia','Samoa Standard Time',0,46800,0,0,0,0,0,0,0,0,0,0,0),
	(420,'Pacific/Enderbury','Pacific/Enderbury','UTC+13',0,46800,0,0,0,0,0,0,0,0,0,0,0),
	(421,'Pacific/Fakaofo','Pacific/Fakaofo','UTC+13',0,46800,0,0,0,0,0,0,0,0,0,0,0),
	(422,'Pacific/Tongatapu','Pacific/Tongatapu','Tonga Standard Time',0,46800,0,0,0,0,0,0,0,0,0,0,0),
	(423,'Pacific/Kiritimati','Pacific/Kiritimati','Line Islands Standard Time',0,50400,0,0,0,0,0,0,0,0,0,0,0)

	DECLARE @maxTzID INT = 0
	SELECT @maxTzID = MAX(TimeZoneID) FROM SchedTimeZone (NOLOCK)
	IF @maxTzID IS NULL
	BEGIN
		SET @maxTzID = 0
	END
	INSERT INTO SchedTimeZone ([TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]) 
	SELECT @maxTzID + [TimeZoneID], [TimeZoneStdName],[TimeZoneName], [WindowsTimeZoneStdName], [DSTFlag], [Bias], [STDBias], [STDMonth], [STDDayOfWeek], [STDDay], [STDSeconds], [DSTBias], [DSTMonth], [DSTDayOfWeek], [DSTDay], [DSTSeconds], [Flags]
	FROM #SchedtimezoneTemp

	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null
    		DROP TABLE #schedTimezoneTemp

	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@guidSchedtimezone, 'UpdateSchedtimezoneLinux', 'Update schedtimezone for linux CS', @curUtcDateTime, 16, 0 , (16 + 2))

END

-- From SchedtimezonetoRegion.script
-- Delete entries in schedtimezonetoRegion for windows timezones
DELETE FROM SchedTimeZoneToRegion
WHERE tzStdName NOT IN
(
	SELECT timezoneStdName FROM SchedTimezone (NOLOCK) WHERE (Flags&1)=0
)

-- Run below for Linux CS only. Update SchedTimezonetoRegion

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kabul')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kabul', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Yakutat')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Yakutat', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Sitka')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Sitka', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Metlakatla')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Metlakatla', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Juneau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Juneau', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Nome')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Nome', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Anchorage')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Anchorage', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Adak')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Adak', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Barnaul')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Barnaul', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kuwait')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kuwait', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Riyadh')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Riyadh', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Bahrain')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Bahrain', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Aden')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Aden', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Qatar')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Qatar', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Dubai')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Dubai', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Muscat')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Muscat', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Baghdad')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Baghdad', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Jujuy')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Jujuy', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Buenos_Aires')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Buenos_Aires', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Cordoba')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Cordoba', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Salta')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Salta', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Tucuman')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Tucuman', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Catamarca')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Catamarca', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/La_Rioja')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/La_Rioja', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Mendoza')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Mendoza', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Rio_Gallegos')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Rio_Gallegos', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/Ushuaia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/Ushuaia', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/San_Juan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/San_Juan', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Argentina/San_Luis')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Argentina/San_Luis', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Ulyanovsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Ulyanovsk', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Astrakhan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Astrakhan', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Thule')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Thule', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Moncton')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Moncton', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Goose_Bay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Goose_Bay', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Bermuda')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Bermuda', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Glace_Bay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Glace_Bay', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Halifax')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Halifax', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Darwin')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Darwin', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Eucla')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Eucla', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Melbourne')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Melbourne', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Sydney')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Sydney', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Baku')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Baku', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Azores')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Azores', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Scoresbysund')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Scoresbysund', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Bahia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Bahia', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Dhaka')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Dhaka', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Thimphu')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Thimphu', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Minsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Minsk', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Bougainville')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Bougainville', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Regina')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Regina', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Swift_Current')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Swift_Current', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Cape_Verde')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Cape_Verde', 6)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Yerevan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Yerevan', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Broken_Hill')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Broken_Hill', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Adelaide')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Adelaide', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Guatemala')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Guatemala', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Tegucigalpa')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Tegucigalpa', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/El_Salvador')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/El_Salvador', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Managua')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Managua', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Galapagos')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Galapagos', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Costa_Rica')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Costa_Rica', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Belize')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Belize', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Almaty')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Almaty', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Qostanay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Qostanay', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Chagos')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Chagos', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Bishkek')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Bishkek', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Urumqi')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Urumqi', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Vostok')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Vostok', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Cuiaba')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Cuiaba', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Campo_Grande')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Campo_Grande', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Sarajevo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Sarajevo', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Podgorica')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Podgorica', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Skopje')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Skopje', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Tirane')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Tirane', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Prague')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Prague', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Zagreb')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Zagreb', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Ljubljana')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Ljubljana', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Budapest')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Budapest', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Belgrade')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Belgrade', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Bratislava')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Bratislava', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Warsaw')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Warsaw', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Kosrae')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Kosrae', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Macquarie')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Macquarie', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Noumea')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Noumea', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Pohnpei')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Pohnpei', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Guadalcanal')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Guadalcanal', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Efate')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Efate', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Winnipeg')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Winnipeg', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Rainy_River')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Rainy_River', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Resolute')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Resolute', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Rankin_Inlet')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Rankin_Inlet', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/North_Dakota/Beulah')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/North_Dakota/Beulah', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/North_Dakota/Center')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/North_Dakota/Center', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/North_Dakota/New_Salem')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/North_Dakota/New_Salem', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Knox')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Knox', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Tell_City')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Tell_City', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Menominee')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Menominee', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Matamoros')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Matamoros', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Chicago')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Chicago', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Merida')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Merida', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Bahia_Banderas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Bahia_Banderas', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Monterrey')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Monterrey', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Mexico_City')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Mexico_City', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Chatham')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Chatham', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Shanghai')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Shanghai', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Macau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Macau', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Hong_Kong')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Hong_Kong', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Havana')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Havana', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Syowa')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Syowa', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Addis_Ababa')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Addis_Ababa', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Mogadishu')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Mogadishu', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Juba')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Juba', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Asmara')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Asmara', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Djibouti')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Djibouti', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Kampala')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Kampala', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Nairobi')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Nairobi', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Dar_es_Salaam')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Dar_es_Salaam', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Comoro')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Comoro', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Mayotte')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Mayotte', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Antananarivo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Antananarivo', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Brisbane')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Brisbane', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Lindeman')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Lindeman', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Chisinau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Chisinau', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Sao_Paulo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Sao_Paulo', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Easter')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Easter', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Kentucky/Monticello')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Kentucky/Monticello', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Iqaluit')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Iqaluit', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Thunder_Bay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Thunder_Bay', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Nipigon')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Nipigon', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Toronto')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Toronto', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Petersburg')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Petersburg', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Vincennes')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Vincennes', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Kentucky/Louisville')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Kentucky/Louisville', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Nassau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Nassau', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Winamac')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Winamac', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Detroit')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Detroit', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/New_York')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/New_York', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Pangnirtung')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Pangnirtung', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Cancun')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Cancun', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Cairo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Cairo', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Yekaterinburg')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Yekaterinburg', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Fiji')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Fiji', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Mariehamn')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Mariehamn', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Helsinki')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Helsinki', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Tallinn')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Tallinn', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Vilnius')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Vilnius', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Kiev')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Kiev', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Uzhgorod')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Uzhgorod', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Zaporozhye')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Zaporozhye', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Sofia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Sofia', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Riga')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Riga', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Tbilisi')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Tbilisi', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Dublin')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Dublin', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Isle_of_Man')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Isle_of_Man', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Jersey')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Jersey', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Guernsey')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Guernsey', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/London')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/London', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Canary')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Canary', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Lisbon')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Lisbon', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Faroe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Faroe', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Madeira')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Madeira', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Dakar')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Dakar', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Abidjan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Abidjan', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Freetown')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Freetown', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Ouagadougou')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Ouagadougou', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Bamako')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Bamako', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Conakry')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Conakry', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Banjul')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Banjul', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Nouakchott')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Nouakchott', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Reykjavik')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Reykjavik', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Bissau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Bissau', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Monrovia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Monrovia', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/St_Helena')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/St_Helena', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Lome')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Lome', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Accra')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Accra', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Athens')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Athens', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Famagusta')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Famagusta', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Nicosia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Nicosia', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Bucharest')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Bucharest', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Port-au-Prince')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Port-au-Prince', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Tahiti')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Tahiti', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Rarotonga')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Rarotonga', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Honolulu')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Honolulu', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kolkata')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kolkata', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Tehran')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Tehran', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Jerusalem')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Jerusalem', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Amman')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Amman', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Kaliningrad')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Kaliningrad', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Seoul')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Seoul', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Tripoli')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Tripoli', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Kiritimati')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Kiritimati', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Lord_Howe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Lord_Howe', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Magadan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Magadan', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Punta_Arenas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Punta_Arenas', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Palmer')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Palmer', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Marquesas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Marquesas', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Mauritius')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Mauritius', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Reunion')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Reunion', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Mahe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Mahe', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Beirut')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Beirut', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Montevideo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Montevideo', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/El_Aaiun')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/El_Aaiun', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Casablanca')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Casablanca', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Ojinaga')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Ojinaga', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Boise')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Boise', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Inuvik')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Inuvik', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Denver')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Denver', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Cambridge_Bay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Cambridge_Bay', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Edmonton')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Edmonton', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Yellowknife')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Yellowknife', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Chihuahua')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Chihuahua', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Mazatlan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Mazatlan', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Cocos')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Cocos', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Yangon')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Yangon', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Novosibirsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Novosibirsk', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Windhoek')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Windhoek', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kathmandu')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kathmandu', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Auckland')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Auckland', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/McMurdo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/McMurdo', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Johns')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Johns', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Norfolk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Norfolk', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Irkutsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Irkutsk', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Krasnoyarsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Krasnoyarsk', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Novokuznetsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Novokuznetsk', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Pyongyang')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Pyongyang', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Omsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Omsk', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Santiago')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Santiago', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Dawson')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Dawson', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Whitehorse')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Whitehorse', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Vancouver')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Vancouver', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Los_Angeles')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Los_Angeles', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Tijuana')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Tijuana', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Karachi')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Karachi', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Asuncion')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Asuncion', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Ceuta')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Ceuta', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Copenhagen')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Copenhagen', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Madrid')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Madrid', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Paris')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Paris', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Brussels')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Brussels', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Srednekolymsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Srednekolymsk', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Anadyr')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Anadyr', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kamchatka')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kamchatka', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Samara')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Samara', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Simferopol')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Simferopol', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Moscow')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Moscow', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Kirov')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Kirov', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Recife')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Recife', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Maceio')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Maceio', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Fortaleza')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Fortaleza', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Santarem')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Santarem', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Belem')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Belem', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Paramaribo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Paramaribo', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Rothera')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Rothera', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/Stanley')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/Stanley', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Cayenne')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Cayenne', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Cayman')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Cayman', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Atikokan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Atikokan', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Guayaquil')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Guayaquil', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Lima')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Lima', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Rio_Branco')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Rio_Branco', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Eirunepe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Eirunepe', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Bogota')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Bogota', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Jamaica')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Jamaica', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Panama')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Panama', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Manaus')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Manaus', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Boa_Vista')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Boa_Vista', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Porto_Velho')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Porto_Velho', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Grenada')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Grenada', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Dominica')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Dominica', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Lower_Princes')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Lower_Princes', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Santo_Domingo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Santo_Domingo', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Lucia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Lucia', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Kitts')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Kitts', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Puerto_Rico')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Puerto_Rico', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Curacao')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Curacao', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Guyana')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Guyana', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/La_Paz')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/La_Paz', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Port_of_Spain')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Port_of_Spain', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Kralendijk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Kralendijk', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Guadeloupe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Guadeloupe', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Thomas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Thomas', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Tortola')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Tortola', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Antigua')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Antigua', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Anguilla')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Anguilla', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Martinique')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Martinique', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Vincent')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Vincent', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Montserrat')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Montserrat', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Marigot')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Marigot', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Blanc-Sablon')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Blanc-Sablon', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Aruba')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Aruba', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Barbados')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Barbados', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/St_Barthelemy')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/St_Barthelemy', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Miquelon')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Miquelon', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Sakhalin')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Sakhalin', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Apia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Apia', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Saratov')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Saratov', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Christmas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Christmas', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Davis')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Davis', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Jakarta')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Jakarta', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Pontianak')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Pontianak', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Bangkok')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Bangkok', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Phnom_Penh')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Phnom_Penh', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Ho_Chi_Minh')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Ho_Chi_Minh', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Vientiane')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Vientiane', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Brunei')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Brunei', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Makassar')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Makassar', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kuala_Lumpur')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kuala_Lumpur', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Kuching')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Kuching', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Manila')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Manila', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Singapore')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Singapore', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Maseru')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Maseru', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Johannesburg')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Johannesburg', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Mbabane')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Mbabane', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Harare')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Harare', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Bujumbura')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Bujumbura', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Lusaka')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Lusaka', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Gaborone')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Gaborone', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Lubumbashi')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Lubumbashi', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Blantyre')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Blantyre', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Kigali')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Kigali', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Maputo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Maputo', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Colombo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Colombo', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Khartoum')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Khartoum', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Damascus')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Damascus', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Taipei')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Taipei', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Hobart')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Hobart', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Currie')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Currie', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Araguaina')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Araguaina', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Palau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Palau', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Dili')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Dili', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Jayapura')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Jayapura', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Tokyo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Tokyo', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Tomsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Tomsk', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Tongatapu')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Tongatapu', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Chita')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Chita', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Istanbul')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Istanbul', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Grand_Turk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Grand_Turk', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Choibalsan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Choibalsan', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Ulaanbaatar')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Ulaanbaatar', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Vevay')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Vevay', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Indianapolis')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Indianapolis', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Indiana/Marengo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Indiana/Marengo', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Hermosillo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Hermosillo', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Phoenix')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Phoenix', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Fort_Nelson')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Fort_Nelson', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Dawson_Creek')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Dawson_Creek', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Creston')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Creston', 2)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Danmarkshavn')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Danmarkshavn', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Funafuti')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Funafuti', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Wake')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Wake', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Wallis')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Wallis', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Tarawa')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Tarawa', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Kwajalein')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Kwajalein', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Majuro')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Majuro', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Nauru')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Nauru', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Enderbury')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Enderbury', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Fakaofo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Fakaofo', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Noronha')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Noronha', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Atlantic/South_Georgia')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Atlantic/South_Georgia', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Pitcairn')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Pitcairn', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Gambier')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Gambier', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Niue')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Niue', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Pago_Pago')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Pago_Pago', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Midway')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Midway', 11)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'America/Caracas')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'America/Caracas', 3)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Ust-Nera')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Ust-Nera', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Vladivostok')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Vladivostok', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Casey')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Casey', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Australia/Perth')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Australia/Perth', 7)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Tunis')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Tunis', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Luanda')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Luanda', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Lagos')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Lagos', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Niamey')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Niamey', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Ndjamena')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Ndjamena', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Douala')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Douala', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Porto-Novo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Porto-Novo', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Kinshasa')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Kinshasa', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Malabo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Malabo', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Bangui')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Bangui', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Brazzaville')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Brazzaville', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Libreville')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Libreville', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Africa/Algiers')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Africa/Algiers', 1)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Andorra')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Andorra', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Arctic/Longyearbyen')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Arctic/Longyearbyen', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/San_Marino')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/San_Marino', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Rome')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Rome', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Vatican')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Vatican', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Vaduz')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Vaduz', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Vienna')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Vienna', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Zurich')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Zurich', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Monaco')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Monaco', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Malta')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Malta', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Berlin')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Berlin', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Amsterdam')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Amsterdam', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Oslo')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Oslo', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Busingen')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Busingen', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Stockholm')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Stockholm', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Gibraltar')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Gibraltar', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Europe/Luxembourg')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Europe/Luxembourg', 8)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Hovd')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Hovd', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Kerguelen')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Kerguelen', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Indian/Maldives')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Indian/Maldives', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/Mawson')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/Mawson', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Dushanbe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Dushanbe', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Ashgabat')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Ashgabat', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Tashkent')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Tashkent', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Samarkand')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Samarkand', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Oral')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Oral', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Atyrau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Atyrau', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Aqtau')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Aqtau', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Aqtobe')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Aqtobe', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Hebron')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Hebron', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Gaza')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Gaza', 0)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Saipan')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Saipan', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Guam')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Guam', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Chuuk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Chuuk', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Antarctica/DumontDUrville')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Antarctica/DumontDUrville', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Pacific/Port_Moresby')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Pacific/Port_Moresby', 10)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Khandyga')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Khandyga', 5)	
END

IF NOT EXISTS (SELECT 1 FROM SchedTimeZoneToRegion WHERE tzStdName = N'Asia/Yakutsk')	
BEGIN	
	INSERT INTO SchedTimeZoneToRegion (tzStdName, regionId) VALUES (N'Asia/Yakutsk', 5)	
END

-- From TM_Adddefaultschedules.script 

-- update download software schedule
DECLARE @osVersionJobOption INT = 820951902		-- _UNIXDOWNLOADPACKAGES_LINUXOS_X64 820951902
DECLARE @isWindowsUnixOption INT = 1204960069 -- _UPDATEOPTION_IS_UNIX 1204960069	
DECLARE @downloadOptions NVARCHAR(MAX) = '<TMMsg_JobOption>
									<adminOpts>
										<updateOption syncUpdateCaches="1" copyUpdates="1" isWindows="0" copySoftwareAndUpdates="0" invokeLevel="1" majorOnly="1" isSpDelayedDays="1" isUnix="1">
											<clientAndClientGroups _type_="2"/>
											  <downloadUpdatesJobOptions downloadUpdate="1" downloadSoftware="1" copyUpdatesToOneTouchCache="0" />
											  <unixDownloadPackages linuxosX64="1" solarisosX64="0" solsparcos="0" freeBSDos="0" linuxos="0" linuxosPPC64le="0" freeBSDosX64="0" solarisos="0" linuxs390os="0" linuxosS390="0" aixppcos="0" linuxosPPC64="0" darwinosx8664="0" aixos="0" hpos="0" solos="0" aixos5232="0" linuxarm64="0" />
											  <windowsDownloadPackages windowsX64="0" windows32="0" />
										</updateOption>
									</adminOpts>
								</TMMsg_JobOption>'

DECLARE @DownloadSwExec INT = 0
DECLARE @guidForDownloadSwSchedule uniqueidentifier = 'D96E2E50-6E79-4084-9E93-F8ECB277912E'
		
SELECT @DownloadSwExec = 1
	FROM
	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
	WHERE
	gp.SqlScriptGUID = @guidForDownloadSwSchedule
	
DECLARE @l_taskId5		INTEGER
DECLARE @l_subTaskId5	INTEGER
DECLARE @currentTime	INTEGER
SET @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

-- if guid is run already on linux or CS is on windows, then check if the schedule modified time is 0. 
IF @DownloadSwExec = 1 
BEGIN
SELECT TOP 1 @l_taskId5 = S.taskId,  @l_subTaskId5 = subTaskId 
			FROM TM_SubTask S
			JOIN TM_Task T ON T.taskId = S.taskId AND T.modified = 0
WHERE subTaskName = 'System Created Download Software' OR operationType=4019
END
ELSE
BEGIN
	--- For linux CS do one time modification to deselect windows x64 and add linux64 option to handle upgrades to linux OS from windows OS before. 	
	-- Dont check for modified flag since schedule on windows CS may have been modified. 
	SELECT TOP 1 @l_taskId5 = S.taskId,  @l_subTaskId5 = subTaskId 
		FROM TM_SubTask S
		JOIN TM_Task T ON T.taskId = S.taskId 
	WHERE subTaskName = 'System Created Download Software' OR operationType=4019
END				

IF EXISTS(SELECT 1 FROM TM_Subtask(NOLOCK) WHERE subtaskID = @l_subTaskId5)
BEGIN

	UPDATE TM_SubTaskOptions SET value = '0' WHERE subTaskId = @l_subTaskId5 AND optionId = 13353782	--_WINDOWSDOWNLOADPACKAGES_WINDOWS_X64 13353782
	IF NOT EXISTS(SELECT 1 FROM TM_SubTaskOptions (NOLOCK) WHERE subTaskId = @l_subTaskId5 AND optionId = 820951902 )
	BEGIN
		INSERT INTO TM_SubTaskOptions(subTaskID,
			optionID,
			type,
			value)
		VALUES  (@l_subTaskId5,
			820951902,	
			2,
			1)
	END
	ELSE
	BEGIN
		UPDATE TM_SubTaskOptions SET value = '1' WHERE subTaskId = @l_subTaskId5 AND optionId = 820951902	--_UNIXDOWNLOADPACKAGES_LINUXOS_X64 820951902
	END
	
	UPDATE TM_JobOptions
	SET modified = @currentTime
	WHERE subTaskId = @l_subTaskId5
	AND jobId = 0
	AND modified = 0
	AND (
(optionId = 13353782 AND value='1')  --_WINDOWSDOWNLOADPACKAGES_WINDOWS_X64
OR (optionId = 820951902 AND Value='0')	--_UNIXDOWNLOADPACKAGES_LINUXOS_X64
	)
	
	INSERT INTO TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)
	SELECT 0, optionId, type, value, @l_taskId5, @l_subTaskId5, 0, @currentTime, 0
	FROM TM_SubTaskOptions WITH(READUNCOMMITTED) 
	WHERE subTaskId = @l_subTaskId5
	AND optionId = 820951902
	AND NOT EXISTS(SELECT 1 FROM TM_JobOptions
		WHERE subTaskId = @l_subTaskId5
		AND optionId = 820951902
	AND modified = 0)
END

-- From Updatetimezoneinentities.script
DECLARE @guidUpdateEntities uniqueidentifier = '93C8BD02-B488-4197-87D6-F478AF2CD911'
SET @globalParamExec = 0
SELECT @globalParamExec = 1
FROM
    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
WHERE
    gp.SqlScriptGUID = @guidUpdateEntities

IF (@globalParamExec = 0)        -- not done, update it for linux
BEGIN	
BEGIN TRY
       BEGIN TRAN
	IF object_id('tempdb.dbo.#schedTimezoneInfoTemp') is not null
    		DROP TABLE #schedTimezoneInfoTemp
	CREATE TABLE #schedTimezoneInfoTemp
	(
		TimeZoneID				integer		,
		TimeZoneName			nvarchar(510),
		TimeZoneStdName			varchar(255)	,
		WindowsTimeZoneStdName	varchar(255),
		WindowsTzId				INT,
		DSTFlag					INT,
		Bias					INT
	)

	CREATE CLUSTERED INDEX schedTimezoneInfoTemp_WindowsTzId_idx ON #schedTimezoneInfoTemp (WindowsTzId)
	IF object_id('tempdb.dbo.#ClientsScInNeedOfTzUpdate') is not null
    		DROP TABLE #ClientsScInNeedOfTzUpdate

	CREATE TABLE #ClientsScInNeedOfTzUpdate
	(
		ID				INTEGER,
		entityId		INTEGER,
		attrName		NVARCHAR(2048),
		attrVal		    NVARCHAR(2048),
		TimeZoneID		INT
	)	

	CREATE CLUSTERED INDEX ClientsScInNeedOfTzUpdate_entityId_idx ON #ClientsScInNeedOfTzUpdate (entityId)
	-- Enter unix timezones with mapped windows timezones (one unix TZ for each windows TZ)
	INSERT INTO #schedTimezoneInfoTemp
	SELECT  SchedTimezone.TimezoneId, TimezoneName, TimeZoneStdName, WindowsTimeZoneStdName, 
		(
			SELECT TOP 1 WindowsTZ.TimezoneID FROM SchedTimezone WindowsTZ 
			WHERE WindowsTZ.TimezoneStdName = SchedTimeZone.WindowsTimeZoneStdName
			AND (WindowsTZ.flags&1)>0 -- windows timezones have flag 1 set. 
			AND WindowsTZ.WindowsTimeZoneStdName = SchedTimeZone.WindowsTimeZoneStdName
		) WindowsTzId, DSTFlag, Bias/60*-1 
	FROM SchedTimeZone (NOLOCK)
	INNER JOIN 
	(
		-- For each windows timezone, find corresponding unix timezone. 
		SELECT MAX(TimeZoneID) TimeZoneID
		FROM SchedTimeZone(NOLOCK) UnixTZ
		WHERE (UnixTZ.flags&1) = 0 AND UnixTZ.WindowsTimeZoneStdName IS NOT NULL AND LEN(UnixTZ.WindowsTimeZoneStdName)>0
		GROUP By UnixTZ.WindowsTimeZoneStdName
	) T 
	ON T.TimezoneId = SchedTimezone.TimezoneId
	-- Add windows timezones not in above list which are not mapped to any unix TZ
	INSERT INTO #schedTimezoneInfoTemp
	SELECT  0, '', '',WindowsTZ.TimezoneStdName,WindowsTZ.TimezoneId,0,0
	FROM SchedTimezone WindowsTZ 
	LEFT JOIN #schedTimezoneInfoTemp ON #schedTimezoneInfoTemp.WindowsTzId = WindowsTZ.TimezoneId
	WHERE #schedTimezoneInfoTemp.WindowsTzId IS NULL 
	AND WindowsTZ.TimezoneStdName = WindowsTZ.WindowsTimeZoneStdName
	AND (WindowsTZ.flags&1)>0 -- windows timezones have flag 1 set. 	

	-- Set modified as current time for client properties related to timezone. 
	INSERT INTO #ClientsScInNeedOfTzUpdate(ID, entityId , attrName , attrVal, TimeZoneID)	
	SELECT Id, componentNameId,attrName,attrVal,
		(SELECT TOP 1 schedTimezoneTemp.timezoneId FROM #schedTimezoneInfoTemp schedTimezoneTemp
		WHERE APP_ClientProp.attrVal = CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) )
	FROM APP_ClientProp WITH(NOLOCK)
	WHERE attrName IN ('Commcell timezone Id','timezone Id') AND modified = 0 		
	AND attrVal IN 	
	(
		SELECT CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) FROM #schedTimezoneInfoTemp schedTimezoneTemp
	)

	UPDATE App_ClientProp	
	SET modified = @curUtcDateTime
	FROM App_ClientProp INNER JOIN 
	(
		SELECT Id FROM #ClientsScInNeedOfTzUpdate		
		UNION ALL
		--Reset timezone attribute also for clients whose timezone needs to be updated. 
		SELECT App_ClientProp.ID FROM App_ClientProp(NOLOCK)
		INNER JOIN #ClientsScInNeedOfTzUpdate ON App_ClientProp.componentnameId = #ClientsScInNeedOfTzUpdate.entityId
		AND App_ClientProp.attrName = 'Timezone'
		AND App_ClientProp.modified = 0		
	) T
	ON T.Id = App_ClientProp.Id	

	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT entityId, attrName, 8, CAST(TimezoneID AS NVARCHAR(10)), @curUtcDateTime, 0 , 0
	FROM #ClientsScInNeedOfTzUpdate
	WHERE TimezoneID>0
	UNION -- Having union here to have unique attributes inserted. For CS Client, multiple timezone attributes could be inserted. 
	-- One for Timezone ID and one for Commcell timezone Id attribute. 
	SELECT entityId,'Timezone', 1,CAST(DSTflag AS NVARCHAR(10))+':'+CAST(Bias AS NVARCHAR(10))+':'+ TimeZoneStdName, @curUtcDateTime, 0 , 0
	FROM #ClientsScInNeedOfTzUpdate
	INNER JOIN #schedTimezoneInfoTemp ON #ClientsScInNeedOfTzUpdate.TimezoneId = #schedTimezoneInfoTemp.TimezoneId	
	AND #schedTimezoneInfoTemp.TimezoneId>0

	TRUNCATE TABLE #ClientsScInNeedOfTzUpdate
	INSERT INTO #ClientsScInNeedOfTzUpdate(ID, entityId , attrName , attrVal, TimeZoneID)	
	SELECT Id, componentNameId,attrName,attrVal,
		(SELECT TOP 1 schedTimezoneTemp.timezoneId FROM #schedTimezoneInfoTemp schedTimezoneTemp
		WHERE APP_SubclientProp.attrVal = CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) )
	FROM APP_SubclientProp WITH(NOLOCK)
	WHERE attrName = N'timezone Id' AND cs_attrName = CHECKSUM(N'timezone Id') AND modified = 0
	AND attrVal IN 	
	(
		SELECT CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) FROM #schedTimezoneInfoTemp schedTimezoneTemp
	)

	UPDATE APP_SubclientProp	
	SET modified = @curUtcDateTime
	FROM APP_SubclientProp INNER JOIN 
	(
		SELECT Id FROM #ClientsScInNeedOfTzUpdate		
		UNION ALL
		--Reset timezone attribute also for clients whose timezone needs to be updated. 
		SELECT APP_SubclientProp.ID FROM APP_SubclientProp(NOLOCK)
		INNER JOIN #ClientsScInNeedOfTzUpdate ON APP_SubclientProp.componentnameId = #ClientsScInNeedOfTzUpdate.entityId
		AND APP_SubclientProp.attrName = 'Timezone'
		AND cs_attrname = CHECKSUM(N'Timezone')
		AND APP_SubclientProp.modified = 0	
	) T
	ON T.Id = APP_SubclientProp.Id	
	
	INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT entityId, attrName, 8, CAST(TimezoneID AS NVARCHAR(10)), @curUtcDateTime, 0 , 0
	FROM #ClientsScInNeedOfTzUpdate
	WHERE TimezoneID>0
	UNION -- Having union here to have unique attributes inserted. 
	SELECT entityId,'Timezone', 1,CAST(DSTflag AS NVARCHAR(10))+':'+CAST(Bias AS NVARCHAR(10))+':'+ TimeZoneStdName, @curUtcDateTime, 0 , 0
	FROM #ClientsScInNeedOfTzUpdate
	INNER JOIN #schedTimezoneInfoTemp ON #ClientsScInNeedOfTzUpdate.TimezoneId = #schedTimezoneInfoTemp.TimezoneId	
	AND #schedTimezoneInfoTemp.TimezoneId>0

	TRUNCATE TABLE #ClientsScInNeedOfTzUpdate
	-- Update timezone in schedules in TM_Pattern
	 UPDATE TM_Pattern
	 SET tzId = CASE WHEN #schedTimezoneInfoTemp.TimeZoneId>0 THEN #schedTimezoneInfoTemp.TimeZoneId ELSE 1000 END -- Assign cs timezone in case no matching unix TZ
	 FROM TM_Pattern INNER JOIN #schedTimezoneInfoTemp ON #schedTimezoneInfoTemp.windowsTZID = TM_Pattern.tzID
	 AND TM_pattern.tzID NOT IN (1000,10001) -- exclude CS timezones and client timezones. 
	 -- Update Timezone in archgroup table
	 /*
	 #define CVA_AG_TIMEZONE_TYPE_COMMSERV               0
	 #define CVA_AG_TIMEZONE_TYPE_CLIENT                 1
	 #define CVA_AG_TIMEZONE_TYPE_SP                         2
	 */

	 UPDATE ArchGroup
	 SET TimeZone = #schedTimezoneInfoTemp.TimezoneStdName
	 FROM ArchGroup
	 INNER JOIN SchedTimezone (NOLOCK) ON Timezone = SchedTimezone.TimezoneStdName
	 INNER JOIN #schedTimezoneInfoTemp ON #schedTimezoneInfoTemp.windowsTZID = SchedTimezone.TimezoneId
	 WHERE timezoneType = 2

	 IF object_id('tempdb.dbo.#schedulesInNeedOfUpdate') is not null
    		DROP TABLE #schedulesInNeedOfUpdate

	 -- Update in job options
	CREATE TABLE #schedulesInNeedOfUpdate
	(
		subTaskId		INTEGER,
		optionID		INTEGER,
		attrName		NVARCHAR(100),
		attrType		INT,
		newValue        NVARCHAR(2048)
	)	

	CREATE CLUSTERED INDEX schedulesInNeedOfUpdate_subTaskId_idx ON #schedulesInNeedOfUpdate (subTaskId)
	INSERT INTO #schedulesInNeedOfUpdate
	SELECT TM_SubtaskOptions.subTaskID,TM_SubtaskOptions.optionID,'TimeZoneID',8, CAST(#schedTimezoneInfoTemp.TimezoneId AS NVARCHAR(10) )
	FROM TM_SubtaskOptions (NOLOCK)
	INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_SubtaskOptions.OptionId = tm_StaticTaskOption.OptionId
	AND tm_StaticTaskOption.xPath like '%TimezoneId'
	INNER JOIN #schedTimezoneInfoTemp ON CAST(#schedTimezoneInfoTemp.windowsTZID AS NVARCHAR(10)) = TM_SubtaskOptions.Value
	AND #schedTimezoneInfoTemp.TimezoneId>0
	INNER JOIN TM_Subtask (NOLOCK) ON TM_SubtaskOptions.subtaskID = TM_Subtask.subtaskID
	INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_Subtask.taskID WHERE TM_Task.taskType!=1 -- No need to process immediate job requests. 
	UNION ALL
	SELECT TM_SubtaskOptions.subTaskID,TM_SubtaskOptions.optionID,'TimeZoneName', 1, #schedTimezoneInfoTemp.TimeZoneName
	FROM TM_SubtaskOptions (NOLOCK)
	INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_SubtaskOptions.OptionId = tm_StaticTaskOption.OptionId
	AND tm_StaticTaskOption.xPath like '%TimezoneName'
	INNER JOIN SchedTimeZone (NOLOCK) ON SchedTimeZone.timezoneName = TM_SubtaskOptions.Value
	INNER JOIN #schedTimezoneInfoTemp ON #schedTimezoneInfoTemp.windowsTZID  = SchedTimeZone.TimezoneId
	INNER JOIN TM_Subtask (NOLOCK) ON TM_SubtaskOptions.subtaskID = TM_Subtask.subtaskID
	INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_Subtask.taskID WHERE TM_Task.taskType!=1 -- No need to process immediate job requests. 

	-- Age of job options and job xml options
	UPDATE TM_JobXMLOptions
    SET modified = @curUtcDateTime
    FROM    TM_JobXMLOptions
    INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0 AND JobId = 0

	UPDATE TM_JobOptions
	SET modified = @curUtcDateTime
    FROM    TM_JobOptions
    INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_JobOptions.subTaskId 
	AND TM_JobOptions.optionId = subTaskTble.optionId
	AND modified = 0 AND JobId = 0

	-- Update tm_subtaskoptions and Insert into TM_jobOptions
	UPDATE TM_SubtaskOptions
	SET value = newValue
	FROM TM_SubtaskOptions
	INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_SubtaskOptions.subTaskId 
	AND TM_SubtaskOptions.optionId = subTaskTble.optionId

	INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)
    SELECT 0,optionId, attrType, newValue, taskId,#schedulesInNeedOfUpdate.subTaskId,0,@curUtcDateTime,0
    FROM #schedulesInNeedOfUpdate
	INNER JOIN TM_Subtask (NOLOCK) ON #schedulesInNeedOfUpdate.subtaskId = TM_Subtask.subtaskId
	
	INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)
    SELECT  0,TM_JobXMLOptions.xmlValue,TM_JobXMLOptions.taskId,TM_JobXMLOptions.subTaskId,0,@curUtcDateTime, 0
    FROM  TM_JobXMLOptions 
	INNER JOIN 
	(
		SELECT DISTINCT subtaskID FROM #schedulesInNeedOfUpdate 
	)subTaskTble
    ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified=@curUtcDateTime AND  JobId = 0

	IF ( CURSOR_STATUS('global', 'subtaskCursor') >= 0   OR CURSOR_STATUS('local', 'subtaskCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE subtaskCursor
	IF ( CURSOR_STATUS('global','subtaskCursor') = -1     OR CURSOR_STATUS('local','subtaskCursor') = -1 )
		DEALLOCATE subtaskCursor

	DECLARE @l_subTaskId INT
	DECLARE @xPath NVARCHAR(2048), @attrName NVARCHAR(100), @newValue NVARCHAR(2048)
	-- Update xml options with new value. 

	DECLARE subtaskCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			-- Replace first node of xpath below. Xpath below will start with options[1] and we need the root to be TMMsg_JobOption
            SELECT  subTaskId, 'TMMsg_JobOption[1]/'+substring(TM_StaticTaskOption.xPath,11,len(TM_StaticTaskOption.xPath) ) , #schedulesInNeedOfUpdate.attrName,#schedulesInNeedOfUpdate.newValue
            FROM    #schedulesInNeedOfUpdate
			INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_StaticTaskOption.OptionId = #schedulesInNeedOfUpdate.OptionId
    OPEN subtaskCursor
    FETCH NEXT FROM subtaskCursor INTO @l_subTaskId, @xPath , @attrName, @newValue 
    WHILE @@FETCH_STATUS = 0
    BEGIN
		DECLARE @XMLValue NVARCHAR(MAX) = '' 
		SET @XMLValue = '' 
		SELECT @xmlValue = CAST(xmlValue AS NVARCHAR(MAX)) FROM TM_SubTaskXMLOptions (NOLOCK)
		where subTaskId=@l_subTaskId
		DECLARE @xml NVARCHAR(MAX) = CAST( (SELECT @xpath '@xPathElem',  @newValue '@xPathVal', @attrName '@attrName'
		FOR XML PATH('entity'), ROOT('CustomReplacer')) AS NVARCHAR(MAX))

		DECLARE @retainError as int = 1		
		EXEC ReplaceXMLAttributesNew @xmlValue OUTPUT,@xml , 1, @retainerror OUTPUT
		IF @retainerror = 0
		BEGIN
			UPDATE TM_SubTaskXMLOptions
			SET XmlValue = @xmlValue WHERE subtaskId = @l_subTaskId
			UPDATE TM_JobXMLOptions
			SET XmlValue = @xmlValue WHERE subtaskId = @l_subTaskId AND modified = 0
			AND JobId = 0
		END

		FETCH NEXT FROM subtaskCursor INTO @l_subTaskId, @xPath , @attrName, @newValue 
	END
	CLOSE subtaskCursor
	DEALLOCATE subtaskCursor

	-- Delete from runtime so that next runtime s are calculated correctly. 

	DELETE FROM TM_Runtime	
	IF object_id('tempdb.dbo.#schedTimezoneInfoTemp') is not null
    		DROP TABLE #schedTimezoneInfoTemp
	IF object_id('tempdb.dbo.#ClientsScInNeedOfTzUpdate') is not null
    		DROP TABLE #ClientsScInNeedOfTzUpdate
	IF object_id('tempdb.dbo.#schedulesInNeedOfUpdate') is not null
    		DROP TABLE #schedulesInNeedOfUpdate
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@guidUpdateEntities, 'UpdateSchedtimezoneLinux', 'Update schedtimezone for linux CS', @curUtcDateTime, 16, 0 , (16 + 2))

		COMMIT TRAN

	END TRY

BEGIN CATCH
       PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
       ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
       ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
       ERROR MESSAGE: ' + ERROR_MESSAGE() + '
       ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
       ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
       rollback tran
END CATCH


END

SET NOCOUNT OFF
GO


