IF NOT EXISTS (SELECT * from app_clientgroup where name = 'Solr Servers')
BEGIN
	DECLARE @ownerId INT
	DECLARE @solrServerGrpId INT
	DECLARE @errorCode int
	DECLARE @errorString VARCHAR(1024)
	SET @ownerId = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
	DECLARE @EdgeClientsQuery nvarchar (max) 
	DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))

	insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
	values('Solr Servers', 'Select Clients which have solr index configured', 4096, 0, @ownerId, 0, '0', '', 2)		
	SET @solrServerGrpId = @@IDENTITY
		                   
	-- create smart client group for SOLR Index Servers
	--SCG_PKID_SOLR_SERVERS_CLIENT  = 46        
	DECLARE @solrServerXML NVARCHAR(MAX) = '<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="46" propType="1" /> </rules> </rule></rules></scgRule>'
	DECLARE @scgExitCode INT = 0
	DECLARE @scgExitMsg VARCHAR(1024) = ''
        
	EXEC APPSCGV2GenerateQueryParams @solrServerXML, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @EdgeClientsQuery OUTPUT

	IF (@scgExitCode = 0)
	BEGIN
		insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
		values(@solrServerGrpId, 
			@solrServerXML,
			@EdgeClientsQuery,
			1, 0, '0')

		
		--Set the creator with either Master role (that has all capabilities) or with System owner capabilities role (present against entityType(1) and entityID(2) in UMOwnerRoles table)
		DECLARE @edgeDriveCreatorRoleId INT
		DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()

		SET @edgeDriveCreatorRoleId = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityID = 2),
												(SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)))
		EXEC sec_setCreatorForEntity @creatorUserId = 0, 
									@creatorRoleId = @edgeDriveCreatorRoleId, 
									@creatorPermissions = '', 
									@errorCode = @errorCode OUTPUT, 
									@errorString = @errorString OUTPUT, 
									@entityTYpe1 = 28,			/*CLIENT_GROUP_ENTITY*/
									@entityId1 = @solrServerGrpId,
									@creatorUserGroupId = @masterUserGroupId,
									@loggedInUserId = @ownerId 

		DECLARE @createAsUserId INT 
		EXEC sec_getCreateAsUserId 28/*CLIENT_GROUP_ENTITY*/, 
								@solrServerGrpId, 
								@createAsUserId OUTPUT
		UPDATE App_ClientGroup
		SET userId = @createAsUserId
		WHERE id = @solrServerGrpId
		
	END
END
