SET QUOTED_IDENTIFIER ON
GO


-- create a row in the APP_ClientProp table for 'Galaxy Build' for all the clients when CS is upgraded.
---- Following is not needed for 9.0 and above clients
--INSERT INTO APP_ClientProp(	componentNameId, 
--				attrName, 
--				attrType, 
--				attrVal, 
--				created, 
--				modified)
--SELECT  DISTINCT id, 'Galaxy Build', 1, (CASE releaseId WHEN 13 THEN 'BUILD68'
--							WHEN 12 THEN 'BUILD76'
--							WHEN 11 THEN 'BUILD50'
--							WHEN 10 THEN 'BUILD48'
--							ELSE CVSOFTBUILD END),
--		dbo.getUnixTime(getUTCdate()), 0
--FROM   APP_Client C
--WHERE NOT EXISTS (select * from APP_ClientProp P WHERE C.id = P.componentNameId AND P.attrName = 'Galaxy Build' and modified = 0)
DELETE APP_ClientProp where attrName in ('CommCell Explorer', 'CommNet Explorer')

-- MR 52540: 9.0Builld70: Data Classification is upgraded and then uninstalled during an upgrade even if it isnt installed. 
DELETE APP_ClientProp where attrName = 'Data Classification Installed on Client' and attrVal = '0'


INSERT INTO App_ClientProp(	componentNameId, 
				attrName, 
				attrType, 
				attrVal, 
				created, 
				modified)
SELECT componentNameId, 'timezone Id', 8,
			ISNULL((SELECT TimeZoneID FROM SchedTimeZone WHERE TimeZoneStdName = SUBSTRING(attrVal, CHARINDEX(':', attrVal, CHARINDEX(':', attrVal, 0) + 1) + 1, LEN(attrVal))), 0),
			dbo.GetUnixTime(GETUTCDATE()), 0
FROM App_ClientProp
WHERE attrName = 'timezone' AND attrType = 1 AND
	componentNameId NOT IN (select A.componentNameId from APP_ClientProp A where A.attrName = N'timezone Id')

-- New deprecated packages
-- add back N_WIN_PACKAGE_ONLINE_CONTENTINDEXING 
IF NOT EXISTS(SELECT * FROM SIMPACKAGEMAP WHERE simPackageId=253)
	INSERT INTO SIMPACKAGEMAP VALUES(253,93,0,0)
ELSE
	Update SIMPACKAGEMAP SET licType = 0 WHERE simPackageId=253


-- SIM needs to populate APP_ClientProp table to indicate that advanced FS package is installed
INSERT INTO APP_ClientProp
        (componentNameId, 
        attrName, 
        attrType, 
        attrVal, 
        created, 
        modified)
SELECT clientID, N'PackageStateForId ' + CAST(simPackageID as nvarchar(64)), 2, 
ISNULL((SELECT MAX(CASE Optype WHEN 'Install' THEN N'1' else N'0' END) FROM LicUsage WHERE cid = clientID and licType in (1,2)), N'0'),		
dbo.getUNIXTime(GETDATE()), 0
FROM (select clientID, simPackageID from SimInstalledPackages where simPackageID in (1101, 702)) T
WHERE NOT EXISTS (select * from APP_ClientProp A where A.componentNameId = T.ClientId AND attrName = N'PackageStateForId ' + CAST(simPackageID as nvarchar(64)))

--
UPDATE APP_ClientProp
SET	attrVal = 'BUILD84'
FROM    APP_Client
WHERE   APP_ClientProp.attrName = N'Galaxy Build' and APP_ClientProp.modified = 0 AND APP_Client.id = APP_ClientProp.componentNameId AND APP_Client.releaseId = 14

-- Delete dangling license types
DECLARE @licToRemove		TABLE (t_id int, t_name varchar(MAX))
INSERT INTO @licToRemove
SELECT id, short_name FROM simLicAppTypeV2 WHERE id IN (125,158,185)
IF EXISTS (select * from @licToRemove)
BEGIN
	DELETE LicUsage WHERE licType IN (select t_id from @licToRemove)
	DELETE LicAAL WHERE simLicAppTypeId IN (select t_id from @licToRemove)
	DELETE simAppTypeLicTypeMap WHERE simLicAppType IN (select t_id from @licToRemove)
	DELETE simLicAppTypeV2 WHERE id IN (select t_id from @licToRemove)
END

GO

--One time script to update reset limit to 8 in licusagebasedconfig
--BEGIN
DECLARE @resetLimit	INT = 0
DECLARE @licResetCount INT = 0
DECLARE @oldResetLimit INT = 10
DECLARE @newResetLimit INT = 8
DECLARE @attrNameResetLimit NVARCHAR(32) = 'NumOfResetsLimit'
DECLARE @attrNameLicResetCount NVARCHAR(64) = 'NumberOfTimesLicReset'
DECLARE @attrNameLicUsageBasedResetCount NVARCHAR(64) = 'LicUsageBasedNumberOfTimesLicReset'
DECLARE @errCode INT = 0
DECLARE @errString VARCHAR(2048) = ''
SELECT @resetLimit = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = @attrNameResetLimit
BEGIN TRY
IF @resetLimit = @oldResetLimit
BEGIN
	BEGIN TRANSACTION
	UPDATE LicUsageBasedConfig SET attrVal = @newResetLimit where attrName = @attrNameResetLimit
	
	DECLARE @index INT = 0
	DECLARE	@encFld	VARCHAR(2048) = ''
	DECLARE @licDataAttrVal varchar(5000) =''
	DECLARE @dash nvarchar(12) = ':-'
	DECLARE @licData	NVARCHAR(32) = 'LicData' --SZ_LIC_DATA
	DECLARE @licUsageBasedLicData	NVARCHAR(32) = 'LicUsageBasedLicData' --SZ_LIC_DATA_CAL
	declare @temp table(id int, val nvarchar(32))

	WHILE @index < 2
	BEGIN
		SELECT @licResetCount = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = @attrNameLicResetCount
		
		IF @licResetCount >= @newResetLimit AND @licResetCount < @oldResetLimit
			SET @licResetCount = 7
		ELSE IF @licResetCount = @oldResetLimit
			SET @licResetCount = @newResetLimit
			
		SELECT @encFld = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) where attrName = @licData
		IF @encFld <> ''
		BEGIN
			EXEC miscProc2 @encFld, @licDataAttrVal OUTPUT
			IF (@licDataAttrVal IS NULL or LEN(@licDataAttrVal) = 0)
			BEGIN
				SET @errCode = 1
				SET @errString = 'Failure in decrypting the licensing record ' + @encFld
				GOTO EXIT_ERROR
			END
			insert into @temp
			SELECT * from dbo.SplitString(@licDataAttrVal,@dash)
			UPDATE @temp SET val = '-'+CAST(@newResetLimit AS VARCHAR(2)) WHERE id = 7
			UPDATE @temp SET val = '-'+CAST(@licResetCount AS VARCHAR(2)) WHERE id = 4
			SET @licDataAttrVal = ''
			SELECT @licDataAttrVal = (SELECT val + ':'from @temp for xml path(''))
			SELECT @licDataAttrVal = SUBSTRING(@licDataAttrVal,1,LEN(@licDataAttrVal)-1)
			SET @encFld = ''
			EXEC pswEncryptionManaged @licDataAttrVal, @encFld OUTPUT
			IF (@encFld IS NULL or LEN(@encFld) = 0)
			BEGIN
				SET @errCode = 1
				SET @errString = 'Failure in encrypting the licensing record ' + @licDataAttrVal
				GOTO EXIT_ERROR
			END
			UPDATE LicUsageBasedConfig SET attrVal = @encFld where attrName = @licData
			UPDATE LicUsageBasedConfig SET attrVal = @licResetCount where attrName = @attrNameLicResetCount
		END

		SET @licDataAttrVal = ''
		SET @encFld = ''
		SET @licResetCount = 0
		SET @attrNameLicResetCount = @attrNameLicUsageBasedResetCount
		SET @licData = @licUsageBasedLicData
		DELETE @temp
		SET @index = @index+1
	END
	COMMIT TRANSACTION
END
END TRY
BEGIN CATCH
    SELECT @errString = 'Failed to set the reset count ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
    SET @errCode = 1
END CATCH
--END

-- Code to prune LicUsageHistory table
DELETE FROM LicUsageHistory WHERE LicType BETWEEN 100000 AND 110000

IF object_id('tempdb.dbo.#LicPruneTable') IS NOT NULL DROP TABLE #LicPruneTable
CREATE TABLE #LicPruneTable (t_cid INT, t_rid INT,t_attrname varchar(32), t_upgradetime DATETIME, t_rowNum int)

DELETE LH FROM
LicUsageHistory LH LEFT OUTER JOIN APP_Client B ON LH.CId = B.id 
WHERE B.id is NULL AND LicType NOT IN(10,26,71)

DELETE LH FROM
LicUsageHistory LH LEFT OUTER JOIN MMLibrary B ON LH.CId = B.LibraryId 
WHERE B.LibraryId is NULL AND LicType IN(10,26,71)

INSERT INTO #LicPruneTable
SELECT CId,ReleaseId,'',MIN(CreateTimeUTC),ROW_NUMBER() OVER (PARTITION BY Cid ORDER BY ReleaseId DESC)
FROM LicUsageHistory WITH (NOLOCK) WHERE LicType NOT IN(10,26,71) GROUP BY CId,ReleaseId

UPDATE #LicPruneTable
SET t_attrname = 'Release ' + release
FROM simAllGalaxyRel WHERE id = t_rid

--Convert UTC time to local before storing
INSERT INTO APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
SELECT t_cid,t_attrname,2,dbo.GetUnixTime(t_upgradetime),dbo.GetUnixTime(getUTCDate()),0,0 FROM #LicPruneTable
WHERE NOT EXISTS(SELECT id FROM APP_ClientProp WHERE componentNameId = t_cid AND attrName = t_attrname )

DELETE LH FROM
LicUsageHistory LH JOIN #LicPruneTable PT
ON CId = t_cid AND t_rid = ReleaseId AND t_rowNum > 3 AND LicType NOT IN(10,26,71)

IF object_id('tempdb.dbo.#LicPruneTable') IS NOT NULL DROP TABLE #LicPruneTable

--Fix package names
UPDATE SimPackage SET displayName = 'Storage Accelerator' WHERE displayName = 'mediaAgent Core'

-- To delete dangling row for package [Metrics Reporting] which was QNet with no license required. It becomes dangling after the following form made in 2015
-- Update Form: 72828 (11.0 B72) via AutoCheckin. MR: 137287 - Summary: [Rename references of CommNet to Metrics Reporting]
DELETE APP_ClientProp WHERE AttrName = 'PackageStateForId 727'

--Making displayName column clientName -DN
IF EXISTS (SELECT 1 FROM GxGlobalParam where name = 'MangleDisplayName-e2acfa22' AND value = '1')
BEGIN
	UPDATE APP_Client SET displayName = FORMATMESSAGE('%s-DN', name) WHERE id > 1 and displayName = name
END

--
IF EXISTS (SELECT 1 FROM SImInstalledPackages WHERE clientID=2 AND SimPackageID IN (801, 851) AND HighestSP < 21)
BEGIN
	UPDATE SimInstalledPackages SET Baseline = -1
	EXEC UpdateBaseline -1, 0, 0
END

EXIT_ERROR:
IF @errCode = 1
BEGIN
	ROLLBACK TRANSACTION
    PRINT @errString
    RAISERROR(@errString, 16,1)
END
GO

-- MR287301
DELETE FROM APP_ClientProp
WHERE attrname = 'PackageStateForId 1' AND componentNameId IN (SELECT id from App_Client where releaseId > 14)

SET QUOTED_IDENTIFIER OFF
GO
