SET QUOTED_IDENTIFIER ON
GO

DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'
DECLARE @clientId INT = 0
DECLARE @clientName VARCHAR(MAX) = ''
DECLARE @swCachePath VARCHAR(MAX) = ''
DECLARE @tmpConfigResultTbl 		TABLE(t_ID INT, t_errorCode INT, t_errorString VARCHAR(MAX))

BEGIN TRY

--get active failover node client id
SET @clientId = ISNULL((SELECT TOP 1 componentNameId FROM App_ClientProp WHERE
							   attrName='Linked CS Client' AND modified=0 AND
							   attrVal = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE 
												 componentNameId=2 AND attrName = 'Active CS Client' AND modified=0),0)),0)
														
IF @clientId=0
BEGIN
    SET @errorString=N'Active Failover client is not found'
	GOTO EXIT_ERROR
END

--get active failover client name
SELECT @clientName=name FROM APP_Client WITH(NOLOCK) WHERE id = @clientId

--Remote cache is/was configured. Let's not overwrite the configuration
IF EXISTS (SELECT TOP 1 ID FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId=@clientId AND attrName = 'Failover Remote cache sync' AND modified=0)
BEGIN
	SET @errorString=N'Remote cache was already configured for active failove client [' + @clientName + ']'
	GOTO EXIT_ERROR
END

--get CS software cache path
SELECT @swCachePath=value FROM GXGlobalParam WHERE name like 'Patch Directory' AND modified=0

INSERT INTO @tmpConfigResultTbl EXEC simConfigureAutomaticRemoteCacheOnFailoverClient @clientName, @clientId, @swCachePath, 1
SELECT TOP 1 @errorCode = t_ErrorCode, @errorString = t_ErrorString FROM @tmpConfigResultTbl

END TRY
BEGIN CATCH
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH

EXIT_ERROR:
IF @errorCode <> 0
BEGIN
	PRINT 'ERROR: [' + @errorString +']. Rolling back Transaction'
END
GO

SET QUOTED_IDENTIFIER OFF
GO
										