
-- Script will check if there is enough space available for database upgrade
-- Space available should be greater than or equal to size of the database

DECLARE @TempLogFiles TABLE (LogicalName nvarchar(256), PhysicalName nvarchar(max))
DECLARE	@databaseName nvarchar(256) = DB_NAME()
DECLARE	@logFileName nvarchar(256)
DECLARE	@isCursorOpen INTEGER = 0

DECLARE @errorCode INTEGER 
SET		@errorCode = 0

-- Get the Log file information
INSERT INTO @TempLogFiles
SELECT	mf.name, mf.physical_name
FROM sys.master_files AS mf
WHERE mf.database_id = DB_ID(@databaseName)
	AND mf.type_desc = 'LOG'

SET	@errorCode	=	@@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

DECLARE LogFileCursor CURSOR FOR
SELECT	LogicalName
FROM	@TempLogFiles

OPEN LogFileCursor
SET		@isCursorOpen = 1

FETCH LogFileCursor INTO @logFileName

WHILE @@FETCH_STATUS = 0
BEGIN
	DBCC SHRINKFILE (@logFileName) WITH NO_INFOMSGS
	
	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
	
	FETCH LogFileCursor INTO @logFileName
END


CX_EXIT: 
	IF (@isCursorOpen = 1)
	BEGIN
		CLOSE LogFileCursor
		DEALLOCATE LogFileCursor
	END
	
	IF @errorCode != 0 
	BEGIN
		PRINT 'Failed to shrink the log files.'
	END
	ELSE
	BEGIN
		PRINT 'Successfully shrinked the log files.'
	END
			
	RETURN
		
