
declare @dbName nvarchar(128) = DB_NAME()
declare @releaseId int = (select max(id) from simAllGalaxyRel)
declare @releaseNum varchar(128) = (select release from simAllGalaxyRel where id = @releaseId )
declare @buildNum int = (select buildNum from simAllGalaxyRel where id = @releaseId )


DECLARE @upgradeInProgressStepNumber INTEGER = 0
IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1) 
BEGIN
	SELECT @upgradeInProgressStepNumber = id FROM DBUpgradeSteps where Step = 'UpgradeInProgress'
	if @upgradeInProgressStepNumber > 0
	begin
		select @releaseId = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'
		select @releaseNum = release from simAllGalaxyRel where id = @releaseId
		select @buildNum = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromBuild'
	end
END


if @releaseNum = '11' and @buildNum = 60
begin

  if exists (SELECT 1 FROM sys.databases WHERE name = @dbName and @dbName <> 'master' and recovery_model_desc <> 'SIMPLE')
  begin
	declare @SQLString nvarchar (1024)
	SET @SQLString = N'ALTER DATABASE [' + @dbName + N'] SET RECOVERY SIMPLE'
	EXECUTE( @SQLString )
  end

end