

SET QUOTED_IDENTIFIER ON
GO

SET NOCOUNT ON
GO

DECLARE @sanitizeSystemCreatedClientGroupScriptExec INT = 0
SELECT
    @sanitizeSystemCreatedClientGroupScriptExec = 1
FROM
    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
WHERE
    gp.SqlScriptGUID = '66280335-4DB1-43DD-ACC4-77BE976A2E0B'

IF (@sanitizeSystemCreatedClientGroupScriptExec = 0)
BEGIN
	
	DECLARE @unixTime INT = dbo.getUnixTime(GETDATE())	
	DECLARE @clientGroupId  INT = NULL
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = 'Media Agents')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 1)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 1, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END

	
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = 'Laptop Clients')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 2)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 2, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END
	
	
	--Infrastructure Client Group
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE (flag & 0x80000) != 0)
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 3)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 3, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END
	
	
	--Proxy Clients Client Group
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE (flag & 0x100000) != 0)
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 4)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 4, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END
	
	
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = 'HAC Cluster')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 5)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 5, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END
	
	--Edge Clients Client Group
	SET @clientGroupId = NULL
	--For Flag please refer AppSyncCreateEdgeSCG.sp
	SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE (flag & (CAST(0x1000 AS INT) | CAST(0x2000000 AS INT)) = (CAST(0x1000 AS INT) | CAST(0x2000000 AS INT))))
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 6)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 6, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END
	
	--Storage Pool Client Group
	SET @clientGroupId = NULL	
	SET @clientGroupId = (SELECT TOP 1 A.id from APP_ClientGroup A, APP_AdvanceSettings B where A.id = B.EntityId AND B.EntityType = 28 AND B.keyName = 'StoragePool' AND B.relativePath = 'CommServDB.MediaAgent')

	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 6)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 7, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END


	--Index Servers
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT TOP 1 id FROM APP_ClientGroup WHERE name = 'Index Servers')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 8)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 8, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END


	--Content Analyzer Cloud
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT TOP 1 id FROM APP_ClientGroup WHERE name = 'Content Analyzer Cloud')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 9)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 9, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END


	--CS Failover Clients
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT TOP 1 App_ClientGroup.id FROM App_ClientGroup INNER JOIN APP_componentProp  ON App_ClientGroup.Id = APP_componentProp.componentId
							AND APP_componentProp.componentType = 8 AND APP_componentProp.propertyTypeId = 1301
							AND APP_componentProp.dataType = 10 AND APP_componentProp.modified = 0)
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 10)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 10, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END


	--CS Failover Install Clients
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT TOP 1 App_ClientGroup.id FROM App_ClientGroup INNER JOIN APP_componentProp (NOLOCK) ON App_ClientGroup.Id = APP_componentProp.componentId
			AND APP_componentProp.componentType = 8 AND APP_componentProp.propertyTypeId = 1302
			AND APP_componentProp.dataType = 10 AND APP_componentProp.modified = 0)
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 11)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 11, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END

	-- Recall Enabled
	SET @clientGroupId = NULL
	SET @clientGroupId = (SELECT TOP 1 id FROM APP_ClientGroup WHERE name = 'Recall Enabled')
	
	IF @clientGroupId IS NOT NULL AND @clientGroupId <> 0
	BEGIN 
	
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'Client Group Unique Id' AND modified = 0 AND attrVal = 12)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'Client Group Unique Id', 7, 12, @unixTime, 0)
						
		END				
		
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @clientGroupId AND attrName = 'System Created' AND modified = 0 AND attrVal = 0)
		BEGIN 
		
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@clientGroupId, 'System Created', 7, 0, @unixTime, 0)
		
		END 
	
	END

	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES('66280335-4DB1-43DD-ACC4-77BE976A2E0B', 'SanitizeSystemCreatedClientGroup', 'adding system default properties in client group', @unixTime, 16, 0 , 16 + 1)
	
END

SET NOCOUNT OFF
GO
