-- Add SMConfigs entries for each array in SMControlHost

SET NOCOUNT ON
GO

DECLARE @MMSM_AT_ARRAY	INTEGER = 3
DECLARE @currTime		INTEGER = dbo.GetUnixTime(GetUTCDate())

DECLARE @array	TABLE (
	ControlHostId		INTEGER,
	SMArrayId			NVARCHAR(1024),		-- MMS2_HOSTNAMELEN
	DeviceGroupName		NVARCHAR(1024),
	SMHostOption		INTEGER,
	SnapVendorId		INTEGER,
	SnapVendorName		NVARCHAR(128)		-- MM_SM_ENGINE_VENDORNAME_LEN
)

DECLARE @devGrpConfigIds TABLE (
	Id	INTEGER
)

BEGIN TRANSACTION

	-- Gather vendor info about each existing array
	INSERT	INTO @array
	SELECT	CH.ControlHostId, CH.SMArrayId, CH.DeviceGroupName, CH.SMHostOption, VEN.Id, CH.SnapVendorName
	FROM	SMControlHost CH WITH (NOLOCK), SMVendor VEN WITH (NOLOCK)
	WHERE   CH.SnapShotEngineName = VEN.Name
	AND		CH.ControlHostId > 0

	-- Get MasterConfigId for all "Device group" and "Device group option" configs
	INSERT	INTO @devGrpConfigIds
	SELECT	Id
	FROM	SMMasterConfigs WITH (NOLOCK)
	WHERE	KeyName IN (	'SMCONFIG_NAME_HOST_DEVICE_GROUP',
							'SMCONFIG_NAME_STORAGE_DEVICE_GROUP',
							'SMCONFIG_NAME_USE_DEVICES_ONLY_FROM_THIS_GROUP',
							'SMCONFIG_NAME_USE_UNGROUPED_DEVICES')

	-- Set default config values for each array (skip device group and device group options - that will be set later)
	INSERT	INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)
	SELECT	MC.Id, ARR.ControlHostId, ARR.ControlHostId, @MMSM_AT_ARRAY, 1, 1, 0, MC.DefaultInt, MC.DefaultLL, MC.DefaultStr, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
	FROM	SMMasterConfigs MC WITH (NOLOCK), @array ARR 
	WHERE	MC.VendorId = ARR.SnapVendorId
	AND		ARR.ControlHostId > 0
	AND		MC.Id not in (SELECT Id FROM @devGrpConfigIds)
	AND		NOT EXISTS	(	SELECT * 
							FROM SMConfigs SC WITH (NOLOCK)
							WHERE  SC.MasterConfigId = MC.Id
							AND	   SC.ArrayId = ARR.ControlHostId
						)

	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END
	
	-- Copy 'Device Group' from SMControlHost
	INSERT	INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)
	SELECT	MC.Id, ARR.ControlHostId, ARR.ControlHostId, @MMSM_AT_ARRAY, 1, 1, 0, MC.DefaultInt, MC.DefaultLL, ARR.DeviceGroupName, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
	FROM	SMMasterConfigs MC WITH (NOLOCK), @array ARR 
	WHERE	MC.VendorId = ARR.SnapVendorId
	AND		ARR.ControlHostId > 0
	AND		MC.Id IN	(	SELECT Id 
							FROM SMMasterConfigs WITH (NOLOCK) 
							WHERE KeyName IN ('SMCONFIG_NAME_HOST_DEVICE_GROUP', 'SMCONFIG_NAME_STORAGE_DEVICE_GROUP')
						)
	AND		NOT EXISTS	(	SELECT * 
							FROM SMConfigs SC WITH (NOLOCK)
							WHERE  SC.MasterConfigId = MC.Id
							AND	   SC.ArrayId = ARR.ControlHostId
						)

	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END

	-- Copy 'Use devices only from this group' from SMControlHost
	INSERT	INTO SMConfigs (MasterConfigId, ArrayId, AssocId, AssocType, ShowInGUI, IsValid, EngineId, ValueInt, ValueLL, ValueStr, Created, Modified, OrigCCId, GUID, ReserveFieldInt1, ReserveFieldInt2, ReserveFieldInt3, ReserveFieldInt4, ReserveFieldStr)
	SELECT	MC.Id, ARR.ControlHostId, ARR.ControlHostId, @MMSM_AT_ARRAY, 1, 1, 0, ARR.SMHostOption, MC.DefaultLL, MC.DefaultStr, @currTime, 0, 2, newid(), 0, 0, 0, 0, N''
	FROM	SMMasterConfigs MC WITH (NOLOCK), @array ARR 
	WHERE	MC.VendorId = ARR.SnapVendorId
	AND		ARR.ControlHostId > 0
	AND		MC.Id IN	(	SELECT Id 
							FROM SMMasterConfigs WITH (NOLOCK) 
							WHERE KeyName IN ('SMCONFIG_NAME_USE_DEVICES_ONLY_FROM_THIS_GROUP',	'SMCONFIG_NAME_USE_UNGROUPED_DEVICES')
						)
	AND		NOT EXISTS	(	SELECT * 
							FROM SMConfigs SC WITH (NOLOCK)
							WHERE  SC.MasterConfigId = MC.Id
							AND	   SC.ArrayId = ARR.ControlHostId
						)

	IF @@ERROR <> 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION

RETURN
GO
