SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
GO

BEGIN TRANSACTION TranResetAppAwareRefTime
	
IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '00805CB6-9DCF-4D10-8F99-97EA9E4A3A6C')
BEGIN
	DECLARE @currentTime 				INTEGER
	DECLARE @attrType 					INTEGER
	DECLARE	@attrName						VARCHAR(1024)
	DECLARE	@attrVal						VARCHAR(1024)
	DECLARE @errorCode					INTEGER
		
	SET 	@currentTime 					= dbo.GetUnixTime(GETUTCDATE())
	SET 	@attrType							= 7
	SET 	@attrName							= 'Reason last backup time cleared'
	SET 	@attrVal							= 45 	--CV_CLEAR_SELECTIVE_COPY_ON_STORAGE_POLICY
	SET		@errorCode						= 0	

	DECLARE @checkSumSysFullCycleNum INTEGER	
	SET @checkSumSysFullCycleNum = CHECKSUM(N'sys:full cycle num')
	
	DECLARE @checkSumSysLastFull INTEGER
	SET @checkSumSysLastFull = CHECKSUM(N'sys:last full')

	DECLARE @checkSumLastBkpTimeCleared INTEGER
	SET @checkSumLastBkpTimeCleared = CHECKSUM(N'Reason last backup time cleared')			
		
	if object_id('tempdb.dbo.#tblAppIdToReset') is not null DROP TABLE #tblAppIdToReset	

	CREATE TABLE #tblAppIdToReset ( appId INTEGER PRIMARY KEY (appId) )
	
	-- Get AppAware parent appId to reset reftime
	INSERT	INTO #tblAppIdToReset
	SELECT	DISTINCT A.parentAppId
	FROM	JMVSAAppJobLink A WITH (NOLOCK), App_Application APP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE A.parentAppId = APP.id
	AND		APP.dataArchGrpId = AGC.archGroupId
	AND		AGC.isActive = 1
	AND		AGC.type = 2
	
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT

	-- Do not consider the new appId for which no jobs are run at all
	DELETE #tblAppIdToReset
	FROM #tblAppIdToReset APP LEFT OUTER JOIN APP_SubClientProp PROP WITH (NOLOCK)
	ON	APP.appId = PROP.componentNameId
	AND	PROP.attrName = N'sys:full cycle num'
	AND PROP.cs_attrName = @checkSumSysFullCycleNum
	AND PROP.attrVal != '0'
	AND PROP.modified = 0
	WHERE PROP.componentNameId IS NULL

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
		
	-- Reset only those appId for which attrVal is not reset by any other process
	DELETE	#tblAppIdToReset
	FROM	#tblAppIdToReset APP LEFT OUTER JOIN APP_SubClientProp PROP WITH (NOLOCK)
	ON	APP.appId = PROP.componentNameId
	AND	PROP.attrName = N'sys:last full'
	AND	PROP.cs_attrName = @checkSumSysLastFull
	AND	PROP.modified = 0
	WHERE PROP.componentNameId IS NULL
	OR 		PROP.attrVal 	= '0' 
	OR 		PROP.attrVal 	= ''
			
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT

	DELETE	APP_SubClientProp 
	FROM 		APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'sys:last full'
	AND		PROP.cs_attrName = @checkSumSysLastFull	
	AND		modified 	= 0
	AND   attrVal 	!= '0' 
	AND		attrVal 	!= ''
	
	SELECT	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT

	UPDATE	APP_SubClientProp 
	SET 	modified = @currentTime
	FROM 	APP_SubClientProp PROP, #tblAppIdToReset APP
	WHERE	PROP.ComponentNameId = APP.appId
	AND		PROP.attrName = N'Reason last backup time cleared' 
	AND		PROP.cs_attrName = @checkSumLastBkpTimeCleared
	AND		PROP.modified = 0

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
		
	INSERT INTO APP_SubClientProp 
	SELECT 	APP.AppId, @attrName, @attrType, @attrVal, @currentTime, 0, 0
	FROM 		#tblAppIdToReset APP
	
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT
	
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES('00805CB6-9DCF-4D10-8F99-97EA9E4A3A6C', 'ResetRefTimeForAppAwareSC', 'Reset reftime for AppAware subclients', @currentTime, 16, 0, 18)
	
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_ERROR_EXIT	
	
	GOTO CX_EXIT
END
	
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TranResetAppAwareRefTime
	RETURN
			
CX_EXIT:
	COMMIT TRANSACTION TranResetAppAwareRefTime
	RETURN


		
