SET NOCOUNT ON

DECLARE @errorVal INTEGER
SET     @errorVal = 0

BEGIN TRANSACTION

BEGIN TRY
	DECLARE @nowTime INTEGER

	Set @nowTime =  dbo.GetUnixTime(GetUTCdate())
	
	--If it is upgrade from v9 release , set SendLogsUseHTTPProxy and CommservUseHTTPProxyAuthentication field based on SendLogsHTTPProxySite and SendLogsHTTPProxyUser respectively.
	IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) = 14)
	BEGIN 
		DECLARE @sendLogProxyUrl NVARCHAR(MAX) = ''
		SELECT @sendLogProxyUrl = value FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxySite' And modified = 0

		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsUseHTTPProxy' AND modified = 0)	
			BEGIN															
    				INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        						VALUES ('SendLogsUseHTTPProxy', '', @nowTime, 0)                			
			END

		--if some send log proxy site value exists, set SendLogsUseHTTPProxy to 1.
		IF len(ISNULL(@sendLogProxyUrl,'')) > 0
		BEGIN
				
			UPDATE GXGlobalParam set value = '1'  WHERE name = 'SendLogsUseHTTPProxy'	AND modified = 0
		END
		ELSE
		BEGIN
			UPDATE GXGlobalParam set value = '0'  WHERE name = 'SendLogsUseHTTPProxy'	AND modified = 0
		END


		DECLARE @sendLogProxyUser NVARCHAR(MAX) = ''
		SELECT @sendLogProxyUser = value FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxyUser' And modified = 0

		--if send log proxy user value exists, set CommservUseHTTPProxyAuthentication to 1.
		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'CommservUseHTTPProxyAuthentication' AND modified = 0)	
		BEGIN															
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        					VALUES ('CommservUseHTTPProxyAuthentication', '', @nowTime, 0)                			
		END

		IF len(ISNULL(@sendLogProxyUser,'')) > 0
		BEGIN
				
			UPDATE GXGlobalParam set value = '1'  WHERE name = 'CommservUseHTTPProxyAuthentication'	AND modified = 0
		END
		ELSE
		BEGIN
			UPDATE GXGlobalParam set value = '0'  WHERE name = 'CommservUseHTTPProxyAuthentication'	AND modified = 0
		END

	END

	IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Server' AND value <> '' AND modified = 0)
	BEGIN	

		DECLARE @sendLogsProxyURL NVARCHAR(MAX) = ''
	
		SELECT @sendLogsProxyURL = value FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxySite'  AND modified = 0

		-- check if send log file entries are present, if not present, copy them FROM patch setting
		IF @sendLogsProxyURL = ''
		BEGIN
			DECLARE @patchProxyURL NVARCHAR(MAX) = ''

			DECLARE @patchProxyPort NVARCHAR(MAX) = ''

			DECLARE @patchProxyUser NVARCHAR(MAX) = ''

			DECLARE @patchProxyPassword NVARCHAR(MAX) = ''

			SELECT @patchProxyURL = value FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Server'  AND modified = 0

			SELECT @patchProxyPort = value FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Port'  AND modified = 0

			SELECT @patchProxyUser = value FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Username'  AND modified = 0

			SELECT @patchProxyPassword = value FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Password'  AND modified = 0
		                    	
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxySite' AND modified = 0)	
			BEGIN															
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        					VALUES ('SendLogsHTTPProxySite', '', @nowTime, 0)                			
			END
	
			UPDATE GXGlobalParam set value = @patchProxyURL  WHERE name = 'SendLogsHTTPProxySite'	AND modified = 0
		    
			--if some proxy site value exists, set SendLogsUseHTTPProxy to 1.
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsUseHTTPProxy' AND modified = 0)	
			BEGIN															
    				INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        						VALUES ('SendLogsUseHTTPProxy', '', @nowTime, 0)                			
			END

			IF len(ISNULL(@patchProxyURL,'')) > 0
			BEGIN
				
				UPDATE GXGlobalParam set value = '1'  WHERE name = 'SendLogsUseHTTPProxy'	AND modified = 0
			END
			ELSE
			BEGIN
				UPDATE GXGlobalParam set value = '0'  WHERE name = 'SendLogsUseHTTPProxy'	AND modified = 0
			END
			                	
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxyPort' AND modified = 0)	
			BEGIN															
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        					VALUES ('SendLogsHTTPProxyPort', '', @nowTime, 0)                			
			END
	
			UPDATE GXGlobalParam set value = @patchProxyPort  WHERE name = 'SendLogsHTTPProxyPort'	AND modified = 0
		                    	
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxyUser' AND modified = 0)	
			BEGIN															
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        					VALUES ('SendLogsHTTPProxyUser', '', @nowTime, 0)                			
			END
	
			UPDATE GXGlobalParam set value = @patchProxyUser  WHERE name = 'SendLogsHTTPProxyUser'	AND modified = 0
		       
			--if some proxy user value exists, set CommservUseHTTPProxyAuthentication to 1.
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'CommservUseHTTPProxyAuthentication' AND modified = 0)	
			BEGIN															
    				INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        						VALUES ('CommservUseHTTPProxyAuthentication', '', @nowTime, 0)                			
			END

			IF len(ISNULL(@patchProxyUser,'')) > 0
			BEGIN
				
				UPDATE GXGlobalParam set value = '1'  WHERE name = 'CommservUseHTTPProxyAuthentication'	AND modified = 0
			END
			ELSE
			BEGIN
				UPDATE GXGlobalParam set value = '0'  WHERE name = 'CommservUseHTTPProxyAuthentication'	AND modified = 0
			END
			             	
			IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'SendLogsHTTPProxyPassword' AND modified = 0)	
			BEGIN															
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        					VALUES ('SendLogsHTTPProxyPassword', '', @nowTime, 0)                			
			END
	
			UPDATE GXGlobalParam set value = @patchProxyPassword  WHERE name = 'SendLogsHTTPProxyPassword'	AND modified = 0

		END
	
		DELETE FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Server'
	
		DELETE FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Port'
	
		DELETE FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Username'
	
		DELETE FROM GXGlobalParam WHERE name = 'Patch Download HTTP Proxy Password'

	END

	COMMIT TRANSACTION
	
	RETURN
	
END TRY

BEGIN CATCH
	
    ROLLBACK TRANSACTION
		
	PRINT 'Failed to remove stale patch HTTP proxy settings'

END CATCH
