-- Removing Content Indexing Report schedules when upgrade from 9.0
SET NOCOUNT ON
GO

BEGIN TRANSACTION
--1.	Schedules should be deleted from table TM_SubTask
--2.	Report schedules will have operationType 4004.
--3.	Need to look for the report type in TM_SubTaskOptions table with optionId 2039186688.
--4.	Delete all rows from TM_SubTask with TM_Subtask.operationType = 4004 and TM_SubTaskOptions.optionId = 2039186688 AND Value = 7788


	DECLARE	@errorCode	INTEGER			=	0;
	DECLARE @errorString VARCHAR(1024)	=	'';	
	DECLARE @bCIRptSched INTEGER		=	0;
	
	IF NOT EXISTS(SELECT * FROM TM_SubTask ST JOIN TM_SubTaskOptions STO ON ST.subTaskId = STO.subTaskId  WHERE ST.operationType = 4004 AND STO.optionId = 2039186688 AND STO.value = '7788')
	BEGIN
		SET @errorCode		=	0
		SET @errorString	=	'CI Report schedules do not exist. Nothing to remove in upgrade'
		SET @bCIRptSched	=	0;
		GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		SET @bCIRptSched	=	1;
		
		DECLARE @subTaskToBeDltd TABLE (subTaskID INT, taskId INT);
		
		INSERT INTO @subTaskToBeDltd
		SELECT	ST.subTaskId, ST.taskId
		FROM	TM_SubTask ST
					JOIN	TM_SubTaskOptions STO
						ON ST.subTaskId	= STO.subTaskId
		WHERE ST.operationType = 4004
				AND STO.optionId = 2039186688
				AND STO.value	 = '7788'
								
		DELETE
		FROM TM_SubTask
		WHERE subTaskId IN (SELECT subTaskId FROM @subTaskToBeDltd)
		
		SELECT	@errorCode = @@ERROR
		IF		@errorCode <> 0
		BEGIN
				SET @errorString = 'Failed to Remove rows from TM_SubTask in postUpgrade script RemoveCntIdxSchedules.sql'
				GOTO CX_ERROR_EXIT
		END
		
		DELETE
		FROM TM_Task
		WHERE taskId IN (SELECT taskId FROM @subTaskToBeDltd)
		
		SELECT	@errorCode = @@ERROR
		IF		@errorCode <> 0
		BEGIN
				SET @errorString = 'Failed to Remove rows from TM_Task in postUpgrade script RemoveCntIdxSchedules.sql'
				GOTO CX_ERROR_EXIT
		END
		
	END
CX_ERROR_EXIT:
	
	IF (@errorCode <> 0)
	BEGIN
		SELECT @errorCode, @errorString
		ROLLBACK TRANSACTION
	END	
	ELSE
	BEGIN
		COMMIT TRANSACTION		
	END
	
RETURN
GO
