-- Removing Analytics policy when upgrade from 9.0
SET NOCOUNT ON
GO

IF EXISTS (SELECT 1 FROM archGroup WHERE type = 4)
BEGIN
	BEGIN TRANSACTION
		--USE CommServ
		DECLARE	@errorCode	INTEGER = 0;
		DECLARE @errorString VARCHAR(1024) = 'SP Analytics Policy has been deleted successfully';
		
		DECLARE @analyticsSPId INT = 0
		
		DECLARE @temp TABLE (analyticsSPId int)
		INSERT INTO @temp SELECT id FROM archGroup WHERE type = 4
		
		DECLARE cur CURSOR FOR SELECT analyticsSPId FROM @temp
		OPEN cur
		FETCH NEXT FROM cur INTO @analyticsSPId
		WHILE ((@@FETCH_STATUS = 0) AND (@errorCode = 0))
		BEGIN
			UPDATE APP_Application 
			SET dataArchGrpID = 1, logArchGrpID = 1 --defaultSPId 
			WHERE dataArchGrpID = @analyticsSPId
			
			SELECT	@errorCode = @@ERROR
			IF		@errorCode != 0
			BEGIN
					SET @errorString = 'Failed to update SP from Analytics policy to CV_DEFAULT table App_Application'
					BREAK
			END
			
			DECLARE @tempResDelChk TABLE(amErrorCode INT, policyType INT, hasEZBackupSet INT,jobIdList  VARCHAR(max), criticalJobIdList  VARCHAR(max), reserveXML XML);
			
			INSERT INTO @tempResDelChk
			EXEC ArchCanDeletePolicyOrCopy @analyticsSPId,0
			
			DECLARE @consistencyChkErr INT = 0;
			
			SELECT	@errorCode = @@ERROR
			IF		@errorCode <> 0
			BEGIN
					SET @errorString = 'Failed to Execute SP ArchCanDeletePolicyOrCopy to check if we can delete the SP'
					BREAK
			END
			
			SET @consistencyChkErr = ISNULL((SELECT TOP 1 amErrorCode FROM @tempResDelChk WHERE amErrorCode <> 0),0)
			
			IF @consistencyChkErr <> 0 
			BEGIN
					SET @errorCode = @consistencyChkErr;
					SET @errorString = 'Unable to delete the SP due to consistency check done in ArchCanDeletePolicyOrCopy with error' + @errorCode;
					BREAK
			END
			
			IF EXISTS(SELECT TOP 1 1 FROM @tempResDelChk WHERE jobIdList <> '')
			BEGIN
					SET @errorCode = 26; --E_ARCH_JOBS_ARE_RUNNING_FOR_SP	26
					SET @errorString = 'Unable to delete the SP due to running active jobs';
					BREAK
			END
			
			DECLARE @tempDelChk TABLE(dbErrorCode INT, amErrorCode INT, errorString VARCHAR(1024), numJobDataStats INT, numMagVols INT, numNonMagMedia INT, tmPolicyCount INT);
			
			--INSERT INTO @tempDelChk
			EXEC archGroupCopyDelete @analyticsSPId, 0;
			
			SELECT	@errorCode = @@ERROR
			IF		@errorCode <> 0
			BEGIN
					SET @errorString = 'Failed to Execute SP archGroupCopyDelete to delete the Analytics Policy SP'
					BREAK
			END
			FETCH NEXT FROM cur INTO @analyticsSPId
		END	
		CLOSE cur    
		DEALLOCATE cur
			
	CX_ERROR_EXIT:
		IF (@errorCode <> 0) OR EXISTS (SELECT * FROM @tempDelChk WHERE amErrorCode > 0)
		BEGIN
			ROLLBACK TRANSACTION
			PRINT @errorString
			SELECT @errorCode
		END
		ELSE
		BEGIN
			COMMIT TRANSACTION
			PRINT @errorString
			SELECT @errorCode
		END
END
RETURN	
GO
