SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON

DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

BEGIN TRY

IF OBJECT_ID('HistoryDB..SimXMLRequestHistory') IS NOT NULL
BEGIN
	DELETE SimXMLRequest
	OUTPUT DELETED.id, DELETED.clientId, DELETED.OpTimeUTC, DELETED.xmlBlob
	INTO [HistoryDB]..SimXMLRequestHistory (id, clientId, OpTimeUTC, xmlBlob)
	WHERE clientId  != 0
END
ELSE
	PRINT 'HistoryDB..SimXMLRequestHistory table is not accessible.'

END TRY
BEGIN CATCH
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH

IF @errorCode <> 0
BEGIN
    PRINT 'ERROR: [' + @errorString +']. Rolling back Transaction'
END
SET  NOCOUNT OFF