SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON

DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'
DECLARE @propType INT = 3624
DECLARE @current DATETIME = GetUTCDate()

BEGIN TRANSACTION
BEGIN TRY

--Delete History for clients which are not present in APP_Client
DELETE PH
FROM PatchInstallHistory PH LEFT JOIN APP_Client AC ON PH.ClientId = AC.id
WHERE AC.id IS NULL

--Get all Release Update Times for all clients
IF object_id('tempdb.dbo.#ReleaseTime') IS NOT NULL DROP TABLE #ReleaseTime
CREATE TABLE #ReleaseTime ( t_client INT, t_release FLOAT, t_installTime DATETIME, t_endTime DATETIME )

INSERT INTO #ReleaseTime (t_client, t_release, t_installTime)
SELECT DISTINCT componentNameId,
	   SUBSTRING(attrName, CHARINDEX(' ', attrName) + 1, CASE CHARINDEX( '.' ,attrName) WHEN 0 THEN LEN(attrName) ELSE 1 END) attrName,
	   DATEADD(S, CAST(attrVal AS INT), '1970-01-01') attrVal 
FROM APP_ClientProp  ACP JOIN PatchInstallHistory PIH
	ON ACP.componentNameId = ClientId
WHERE attrName like 'Release %'

UPDATE t1
SET t_endTime = ISNULL((SELECT MIN(t2.t_installTime) FROM #ReleaseTime t2 WHERE t1.t_client = t2.t_client and t1.t_release < t2.t_release), @current) 
FROM #ReleaseTime t1

--Populate all the SPs installed for each client with InstallTimes and release
IF object_id('tempdb.dbo.#SPToDelete') IS NOT NULL DROP TABLE #SPToDelete
CREATE TABLE #SPToDelete (t_id INT IDENTITY(1,1), client INT ,release INT, SPVer INT, SPMinor INT, installTime INT, bSave INT, bUninstalled INT)

INSERT INTO #SPToDelete
SELECT pih.ClientId, rt.t_release, pih.HighestSP, pih.spMinorVersion, dbo.GetUnixTime(MIN(pih.OpTime)), 0, 0
FROM patchInstallhistory pih JOIN #ReleaseTime rt 
	ON rt.t_client = pih.ClientId AND 
	pih.optime >= rt.t_installTime AND 
	pih.optime < rt.t_endtime
GROUP BY pih.ClientId, rt.t_release, pih.HighestSP, pih.spMinorVersion
ORDER BY pih.ClientId, rt.t_release, pih.HighestSP, pih.spMinorVersion 

--Update bSave flag for SPs which are to be saved
UPDATE #SPToDelete
SET bSave = t_id - (maxID - 2)
FROM (select clientID = client, maxID = MAX(t_id) from #SPToDelete group by client) T
WHERE clientID = client and t_id > maxID - 2

--
UPDATE #SPToDelete
SET bUninstalled = 1, bSave = 0
WHERE client not in (select clientID from simInstalledPackages)

--delete clients which don't have new SP to update
DELETE D
FROM #SPToDelete D
	JOIN (SELECT componentId FROM APP_ComponentProp WHERE propertyTypeId = @propType) T1 ON D.client = T1.componentId
	LEFT JOIN (SELECT A.componentId FROM APP_ComponentProp A JOIN #SPToDelete T ON A.componentId = T.client and A.propertyTypeId = @propType and T.bSave = 0) T2 ON D.client = T2.componentId
WHERE bUninstalled = 0 AND T2.componentId IS NULL

--Populate the SPs for each client to be saved in the PatchInstallHistory Table
--Get Install History Information from APP_ComponentProp which is already pruned to merge with new pruned data
;WITH InstallHistoryXml AS (
	SELECT componentId, CAST(stringVal AS XML) AS historyXml
	FROM  APP_ComponentProp
	WHERE propertyTypeId = @propType AND componentId IN (SELECT client FROM #SPToDelete where bSave = 0)
)
INSERT INTO #SPToDelete
SELECT	componentId,
		InstallHistory.C.value('../@Release', 'int'),
		InstallHistory.C.value('@sp', 'int'),
		InstallHistory.C.value('@spMinor','int'),
		InstallHistory.C.value('@installTime', 'INT'), 0, 0
FROM InstallHistoryXml AS results
CROSS APPLY results.historyXml.nodes('/PatchInstallHistory/SPVer') AS InstallHistory(C)

--Create XML and Insert/Update APP_ComponentProp table with corresponding client id
MERGE app_componentProp ACP
USING (SELECT spd.client,
		(SELECT spd1.release AS 'PatchInstallHistory/@Release',
			(SELECT dbo.GetUnixTime(rt.t_installTime) 
				FROM #ReleaseTime rt 
				WHERE rt.t_release = release AND rt.t_client = spd.client
			) AS 'PatchInstallHistory/@Time',
			(SELECT SPVer AS 'SPVer/@sp',
					SPMinor AS 'SPVer/@spMinor',
					MIN(installTime) AS 'SPVer/@installTime' 
				FROM #SPToDelete 
				WHERE client = spd.client AND
					  release = spd1.release
				GROUP BY SPVer, SPMinor
				ORDER BY SPVer, SPMinor
				FOR XML PATH(''), TYPE  
			) AS 'PatchInstallHistory' 
			FROM #SPToDelete spd1
			WHERE	spd1.client = spd.client
			GROUP BY spd1.release
			FOR XML PATH('')
		) AS historyXML
	FROM #SPToDelete spd
	GROUP BY spd.client
) IH
ON componentId = IH.client AND ACP.propertyTypeId = @propType
WHEN MATCHED THEN 
	UPDATE SET ACP.stringVal = IH.historyXML
WHEN NOT MATCHED THEN 
	INSERT (componentType, componentId, propertyTypeId, dataType, longVal,longlongVal, stringVal, created, modified)
	VALUES (3, IH.client, @propType, 1, 0, 0, IH.historyXML, dbo.GetUnixTime(getUTCDate()), 0);

--Delete records of Uninstalled clients
DELETE PatchInstallHistory
WHERE ClientId IN (select client from #SPToDelete where bUninstalled > 0)

--Delete rows from PatchInstallHistory keeping only the latest 2 SPs information for each client
DELETE PatchInstallHistory
FROM (select client, instTime=dbo.GetDateTime(installTime) from #SPToDelete where bSave = 1) T
WHERE ClientId = T.client AND optime < T.instTime

IF object_id('tempdb.dbo.#SPToDelete') IS NOT NULL DROP TABLE #SPToDelete
IF object_id('tempdb.dbo.#ReleaseTime') IS NOT NULL DROP TABLE #ReleaseTime

COMMIT TRANSACTION
SET  NOCOUNT OFF

END TRY
BEGIN CATCH
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH

IF @errorCode <> 0
BEGIN
	PRINT 'ERROR: [' + @errorString +']. Rolling back Transaction'
    ROLLBACK TRAN
END