--Deleting rows for Licence criterias from NTSelCriteria
SET  NOCOUNT ON

-- NT_LICENSE_EXPIRY and NT_LICENSE_CONSUMED were moved from Commcell Configuration alerts to License alert type. So removing criteria association for non license alert types alert.

DELETE from NTSelCriteriaParams WHERE selCriteriaid in 
(
	select NTSelCriteria.id from NTSelCriteria 
	inner join NTNotificationRule on NTSelCriteria.ruleId = NTNotificationRule.id
	WHERE availCriteriaid in (58,60)  
	and NTNotificationRule.alertTypeId<>60
)

DELETE from NTSelCriteria WHERE Id in 
(
	select NTSelCriteria.id from NTSelCriteria 
	inner join NTNotificationRule on NTSelCriteria.ruleId = NTNotificationRule.id
	WHERE availCriteriaid in (58,60)  
	and NTNotificationRule.alertTypeId<>60
)

DELETE from NTSelCriteriaParams WHERE selCriteriaid in (select id from NTSelCriteria WHERE availCriteriaid in (15,66/*NT_CLIENT_CERTIFICATE_EXPIRY*/)  )
DELETE from NTSelCriteria WHERE availCriteriaid in (15,66/*NT_CLIENT_CERTIFICATE_EXPIRY*/)   

delete from NTMessageTokensForAlert
where availCriteriaId in 
(
	select Id from NTAVailCriteria
	where criteriaId = 15
)

delete from NTAvailCriteriaSeverity
where availCriteriaId in 
(
    select Id from NTAVailCriteria
    where criteriaId = 15
)

delete from NTAVailCriteria
where criteriaId = 15
 
 -- If there exists any permanent alert (No backup for last 3 days and Restore job failed), 
-- then we will remove the permanent flag
Update NTNotificationRule
set status = status - 256
where (status & 256)>0

Update NTNotificationRule 
set status = 2,revision=0
where (status & 32)>0 -- Remove all SRM advisory alerts

-- Code to disable application management alerts on CS SP upgrade is moved to NTAlertType.script. since that script is always run anyways. 

declare @eventTable table
(
    eventId int,
    suppObjType nvarchar(max),
    suppObjId nvarchar(max)    -- No need to convert it to longlong_t here    
)

Insert into @eventTable
select eventId,IsNull(value,''),''
from NTDparams with (nolock)
where type=26   --enumSuppObjType
    
Update EventsTbl
set suppObjId = IsNull(NTDparams.value,'')
from @eventTable EventsTbl
inner join NTDparams with (nolock)
on NTDparams.eventId = EventsTbl.eventId
where NTDparams.type=27 --enumSuppObjId

Update NTDetectedAlerts
set entityId=suppObjType+'|'+suppObjId
from @eventTable EventsTable
where NTDetectedAlerts.eventId = EventsTable.eventId
and (NTDetectedAlerts.entityId is null or len(NTDetectedAlerts.entityId)=0)


update Criteria SET availCriteriaid = 54 --$$(NT_JOB_STARTED)
from NTSelCriteria Criteria
inner join NTnotificationRule Alert on Criteria.ruleId = Alert.id
where Alert.alertTypeId = 20 /*$$(NT_ALERTTYPE_CLIENT_DIST)*/ and Criteria.availCriteriaid = 7 /*$$(NT_INITIATED)*/


delete from NTAvailCriteriaSeverity
where availCriteriaId in 
(
    select Id from NTAVailCriteria
    where criteriaId = 7 /*$$(NT_INITIATED)*/ AND alertTypeId = 20 /*$$(NT_ALERTTYPE_CLIENT_DIST)*/
)

delete from NTAVailCriteria
where criteriaId = 7 /*$$(NT_INITIATED)*/ AND alertTypeId = 20 /*$$(NT_ALERTTYPE_CLIENT_DIST)*/

SET  NOCOUNT OFF




