SET NOCOUNT ON
GO

SET QUOTED_IDENTIFIER ON
GO

DECLARE @tempTbl TABLE (
	subclientId INT,
	newVal	NVARCHAR(10)
)

DECLARE @tempTbl1 TABLE (
	subclientId INT,
	newVal	NVARCHAR(10)
)

DECLARE @nowTime INTEGER = dbo.GetUnixTime(GETUTCDATE())

BEGIN TRANSACTION

	--Collect all subclients, whose client has SRM enabled at iDA level
	INSERT INTO @tempTbl
	SELECT 
		app.id,'513'
	FROM 
		APP_Application AS app,
		APP_IDAProp AS idaprop,
		APP_IDAName AS idaname
	WHERE app.appTypeId = 13 
		AND app.clientId = idaname.clientId
		AND app.appTypeId = idaname.appTypeId
		AND idaprop.componentNameId = idaname.id
		AND idaprop.attrName = 'SRM Data Collection Enabled'
		AND idaprop.attrVal = '1'
		AND idaprop.modified = 0

	--Age the old property
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId IN (SELECT subclientId FROM @tempTbl) 
		AND attrName = 'SRM Data Collection Options' 
		AND modified = 0
	
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END

	--Insert the new property
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT subclientId, 'SRM Data Collection Options', 10, newVal, @nowTime, 0
	FROM @tempTbl
	
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END

	--Collect rest of subclients which do not have SRM enabled at iDA level
	--for integrated NAS clients
	INSERT INTO @tempTbl1
	SELECT 
		app.id,'0'
	FROM APP_Application AS app
	WHERE app.appTypeId = 13 AND app.id NOT IN 
	(SELECT subclientId FROM @tempTbl)


	--Age the old property
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId in (SELECT subclientId FROM @tempTbl1) 
		AND attrName = 'SRM Data Collection Options' 
		AND modified = 0
	
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END

	--Insert the new property
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT subclientId, 'SRM Data Collection Options', 10, newVal, @nowTime, 0
	FROM @tempTbl1
			
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END
			
	--STANDALONE SRM NAS AGENTS
	--Cleanup temp table and insert entries for standalone SRM NAS
	DELETE @tempTbl

	-- Reset Analytics flag for Standalone SRM NAS Agent
	--#define SC_SRM_DC_OPT_FILEANALYTICS     0x0010

	INSERT INTO @tempTbl
	SELECT scprop.componentNameId,CAST(CAST(scprop.attrVal AS INT) & 0xFFEF AS NVARCHAR(10))
	FROM
		APP_Application AS app,
		APP_SubClientProp AS scprop
	WHERE 
		scprop.attrName =  'SRM Data Collection Options'
		AND app.id = scprop.componentNameId
		AND app.appTypeId = 603
		AND scprop.modified = 0
		
	--Age the old property
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE componentNameId in (SELECT subclientId FROM @tempTbl) 
		AND attrName = 'SRM Data Collection Options' 
		AND modified = 0
	
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		RETURN
	END

	--Insert the new property
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT subclientId, 'SRM Data Collection Options', 10, newVal, @nowTime, 0
	FROM @tempTbl
			
	IF @@ERROR = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
	END
	

RETURN
GO

