
IF EXISTS(select * from sys.objects where OBJECT_ID=OBJECT_ID(N'PatchinfoAfterAdd') AND type = (N'TR'))
	DROP TRIGGER PatchinfoAfterAdd

UPDATE PatchSPVersion SET TransactionID = 0 WHERE TransactionID IS NULL
UPDATE PatchSPVersion SET RevisionId = 0 WHERE RevisionId IS NULL	
	
INSERT INTO PatchSPVersion (Release, ReleaseStr, Build, BuildIdString, DVDName, SPName, SPMajor, SPMinor, TransactionID, RevisionID, FriendlyName, Timestamp, bIsDVDPresent, bShowInGUI, nCacheFlags, nLTSFlag, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT DISTINCT ac.releaseId, sagr.release + CASE WHEN CHARINDEX('.', sagr.release)>0 THEN '.0' ELSE '.0.0' END, sagr.buildNum, 'BUILD' + CONVERT(varchar(4), sagr.buildnum), '', 'SP' + dbo.GetServicePackStr(sip.HighestSP, sip.SpMinorVersion), sip.HighestSP, sip.SpMinorVersion, 0, 0, '', 0, 0, 0, 0, 0, 0, 0
FROM simInstalledPackages sip
JOIN APP_Client ac WITH (NOLOCK) on sip.ClientId = ac.id
JOIN simAllGalaxyRel sagr WITH (NOLOCK) on ac.ReleaseId = sagr.id
WHERE sip.SPVersionID IS NULL AND NOT EXISTS
	(SELECT * FROM PatchSPVersion 
	 WHERE Release = ac.releaseId AND
		Build = sagr.buildNum AND
		SPMajor = sip.HighestSP AND 
		SPMinor = sip.SpMinorVersion
	)

INSERT INTO PatchSPVersion (Release, ReleaseStr, Build, BuildIdString, DVDName, SPName, SPMajor, SPMinor, TransactionID, RevisionID, FriendlyName, Timestamp, bIsDVDPresent, bShowInGUI, nCacheFlags, nLTSFlag, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT DISTINCT ac.releaseId, sagr.release + CASE WHEN CHARINDEX('.', sagr.release)>0 THEN '.0' ELSE '.0.0' END, sagr.buildNum, 'BUILD' + CONVERT(varchar(4), sagr.buildnum), '', 'SP' + pmc.HighestSP, gspn.major, gspn.minor, 0, 0, '', 0, 0, 0, 0, 0, 0, 0
FROM PatchMultiCache pmc
JOIN APP_Client ac WITH (NOLOCK) on pmc.ClientId = ac.id
JOIN simAllGalaxyRel sagr WITH (NOLOCK) on ac.ReleaseId = sagr.id
CROSS APPLY dbo.GetServicePackNumbers(pmc.HighestSP) AS gspn
WHERE pmc.SPVersionID IS NULL AND NOT EXISTS
	(SELECT * FROM PatchSPVersion 
	 WHERE Release = ac.releaseId AND
		Build = sagr.buildNum AND
		SPMajor = gspn.major AND 
		SPMinor = gspn.minor 
	)

UPDATE PatchMultiCache 
SET SPVersionId = spver.id
FROM PatchMultiCache pmc
JOIN PatchSPVersion spver ON pmc.ReleaseId = spver.Release
JOIN simAllGalaxyRel sagr WITH (NOLOCK) ON spver.Release = sagr.id
CROSS APPLY dbo.GetServicePackNumbers(pmc.HighestSP) AS gspn
WHERE pmc.SPVersionID IS NULL AND
	spver.Build = sagr.buildNum AND
	spver.SPMajor = gspn.major AND 
	spver.SPMinor = gspn.minor	
		
UPDATE simInstalledPackages 
SET SPVersionId = spver.id
FROM simInstalledPackages sip
JOIN APP_Client ac ON sip.clientId = ac.id
JOIN simAllGalaxyRel sagr WITH (NOLOCK) ON ac.releaseId = sagr.id
JOIN PatchSPVersion spver ON ac.releaseId = spver.Release
WHERE sip.SPVersionID IS NULL AND
	spver.Build = sagr.buildNum AND
	spver.SPMajor = sip.HighestSP AND 
	spver.SPMinor = sip.SpMinorVersion
	
