-- Release license for VSA Proxy/physical nodes
DECLARE @VsaAppType 	INT = 106
DECLARE @licToConsume	INT = 143
DECLARE @errCode 		INT = 0
DECLARE @errString 		VARCHAR(2048) = ''
DECLARE @PermLicConsumed INT = 0
DECLARE @EvalLicConsumed INT = 0
DECLARE @currentTime 	BIGINT = 0
SET @currentTime 		= dbo.GetUnixTime(GETUTCDATE())

BEGIN TRANSACTION
BEGIN TRY

DECLARE @ClientsList TABLE(t_cid int, t_lictype INT, t_opType VARCHAR(32), t_eval INT )

INSERT INTO @ClientsList
SELECT distinct Cid, LicType, OpType, Eval
FROM LicUsage WITH (NOLOCK) WHERE LicType = @licToConsume 

DELETE @ClientsList FROM 
APP_Application app WITH (NOLOCK)
JOIN app_instanceprop Iprop WITH (NOLOCK) ON app.instance = Iprop.componentNameId AND Iprop.attrName = 'Virtual Server Instance Type' AND LEN(Iprop.attrVal) > 0 AND Iprop.modified = 0
WHERE t_cid = clientId AND appTypeId = @VsaAppType

SELECT @PermLicConsumed = COUNT(distinct t_cid) FROM @ClientsList 
WHERE t_eval = 0 AND t_opType = 'Install' 

SELECT @EvalLicConsumed = COUNT(distinct t_cid) FROM @ClientsList 
WHERE t_eval = 1 AND t_opType = 'Install' 

--Remove the license from licusage
DELETE LicUsage FROM @ClientsList WHERE CId = t_cid AND LicType = t_lictype

IF(@PermLicConsumed + @EvalLicConsumed > 0)
BEGIN
	DECLARE @aalPermIsEval  INT = 0
	DECLARE @aalPermExpiryDate INT = 0
	DECLARE @aalIsEval  	INT = 1
	DECLARE @aalExpiryDate  INT = 0
	DECLARE @LicPermTotal   INT = 0
	DECLARE @LicPermUsed   	INT = 0
	DECLARE @LicEvalTotal   INT = 0
	DECLARE @LicEvalUsed   	INT = 0
	DECLARE @CommcellID     INT = 2
	DECLARE @perm_fld		VARCHAR(2048) = ''
	DECLARE @eval_fld		VARCHAR(2048) = ''
	DECLARE @licEncField    VARCHAR(2048)=''

	SELECT @perm_fld=RTRIM(perm_fld1), @eval_fld=RTRIM(eval_fld1) FROM LicAAL WITH (NOLOCK) WHERE commcellId = @CommcellID AND simLicAppTypeId = @licToConsume
	IF @PermLicConsumed > 0 AND @perm_fld <> ''
	BEGIN
		EXEC dbo.xp_getAALInfo2 @perm_fld, @LicPermTotal OUTPUT, @LicPermUsed OUTPUT, @aalPermIsEval OUTPUT, @aalPermExpiryDate OUTPUT
		IF @LicPermUsed > 0
		BEGIN
			SET @LicPermUsed = @LicPermUsed - @PermLicConsumed
			IF @LicPermUsed < 0
				SET @LicPermUsed = 0

			EXEC dbo.xp_buildAALFld @licToConsume, @LicPermTotal, @LicPermUsed, @aalPermExpiryDate, @aalPermIsEval, @licEncField OUTPUT
			IF @@error <> 0
			BEGIN
				SET @errCode = 1
				SET @errString = 'Failed To Build license field For License: ' + CAST(@licToConsume AS VARCHAR(64))
				GOTO EXIT_ERROR
			END
			IF (@licEncField <> '')
				UPDATE LicAAL SET perm_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
			ELSE
			BEGIN
				SET @errCode = 1
				SET @errString = 'licEncField is empty for License ' + CAST(@licToConsume AS VARCHAR(64))
				GOTO EXIT_ERROR
			END
		END
	END
	
	IF @EvalLicConsumed > 0 AND @eval_fld <> ''
	BEGIN
		EXEC dbo.xp_getAALInfo2 @eval_fld, @LicEvalTotal OUTPUT, @LicEvalUsed OUTPUT, @aalIsEval OUTPUT, @aalExpiryDate OUTPUT
		IF @LicEvalUsed > 0
		BEGIN
			SET @LicEvalUsed = @LicEvalUsed - @EvalLicConsumed
			IF @LicEvalUsed < 0
				SET @LicEvalUsed = 0
			
			EXEC dbo.xp_buildAALFld @licToConsume, @LicEvalTotal, @LicEvalUsed, @aalExpiryDate, @aalIsEval, @licEncField OUTPUT
			IF @@error <> 0
			BEGIN
				SET @errCode = 1
				SET @errString = 'Failed To Build Eval license field For License: ' + CAST(@licToConsume AS VARCHAR(64))
				GOTO EXIT_ERROR
			END
			IF (@licEncField <> '')
				UPDATE LicAAL SET eval_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
			ELSE
			BEGIN
				SET @errCode = 1
				SET @errString = 'licEncField is empty for eval License ' + CAST(@licToConsume AS VARCHAR(64))
				GOTO EXIT_ERROR
			END
		END
	END
END	

END TRY
BEGIN CATCH
	SELECT @errString = 'Release license For VSA Clients Failed  ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
	SET @errCode = 1
END CATCH

EXIT_ERROR:
		
IF @errCode = 1
BEGIN
	ROLLBACK TRANSACTION
	PRINT @errString
	RAISERROR(@errString, 16,1)
END
ELSE
	COMMIT TRANSACTION