SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
 
IF OBJECT_ID(N'Lic_PeakUsage', N'U') IS NOT NULL AND OBJECT_ID(N'HistoryDB.dbo.Lic_PeakUsage', N'U') IS NOT NULL
BEGIN 
	IF NOT EXISTS (SELECT TOP 1 1 FROM Lic_PeakUsage  WITH (NOLOCK)) AND EXISTS (SELECT TOP 1 1 FROM HistoryDB.dbo.Lic_PeakUsage  WITH (NOLOCK))
	BEGIN
		DECLARE @monthstart datetime = ''
		DECLARE @peakType int = 0
		DECLARE GETDATA CURSOR FOR SELECT DISTINCT MonthStart, PeakType FROM HistoryDB.dbo.Lic_PeakUsage WITH (NOLOCK)
		OPEN GETDATA
		FETCH NEXT FROM GETDATA INTO @monthstart,@peakType

		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO Lic_PeakUsage (MonthStart, CreationDate,UsageType,PeakType,ClientId,ClientName,SubclientId,SubclientName,AppTypeId,LicType,BackupSetId,BackupSetName,InstanceId,InstanceName,SPId,SPName,JobId,AppSizeMB,CapacityFlag, VMFlag, ObjectName, ObjectId,Organization, OrgGUID,PlanName,BasePlanName)
			SELECT * FROM HistoryDB.dbo.Lic_PeakUsage WITH (NOLOCK)
			WHERE MonthStart = @monthstart AND PeakType = @peakType
		FETCH NEXT FROM GETDATA INTO @monthstart,@peakType
		END
		CLOSE GETDATA
		DEALLOCATE GETDATA
	END
END




