
-- This is script to create SQL job for License Usage Collection
DECLARE @user_name NVARCHAR(128) = SUSER_NAME()
DECLARE @hasaccess INT = 0
DECLARE @sysadmin INT = 0

SELECT @hasaccess = hasaccess, @sysadmin = sysadmin 
	FROM sys.syslogins WHERE loginname = @user_name

IF @hasaccess = 0 OR @sysadmin = 0 
	RETURN

BEGIN TRANSACTION

DECLARE @ReturnCode INT = 0
DECLARE @oldJobId binary(16)

SELECT @oldJobId= job_id  FROM msdb.dbo.sysjobs WHERE (name = N'Execute LSR Master')

IF (@oldJobId IS NOT NULL)
BEGIN
    EXEC  @ReturnCode = msdb.dbo.sp_update_job @oldJobId,@enabled = 0;
	IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
		GOTO QuitWithRollback
	ELSE 
		GOTO QuitWithCommmit
END


/****** Object:  JobCategory [[License Usage Collection Utilities]]    Script Date: 11/2/2018 11:42:00 AM ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'License Usage Collection Utilities' AND category_class=1)
BEGIN
	EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'License Usage Collection Utilities'
	IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
		GOTO QuitWithRollback
END

DECLARE @jobId BINARY(16)
DECLARE @schedule_uid UNIQUEIDENTIFIER
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Execute LSR Master', 
		@enabled=0, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Created for Execute License Summary Master SP.', 		
		@category_name=N'License Usage Collection Utilities', 
		@owner_login_name= @user_name, 
		@job_id = @jobId OUTPUT

IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
	GOTO QuitWithRollback

/****** Object:  Step [LicMasterSPExec]    Script Date: 11/2/2018 11:42:00 AM ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Execute SP LicCalcUsageMaster', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'EXEC LicCalcUsageMaster', 
		@database_name=N'Commserv', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
	GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1

IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
	GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Execute SP LicCalcUsageMaster Schedule', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=1, 
		@freq_subday_interval=0, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=NULL, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959, 
		@schedule_uid= @schedule_uid OUTPUT

IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
	GOTO QuitWithRollback

EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'

IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
	GOTO QuitWithRollback
QuitWithCommmit:
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) 
		ROLLBACK TRANSACTION
EndSave:

GO