-- Consume license for Exchange DAG, Oracle RAC, MSSQLAG, Share Point pseudo clients 
DECLARE @ExDAGAppType 	INT = 53
DECLARE @OracleRacAppType INT = 80 -- windows
DECLARE @SharePointAppType INT = 78
DECLARE @MsSqlAG 		INT = 81
DECLARE @SapHanaAppType INT = 135
DECLARE @DB2AppType 	INT = 103 -- DB2 multinode pseudo client is only on unix
DECLARE @VsaAppType 	INT = 106
DECLARE @DistributedAppsAppType INT = 64
DECLARE @apptypeTable TABLE (t_apptype INT, t_status INT, t_lic INT, t_attrName VARCHAR(256))
DECLARE @appClass1Lic	INT = 3
DECLARE @appClass3Lic	INT = 16
DECLARE @appClass2Lic	INT = 17
DECLARE @FSLic			INT = 1
DECLARE @vsaLic			INT = 143
DECLARE @licToConsume	INT = 0
DECLARE @id 			INT = 0
DECLARE @EncFld         VARCHAR(MAX) = N''
DECLARE @rawData        varchar(max) = ''
DECLARE @STR_DASH       varchar(10) =':-'
DECLARE @errCode 		INT = 0
DECLARE @errString 		VARCHAR(2048) = ''

DECLARE @prevReleaseID INT = 0

select @prevReleaseID = CAST(attrVal as INT) from APP_ClientProp WITH (NOLOCK) where componentNameID = 2 AND attrName = 'Previous Release'
IF @prevReleaseID = 0
	select top 1 @prevReleaseID = id from simAllGalaxyRel order by id desc
IF @prevReleaseID < 16 OR (@prevReleaseID = 16 AND (select TOP 1 HighestSP from PatchInstallHistory where ClientId = 2 order by id desc) < 7)
BEGIN

INSERT INTO @apptypeTable
VALUES(@ExDAGAppType,0x200000,@appClass1Lic,''),
(@OracleRacAppType, 0x0040,0,''),
(@MsSqlAG, 0x20000000,@appClass1Lic,''),
(@SapHanaAppType, 0x2000000,@appClass3Lic,''),
(@DB2AppType, 0x0200,@appClass2Lic,''),
(@SharePointAppType, 0,@appClass1Lic,'SharePoint Farm Client'),
(@VsaAppType, 0,@vsaLic,'Vs Member Servers'),
(@DistributedAppsAppType, 0,@FSLic,'Distributed iDA Client')
--CV_STATUS_ORACLE_RAC = 0x0040 CV_STATUS_DAG = 0x200000 CV_STATUS_MSSQLAG = 0x20000000

BEGIN TRANSACTION
BEGIN TRY

DECLARE @PseudoClientsList TABLE(t_cid int, t_name VARCHAR(512), t_rel int, t_simosId int, t_apptype int, t_lictype INT )
INSERT INTO @PseudoClientsList
SELECT distinct AC.id, AC.name, AC.releaseId, AC.simOperatingSystemId, t_apptype, t_lic
FROM @apptypeTable, APP_Client AC WITH (NOLOCK) INNER JOIN
APP_IDAName IDN WITH (NOLOCK) ON IDN.clientId = AC.id AND IDN.status&(2+4) = 0
WHERE (AC.status&t_status > 0) 

--SharePoint, Distributed Apps
INSERT INTO @PseudoClientsList
SELECT distinct AC.id, AC.name, AC.releaseId, AC.simOperatingSystemId, t_apptype, t_lic
FROM @apptypeTable, APP_ClientProp AP WITH (NOLOCK) INNER JOIN
APP_Client AC WITH (NOLOCK) ON AP.componentNameId = AC.id INNER JOIN
APP_IDAName IDN WITH (NOLOCK) ON IDN.clientId = AC.id AND IDN.status&(2+4) = 0
WHERE AP.attrName = t_attrName AND AP.attrval = '1' AND AP.modified = 0 AND LEN(AP.attrName) > 0 

--VSA
INSERT INTO @PseudoClientsList
SELECT distinct AC.id, AC.name, AC.releaseId, AC.simOperatingSystemId, t_apptype, t_lic
FROM @apptypeTable, APP_INSTANCEPROP INS WITH (NOLOCK) INNER JOIN
APP_Application APP WITH (NOLOCK) ON INS.componentNameId = APP.instance INNER JOIN
APP_Client AC WITH (NOLOCK) on APP.clientId = AC.id INNER JOIN
APP_IDAName IDN WITH (NOLOCK) on IDN.clientId = AC.id AND IDN.status&(2+4) = 0
WHERE INS.attrName = t_attrName AND INS.modified = 0 AND LEN(INS.attrName) > 0 

-- delete the clients where license is already consumed
DELETE @PseudoClientsList FROM LicUsage WHERE t_cid = cid AND AppType = t_apptype

DECLARE @physicalClient TABLE(t_pseudoCid INT, t_physicalCid INT, t_simosId INT)
INSERT INTO @physicalClient
SELECT tmp.t_cid, rac.clientId, AC.simOperatingSystemId 
FROM @PseudoClientsList tmp JOIN APP_Application app WITH (NOLOCK) ON tmp.t_cid = app.clientId AND tmp.t_apptype = @OracleRacAppType
JOIN APP_OracleRacInstance rac WITH (NOLOCK) ON rac.instaceId = app.instance
JOIN APP_Client AC WITH (NOLOCK) ON AC.id = rac.clientId

UPDATE T SET t_lictype = @appClass1Lic FROM @PseudoClientsList T JOIN @physicalClient tmp ON t_pseudoCid = t_cid
JOIN simOperatingSystem OS WITH(NOLOCK) ON tmp.t_simosId = id  AND Type = 'Windows'
WHERE t_apptype = @OracleRacAppType

UPDATE @PseudoClientsList SET t_lictype = @appClass2Lic WHERE t_lictype = 0

DECLARE LicenseCursor CURSOR LOCAL FORWARD_ONLY FOR   		 
SELECT DISTINCT t_lictype FROM @PseudoClientsList GROUP BY t_lictype

OPEN LicenseCursor 
FETCH FROM LicenseCursor INTO @licToConsume
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @aalPermIsEval  INT=0
	DECLARE @aalPermExpiryDate    INT=0
	DECLARE @aalIsEval  	INT = 1
	DECLARE @aalExpiryDate  INT = 0
	DECLARE @LicPermTotal   INT = 0
	DECLARE @LicPermUsed   	INT = 0
	DECLARE @LicEvalTotal   INT = 0
	DECLARE @LicEvalUsed   	INT = 0
	DECLARE @CommcellID     INT = 2
	DECLARE @opType			VARCHAR(2048) = 'Install'
	DECLARE @perm_fld		VARCHAR(2048) = ''
	DECLARE @eval_fld		VARCHAR(2048) = ''
	DECLARe @clientName		VARCHAR(512) = ''
	DECLARE @beval			INT = 0
	DECLARE @tokenUsed		INT = 0
	DECLARE @releaseId		INT = 0
	DECLARE @apptype		INT = 0
	DECLARE @installFlag	INT = 0
	DECLARE @simOSID		INT = 0
	DECLARE @buildStr		VARCHAR(512) = ''
	DECLARE @currentTime    DATETIME = GETUTCDATE()
	DECLARE @expiryDateUTC	DATETIME = GETUTCDATE() + 60
	DECLARe @expiryDate		DATETIME = 0
	DECLARE @licEncField    VARCHAR(2048)=''
	DECLARE @totalLicCount INT = (SELECT COUNT(*) FROM @PseudoClientsList WHERE t_lictype = @licToConsume)
	DECLARE @consumePermLic INT = 0

	SELECT @perm_fld=RTRIM(perm_fld1), @eval_fld=RTRIM(eval_fld1) FROM LicAAL WITH (NOLOCK) WHERE commcellId = @CommcellID AND simLicAppTypeId = @licToConsume
	IF @perm_fld <> ''
	BEGIN
		EXEC dbo.xp_getAALInfo2 @perm_fld, @LicPermTotal OUTPUT, @LicPermUsed OUTPUT, @aalPermIsEval OUTPUT, @aalPermExpiryDate OUTPUT
		DECLARE @FreePerm INT = @LicPermTotal - @LicPermUsed
		IF (@totalLicCount < @FreePerm OR @LicPermTotal < 0)
		BEGIN
			SET @consumePermLic = @totalLicCount
			SET @LicPermUsed = @LicPermUsed + @totalLicCount
			SET @totalLicCount = 0
		END
		ELSE
		BEGIN
			SET @consumePermLic = @FreePerm
			SET @LicPermUsed = @LicPermTotal
			SET @totalLicCount = @totalLicCount - @FreePerm
		END
		EXEC dbo.xp_buildAALFld @licToConsume, @LicPermTotal, @LicPermUsed, @aalPermExpiryDate, @aalPermIsEval, @licEncField OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Failed To Build license field For License: ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF (@licEncField <> '')
			UPDATE LicAAL SET perm_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
		ELSE
		BEGIN
			SET @errCode = 1
			SET @errString = 'licEncField is empty for License ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
	END
	
	IF @totalLicCount > 0
	BEGIN
		IF @eval_fld <> ''
		BEGIN
			EXEC dbo.xp_getAALInfo2 @eval_fld, @LicEvalTotal OUTPUT, @LicEvalUsed OUTPUT, @aalIsEval OUTPUT, @aalExpiryDate OUTPUT
		END
		DECLARE @FreeEval INT = @LicEvalTotal - @LicEvalUsed
		SET @LicEvalUsed = @LicEvalUsed + @totalLicCount
		IF @LicEvalTotal = 0
			SET @LicEvalTotal = @totalLicCount
		ELSE IF (@FreeEval < @totalLicCount AND  @LicEvalTotal > 0)
			SET @LicEvalTotal = @LicEvalTotal + @totalLicCount - @FreeEval
		
		IF(@aalExpiryDate < dbo.GetUnixTime(@expiryDateUTC))
			SET @aalExpiryDate = dbo.GetUnixTime(@expiryDateUTC)
		ELSE
			SET @expiryDateUTC = dbo.GetDateTime(@aalExpiryDate)
		EXEC dbo.xp_buildAALFld @licToConsume, @LicEvalTotal, @LicEvalUsed, @aalExpiryDate, @aalIsEval, @licEncField OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Failed To Build Eval license field For License: ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF (@licEncField <> '')
		BEGIN
			IF @eval_fld <> '' OR @perm_fld <> ''
				UPDATE LicAAL SET eval_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
			ELSE
				INSERT INTO LicAal
				VALUES(@licToConsume,@licEncField,'',@CommcellID)
		END
		ELSE
		BEGIN
			SET @errCode = 1
			SET @errString = 'licEncField is empty for eval License ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
	END

	DECLARE PseudoClientCursor CURSOR LOCAL FORWARD_ONLY FOR   		 
	SELECT t_cid, t_name, t_rel, t_simosId, t_apptype FROM @PseudoClientsList WHERE t_lictype = @licToConsume

	OPEN PseudoClientCursor 
	FETCH FROM PseudoClientCursor INTO @id, @clientName, @releaseId, @simOSID, @apptype
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @beval = 0
		SET @expiryDate = 0
		SET @EncFld	= N''
		SET @rawData = ''
			
		IF (@consumePermLic > 0)
		BEGIN
			SET @consumePermLic = @consumePermLic - 1
			SET @expiryDate = dbo.GetDateTime(@aalPermExpiryDate)
		END	
		ELSE
		BEGIN
			SET @beval = 1
			SET @expiryDate = @expiryDateUTC
		END

		SELECT @buildStr= CASE WHEN @releaseId = 16 THEN '0(BUILD80)'
			WHEN @releaseId = 15 THEN '0(BUILD116)'
			WHEN @releaseId = 14 THEN '0(BUILD84)'
			ELSE '0(BUILD80)'
		END
		SELECT @rawData = @clientName  + @STR_DASH + 
				CAST(@id AS VARCHAR(64)) + @STR_DASH + 
				CAST(@licToConsume AS VARCHAR(64)) + @STR_DASH + 
				CAST(@apptype AS VARCHAR(64)) + @STR_DASH + 
				@opType  + @STR_DASH + 
				CAST(dbo.GetUnixTime(@currentTime) AS VARCHAR(64)) + @STR_DASH +
				CAST(@tokenUsed AS VARCHAR(64)) + @STR_DASH +
				CAST(@beval AS VARCHAR(64)) + @STR_DASH +
				CAST(dbo.GetUnixTime(@expiryDate) AS VARCHAR(64)) + @STR_DASH +
				CAST(@releaseId AS VARCHAR(64)) + @STR_DASH + 
				CAST(@simOSID AS VARCHAR(64)) + @STR_DASH + 
				@buildStr + @STR_DASH + 
				CAST(@installFlag AS VARCHAR(64))  

			EXEC pswEncryptionManaged @rawData, @EncFld OUTPUT
			IF (@EncFld IS NULL or LEN(@EncFld) = 0)
			BEGIN   
				SET @errCode = 1
				SET @errString  ='Failure in updating license record For id: ' + CAST(@id   AS varchar(64) )
				GOTO  EXIT_ERROR
			END

		IF NOT EXISTS(SELECT id FROM LicUsage WHERE CId = @id AND LicType = @licToConsume AND AppType = @apptype)
			INSERT INTO LicUsage (Name,CId,LicType,AppType,OpType,OpTimeUTC,TokensUsed,Eval,ExpiryDateUTC,ReleaseId,EncryptedField,SimOSID,Build,InstallFlag,UserID,UsedCapacity)
			VALUES (@clientName,@id,@licToConsume,@apptype,@opType,@currentTime,@tokenUsed,@beval,@expiryDate,@releaseId,@EncFld,@simOSID,@buildStr,@installFlag,0,0) 
		
		FETCH FROM PseudoClientCursor INTO @id, @clientName, @releaseId, @simOSID, @apptype
	END
	IF ( CURSOR_STATUS('global', 'PseudoClientCursor') >= 0  /* cursor is open */
    OR CURSOR_STATUS('local', 'PseudoClientCursor') >= 0 )
		CLOSE PseudoClientCursor
	IF ( CURSOR_STATUS('global','PseudoClientCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','PseudoClientCursor') = -1 )
		DEALLOCATE PseudoClientCursor
	
	FETCH FROM LicenseCursor INTO @licToConsume
END

END TRY
BEGIN CATCH
	SELECT @errString = 'Consuming license For Pseudo Clients Failed  ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
	SET @errCode = 1
END CATCH

EXIT_ERROR:
IF ( CURSOR_STATUS('global', 'PseudoClientCursor') >= 0  /* cursor is open */
    OR CURSOR_STATUS('local', 'PseudoClientCursor') >= 0 )
    CLOSE PseudoClientCursor
IF ( CURSOR_STATUS('global','PseudoClientCursor') = -1  /* cursor is closed */
    OR CURSOR_STATUS('local','PseudoClientCursor') = -1 )
    DEALLOCATE PseudoClientCursor
IF ( CURSOR_STATUS('global', 'LicenseCursor') >= 0  /* cursor is open */
    OR CURSOR_STATUS('local', 'LicenseCursor') >= 0 )
    CLOSE LicenseCursor
IF ( CURSOR_STATUS('global','LicenseCursor') = -1  /* cursor is closed */
    OR CURSOR_STATUS('local','LicenseCursor') = -1 )
    DEALLOCATE LicenseCursor	
		
IF @errCode = 1
BEGIN
	ROLLBACK TRANSACTION
	PRINT @errString
	RAISERROR(@errString, 16,1)
END
ELSE
	COMMIT TRANSACTION
END	