--Consume AppClass1 License for SharePoint
DECLARE @oldSharePtAppType INT = 0
DECLARE @newSharePtAppType INT = 0
DECLARE @ExpbFolderAppType INT = 0
DECLARE @id 			INT = 0
DECLARE @EncFld         VARCHAR(MAX) = N''
DECLARE @rawData        varchar(max) = ''
DECLARE @STR_DASH       varchar(10) =':-'
DECLARE @errCode 		INT = 0
DECLARE @errString 		VARCHAR(2048) = ''

SET @ExpbFolderAppType = (SELECT type FROM APP_iDAType WHERE name = 'Exchange Public Folder')
SET @oldSharePtAppType = (SELECT type FROM APP_iDAType WHERE name = 'SharePoint Server Database')
SET @newSharePtAppType = (SELECT type FROM APP_iDAType WHERE name = 'SharePoint Server')

BEGIN TRANSACTION
BEGIN TRY
DECLARE SharePointCursor CURSOR LOCAL FORWARD_ONLY FOR   		 
SELECT Id FROM LicUsage WHERE AppType = @oldSharePtAppType

OPEN SharePointCursor 
FETCH FROM SharePointCursor INTO @id

WHILE @@FETCH_STATUS = 0
BEGIN
	SET @rawData = (
        SELECT  name  + @STR_DASH + 
                CAST(cid AS VARCHAR(64)) + @STR_DASH + 
                CAST(LicType AS VARCHAR(64)) + @STR_DASH + 
                CAST(@newSharePtAppType AS VARCHAR(64)) + @STR_DASH + 
                LTRIM(RTRIM(OpType))  + @STR_DASH + 
                CAST(dbo.GetUnixTime(OpTimeUTC) AS VARCHAR(64)) + @STR_DASH +
                CAST(TokensUsed AS VARCHAR(64)) + @STR_DASH +
                CAST(Eval AS VARCHAR(64)) + @STR_DASH +
                CAST(dbo.GetUnixTime(ExpiryDateUTC) AS VARCHAR(64)) + @STR_DASH +
                CAST(ReleaseId AS VARCHAR(64)) + @STR_DASH + 
                CAST(SimOSID AS VARCHAR(64)) + @STR_DASH + 
                Build + @STR_DASH + 
                CAST(InstallFlag AS VARCHAR(64))  
        FROM licusage WITH (NOLOCK) WHERE id = @id)

        EXEC pswEncryptionManaged @rawData, @EncFld OUTPUT
        IF (@EncFld IS NULL or LEN(@EncFld) = 0)
            BEGIN   
                SET @errCode = 1
                SET @errString  ='Failure in updating license record for Sharepoint id ' + CAST(@id   AS varchar(64) )
                GOTO  EXIT_ERROR
            END
        ELSE
        BEGIN
           UPDATE LicUsage
           SET EncryptedField = @EncFld, AppType = @newSharePtAppType
           WHERE id = @id
        END
	FETCH FROM SharePointCursor INTO @id
END

IF NOT EXISTS(SELECT id FROM LicUsage WHERE AppType = @ExpbFolderAppType) AND EXISTS (select id from APP_iDAName where appTypeId = @ExpbFolderAppType)
BEGIN
--Consume AppClass1 license for Exchange Public Folder
	SET @id = 0
	DECLARE @licAvailable	INT = 0
	DECLARE @aalPermIsEval  INT=0
	DECLARE @aalPermEvalDays    INT=0
	DECLARE @aalIsEval  	INT=0
	DECLARE @aalEvalDays    INT=0
	DECLARE @LicPermTotal   INT = 0
	DECLARE @LicPermUsed   	INT = 0
	DECLARE @LicOrigPermUsed INT = 0
	DECLARE @LicEvalTotal   INT = 0
	DECLARE @LicEvalUsed   	INT = 0
	DECLARE @LicOldEvalUsed INT = 0
	DECLARE @CommcellID     INT = 2
	DECLARE @licToConsume	INT = 3
	DECLARE @opType			VARCHAR(2048) = 'Install'
	DECLARE @perm_fld		VARCHAR(2048) = ''
	DECLARE @eval_fld		VARCHAR(2048) = ''
	DECLARe @clientName		VARCHAR(512) = ''
	DECLARE @beval			INT = 0
	DECLARE @tokenUsed		INT = 0
	DECLARE @releaseId		INT = 16
	DECLARE @installFlag	INT = 0
	DECLARE @simOSID		INT = 210
	DECLARE @buildStr		VARCHAR(512) = '0(BUILD80)'
	DECLARE @currentTime    DATETIME = GETUTCDATE()
	DECLARE @expiryDateUTC	DATETIME = GETUTCDATE() + 60
	DECLARe @expiryDate		DATETIME = 0
	DECLARE @licEncField    VARCHAR(2048)=''

	SELECT @perm_fld=RTRIM(perm_fld1), @eval_fld=RTRIM(eval_fld1) FROM LicAAL WHERE commcellId = @CommcellID AND simLicAppTypeId = @licToConsume
	IF @perm_fld <> ''
	BEGIN
		EXEC dbo.xp_getAALInfo2 @perm_fld, @LicPermTotal OUTPUT, @LicPermUsed OUTPUT, @aalPermIsEval OUTPUT, @aalPermEvalDays OUTPUT
	END
	IF @eval_fld <> ''
	BEGIN
		EXEC dbo.xp_getAALInfo2 @eval_fld, @LicEvalTotal OUTPUT, @LicEvalUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
	END

	SET @LicOrigPermUsed = @LicPermUsed
	SET @LicOldEvalUsed = @LicEvalUsed

	DECLARE ExPbFolderCursor CURSOR LOCAL FORWARD_ONLY FOR   		 
	SELECT distinct clientId, name FROM APP_IDAName A INNER JOIN APP_Client B on A.clientId = B.id
	 WHERE appTypeId = @ExpbFolderAppType AND A.status&(2+4) = 0

	OPEN ExPbFolderCursor 
	FETCH FROM ExPbFolderCursor INTO @id, @clientName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @beval = 0
		SET @EncFld	= N''
		SET @rawData = ''
		IF (@LicPermTotal > 0 AND @LicPermUsed < @LicPermTotal) OR (@LicPermTotal < 0)
		BEGIN
			SET @LicPermUsed = @LicPermUsed+1
			SET @expiryDate = dbo.GetDateTime(@aalPermEvalDays)
		END	
		ELSE
		BEGIN
			SET @LicEvalUsed = @LicEvalUsed+1
			SET @beval = 1
			SET @expiryDate = @expiryDateUTC
		END
		SELECT @releaseId = releaseId FROM app_client WHERE id = @id
		SELECT @buildStr= CASE WHEN @releaseId = 16 THEN '0(BUILD80)'
			WHEN @releaseId = 15 THEN '0(BUILD116)'
			WHEN @releaseId = 14 THEN '0(BUILD84)'
			WHEN @releaseId = 13 THEN '0(Build68)'
			WHEN @releaseId = 12 THEN '0(Build76)'
			ELSE '0(BUILD80)'
		END
		SELECT @rawData = @clientName  + @STR_DASH + 
				CAST(@id AS VARCHAR(64)) + @STR_DASH + 
				CAST(@licToConsume AS VARCHAR(64)) + @STR_DASH + 
				CAST(@ExpbFolderAppType AS VARCHAR(64)) + @STR_DASH + 
				@opType  + @STR_DASH + 
				CAST(dbo.GetUnixTime(@currentTime) AS VARCHAR(64)) + @STR_DASH +
				CAST(@tokenUsed AS VARCHAR(64)) + @STR_DASH +
				CAST(@beval AS VARCHAR(64)) + @STR_DASH +
				CAST(dbo.GetUnixTime(@expiryDate) AS VARCHAR(64)) + @STR_DASH +
				CAST(@releaseId AS VARCHAR(64)) + @STR_DASH + 
				CAST(@simOSID AS VARCHAR(64)) + @STR_DASH + 
				@buildStr + @STR_DASH + 
				CAST(@installFlag AS VARCHAR(64))  

			EXEC pswEncryptionManaged @rawData, @EncFld OUTPUT
			IF (@EncFld IS NULL or LEN(@EncFld) = 0)
			BEGIN   
				SET @errCode = 1
				SET @errString  ='Failure in updating license record For Ex PF id' + CAST(@id   AS varchar(64) )
				GOTO  EXIT_ERROR
			END

		INSERT INTO LicUsage (Name,CId,LicType,AppType,OpType,OpTimeUTC,TokensUsed,Eval,ExpiryDateUTC,ReleaseId,EncryptedField,SimOSID,Build,InstallFlag,UserID,UsedCapacity)
		VALUES (@clientName,@id,@licToConsume,@ExpbFolderAppType,@opType,@currentTime,@tokenUsed,@beval,@expiryDate,@releaseId,@EncFld,@simOSID,@buildStr,@installFlag,0,0) 
		FETCH FROM ExPbFolderCursor INTO @id, @clientName
	END

	IF (@LicPermTotal <> 0 AND @LicPermUsed <> @LicOrigPermUsed)
	BEGIN
		EXEC dbo.xp_buildAALFld @licToConsume, @LicPermTotal, @LicPermUsed, @aalPermEvalDays, @aalPermIsEval, @licEncField OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Failed To Build license type For Ex PF: ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF (@licEncField <> '')
			UPDATE LicAAL SET perm_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
	END

	IF (@LicEvalUsed <> @LicOldEvalUsed)
	BEGIN
		IF @LicEvalTotal = 0 OR (@LicEvalTotal < @LicEvalUsed AND  @LicEvalTotal > 0)
		BEGIN
			SET @LicEvalTotal = @LicEvalUsed
			SET @aalEvalDays = dbo.GetUnixTime(@expiryDateUTC)
			SET @aalIsEval = 1
		END
		EXEC dbo.xp_buildAALFld @licToConsume, @LicEvalTotal, @LicEvalUsed, @aalEvalDays, @aalIsEval, @licEncField OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Failed To Build Eval license type For Ex PF: ' + CAST(@licToConsume AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF (@licEncField <> '')
		BEGIN
			IF @eval_fld <> '' OR @perm_fld <> ''
				UPDATE LicAAL SET eval_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licToConsume AND commcellId = @CommcellID
			ELSE
				INSERT INTO LicAal
				VALUES(@licToConsume,@licEncField,'',@CommcellID)
		END
	END
END

END TRY
BEGIN CATCH
	SELECT @errString = 'Conversion of sharepoint/Exchange PF apptype Failed  ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
	SET @errCode = 1
END CATCH

EXIT_ERROR:
IF ( CURSOR_STATUS('global', 'SharePointCursor') >= 0  /* cursor is open */
    OR CURSOR_STATUS('local', 'SharePointCursor') >= 0 )
    CLOSE SharePointCursor
IF ( CURSOR_STATUS('global','SharePointCursor') = -1  /* cursor is closed */
    OR CURSOR_STATUS('local','SharePointCursor') = -1 )
    DEALLOCATE SharePointCursor
IF ( CURSOR_STATUS('global', 'ExPbFolderCursor') >= 0  /* cursor is open */
    OR CURSOR_STATUS('local', 'ExPbFolderCursor') >= 0 )
    CLOSE ExPbFolderCursor
IF ( CURSOR_STATUS('global','ExPbFolderCursor') = -1  /* cursor is closed */
    OR CURSOR_STATUS('local','ExPbFolderCursor') = -1 )
    DEALLOCATE ExPbFolderCursor
		
IF @errCode = 1
BEGIN
	ROLLBACK TRANSACTION
	PRINT @errString
	RAISERROR(@errString, 16,1)
END
ELSE
	COMMIT TRANSACTION