DECLARE @licType 		INT = 0
DECLARE @licCoreEvalFld VARCHAR(2048) = ''
DECLARE @aalIsEval  	INT=0
DECLARE @aalEvalDays    INT=0
DECLARE @LicTotal   	INT = 0
declare @LicUsed   	 	INT = 0
DECLARE @CommcellID     INT = 2
DECLARE @errCode 		INT = 0
DECLARE @errString 		VARCHAR(2048) = ''
DECLARE @licUpdateTime  INT = dbo.GetUNIXTime(GETUTCDATE())

BEGIN TRY
DECLARE LicAALCursor CURSOR LOCAL FORWARD_ONLY FOR   		 
SELECT simLicAppTypeId ,RTRIM(eval_fld1) FROM LicAAL WHERE commcellId = @CommcellID AND eval_fld1 IS NOT NULL AND RTRIM(eval_fld1) <> ''

OPEN LicAALCursor 
FETCH FROM LicAALCursor INTO @licType, @licCoreEvalFld

WHILE @@FETCH_STATUS = 0
BEGIN
	SET @LicTotal = 0
	SET @LicUsed = 0
	SET @aalIsEval = 0
	SET @aalEvalDays = 0
	EXEC dbo.xp_getAALInfo2 @licCoreEvalFld, @LicTotal OUTPUT, @LicUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
	IF @@error <> 0
	BEGIN
		SET @errCode = 1
		SET @errString = 'Failed while decoding for license type: ' + CAST(@licType AS VARCHAR(64))
		GOTO EXIT_ERROR
	END
	IF @aalEvalDays > 0 AND @aalEvalDays < 2000
	BEGIN
		DECLARE @licEncField    VARCHAR(2048)=''
		SET @aalEvalDays = @licUpdateTime + (@aalEvalDays * 24 *60 * 60)
		EXEC dbo.xp_buildAALFld @licType, @licTotal, @LicUsed, @aalEvalDays, @aalIsEval, @licEncField OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'Failed To Build license type: ' + CAST(@licType AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF (@licEncField <> '')
			UPDATE LicAAL SET eval_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licType AND commcellId = @CommcellID
	END
	FETCH FROM LicAALCursor INTO @licType, @licCoreEvalFld
END

END TRY
BEGIN CATCH
	SELECT @errString = 'Conversion of Eval days to expiry Date Failed  ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
	SET @errCode = 1
END CATCH

EXIT_ERROR:
CLOSE LicAALCursor
DEALLOCATE LicAALCursor
		
IF @errCode = 1
BEGIN
	PRINT @errString
	RAISERROR(@errString, 16,1)
END