
DECLARE @LicCoreTotal   INT = 0
DECLARE @LicEntTotal    INT = 0
DECLARE @LicTotal 		INT = 0
DECLARE @LicUsedTotal 		INT = 0
declare @licCoreType    INT = 100001
declare @licEntType    INT = 100002
declare @LicCoreUsed    INT = 0
declare @LicEntUsed    INT = 0
DECLARE @CommcellID     INT = 2
DECLARE @licEncField    VARCHAR(2048)=''
DECLARE @licCorePermFld VARCHAR(2048)=''
DECLARE @licEntPermFld VARCHAR(2048)=''
DECLARE @aalIsEval  INT=0
DECLARE @aalEvalDays    INT=0
DECLARE @STR_DASH varchar(10) =':-'
DECLARE @i INT = 0
DECLARE @releaseID INT = 0
DECLARE @CLACoreIssuedName  VARCHAR(128) = ''
DECLARE @CLAEntIssuedName  VARCHAR(128) = ''
DECLARE @errCode INT = 0
DECLARE @errString VARCHAR(2048) = ''
DECLARE @CLAIssuedData  VARCHAR(128)
DECLARE @licEntAttrVal varchar(5000) =''
DECLARE @ExpTimeEnt    INT = 0

SELECT TOP 1 @releaseID = id FROM simAllGalaxyRel ORDER BY id DESC

BEGIN TRY
WHILE @i < 2
BEGIN
	-- Update LicAAL Record
	SET @CLACoreIssuedName = CAST(@licCoreType AS VARCHAR(64)) + ' issued'
	SET @licCorePermFld = ''
	SET @LicCoreTotal = 0
	SET @LicCoreUsed = 0
	SELECT @licCorePermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @licCoreType AND commcellId = @CommcellID
	IF (@licCorePermFld <> '')
	BEGIN
		EXEC dbo.xp_getAALInfo2 @licCorePermFld, @LicCoreTotal OUTPUT, @LicCoreUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
		IF @@error <> 0
		BEGIN
			SET @errCode = 1
			SET @errString = 'xp_getAALInfo2 Failed while decoding for license type: ' + CAST(@licCoreType AS VARCHAR(64))
			GOTO EXIT_ERROR
		END
		IF @LicCoreTotal > 0
		BEGIN
			SET @LicEntTotal = 0
			SET @LicEntUsed = 0
			SET @aalIsEval = 0
			SET @aalEvalDays = 0
			SET @licEntType = @licCoreType + 1
			SET @LicTotal = @LicCoreTotal
			SET @LicUsedTotal = @LicCoreUsed
			SET @CLAEntIssuedName = CAST(@licEntType AS VARCHAR(64)) + ' issued'
			SET @licEntPermFld = ''
			SELECT @licEntPermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @licEntType AND commcellId = @CommcellID
			IF @licEntPermFld <> ''
			BEGIN
				EXEC dbo.xp_getAALInfo2 @licEntPermFld, @LicEntTotal OUTPUT, @LicEntUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
				IF @@error <> 0
				BEGIN
					SET @errCode = 1
					SET @errString = 'xp_getAALInfo2 Failed while decoding for license type: ' + CAST(@licEntType AS VARCHAR(64))
					GOTO EXIT_ERROR
				END
				IF @LicEntTotal >= 0 --Update only when quantity is not -1
				BEGIN
					SET @LicTotal = @LicTotal + @LicEntTotal
					SET @LicUsedTotal = @LicUsedTotal + @LicEntUsed
					SET @licEncField = ''
					EXEC dbo.xp_buildAALFld @licEntType, @licTotal, @LicUsedTotal, @aalEvalDays, @aalIsEval, @licEncField OUTPUT
					IF @@error <> 0
					BEGIN
						SET @errCode = 1
						SET @errString = 'xp_buildAALFld Failed for license type: ' + CAST(@licEntType AS VARCHAR(64))
						GOTO EXIT_ERROR
					END
					IF (@licEncField <> '')
						UPDATE LicAAL SET perm_fld1 = REPLACE(@licEncField, CHAR(0), '')  WHERE simLicAppTypeId = @licEntType AND commcellId = @CommcellID
					IF (@releaseID > 14) -- Update LicUsageBasedConfig Record for only release > 9.0
					BEGIN
						SET @licEntPermFld = ''
						SELECT @licEntPermFld = attrVal FROM LicUsageBasedConfig WHERE attrName = @CLAEntIssuedName
						IF (@licEntPermFld = '') -- If enterprise is not present
						BEGIN
							UPDATE LicUsageBasedConfig SET attrName = @CLAEntIssuedName WHERE attrName = @CLACoreIssuedName
						END
						ELSE
						BEGIN
							SET @licEntAttrVal = ''
							EXEC miscProc2 @licEntPermFld, @licEntAttrVal OUTPUT
							SET @ExpTimeEnt = 0
							SELECT @ExpTimeEnt = SUBSTRING(@licEntAttrVal,1,CHARINDEX(@STR_DASH,@licEntAttrVal)-1)
							SET @CLAIssuedData = CAST(@ExpTimeEnt AS VARCHAR(64)) + @STR_DASH + CAST(@LicTotal AS VARCHAR(64))
							SET @licEncField = ''
							EXEC pswEncryptionManaged @CLAIssuedData, @licEncField OUTPUT
							IF (@licEncField IS NULL or LEN(@licEncField) = 0)
							BEGIN
								SET @errCode = 1
								SET @errString = 'Failure in encrypting the licensing record ' + CAST(@CLAIssuedData AS varchar(64))
								GOTO EXIT_ERROR
							END
							UPDATE LicUsageBasedConfig SET attrVal = @licEncField WHERE attrName = @CLAEntIssuedName
						END
					END -- IF @releaseID > 14
				END
			END -- IF @licEntPermFld <> ''
			ELSE
			BEGIN
				DELETE FROM LicAAL WHERE simLicAppTypeId = @licEntType AND commcellId = @CommcellID
				SET @licEncField = ''
				EXEC dbo.xp_buildAALFld @licEntType, @licTotal, @LicUsedTotal, 0, 0, @licEncField OUTPUT
				IF @@error <> 0
				BEGIN
					SET @errCode = 1
					SET @errString = 'xp_buildAALFld Failed while inserting for license type: ' + CAST(@licEntType AS VARCHAR(64))
					GOTO EXIT_ERROR
				END
				INSERT INTO LicAAL
				VALUES(@licEntType,'',REPLACE(@licEncField, CHAR(0), ''),@CommcellID)
				
				IF (@releaseID > 14) -- Update LicUsageBasedConfig Record for only release > 9.0
				BEGIN
					DELETE FROM LicUsageBasedConfig WHERE attrName = @CLAEntIssuedName
					UPDATE LicUsageBasedConfig SET attrName = @CLAEntIssuedName WHERE attrName = @CLACoreIssuedName
				END
			END
		END -- IF @LicCoreTotal > 0
	END -- IF (@licCorePermFld <> '')
	DELETE FROM LicUsageBasedConfig WHERE attrName = @CLACoreIssuedName
	SET @i = @i + 1
	SET @licCoreType = 100003
END -- WHILE @i < 2
END TRY
BEGIN CATCH
	SELECT @errString = 'Conversion of Core to Enterprise Failed  ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+ ' ERROR_MESSAGE: '+ERROR_MESSAGE()
	SET @errCode = 1
END CATCH

EXIT_ERROR:
IF @errCode = 1
BEGIN
	PRINT @errString
	RAISERROR(@errString, 16,1)
END