if object_id('tempdb.dbo.#tmpLNIndexAF') is not null DROP TABLE #tmpLNIndexAF
CREATE TABLE #tmpLNIndexAF(
                                archFileId INTEGER,
                                commCellId INTEGER
                                )

--Get all index AF of Lotus Notes Agent where CVA_AF_DATA_LOG_INDEX_FLAG (4096) is not set
INSERT INTO #tmpLNIndexAF
SELECT DISTINCT AF.id, AF.commCellId
FROM archFile AF, App_Application APP WITH (NOLOCK)
WHERE AF.appId = APP.id
AND                       APP.appTypeId IN (59,77)
AND                       AF.fileType = 2
AND                       AF.flags & 4096 = 0

--Update index AFs with flag bit CVA_AF_DATA_LOG_INDEX_FLAG (4096)
UPDATE archFile
SET flags = flags | 4096
FROM archFile AF, #tmpLNIndexAF T
WHERE AF.id = T.archFileId
AND                       AF.commCellId = T.commCellId

