SET NOCOUNT ON
DECLARE @retVal INTEGER
SET     @retVal = 0

BEGIN transaction

IF object_id('tempdb.dbo.#tmpJobsTable1') is not NULL DROP TABLE #tmpJobsTable1
CREATE TABLE #tmpJobsTable1
(
bkpLevel int,
appid int,
jobid1 int,
cycle int,
sequence int
)

IF object_id('tempdb.dbo.#tmpJobsTable2') is not NULL DROP TABLE #tmpJobsTable2
CREATE TABLE #tmpJobsTable2 
(
bkpLevel int,
appid int,
jobid1 int,
cycle int,
sequence int
)


;WITH bkpjobs AS
( SELECT j.bkpLevel, j.appId, j.jobId, ROW_NUMBER() over ( PARTITION by appId order by jobId ) AS rownum, 1 AS seq
FROM JMBkpStats j
WHERE j.bkpLevel  IN (1,64,128) and j.appType IN (45, 57, 56, 58, 66, 73, 82, 83, 89, 90, 124, 131, 67, 68) AND j.commCellId = 2  AND j.status IN (1,3,14,16)  -- FULL 1, SYNTHETIC_FULL 64, SYNTHETIC_FULL_AND_INCR 128 
)
INSERT into #tmpJobsTable1
SELECT * FROM bkpjobs 

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE


-- UPDATE FULL/Synth FULL jobs cycle and seq number.
UPDATE JMBkpStats
SET fullCycleNum = T1.cycle, cyclesequence = T1.sequence
FROM #tmpJobsTable1 T1
WHERE jobid = T1.jobid1 AND commCellId = 2

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE



-- UPDATE Non full jobs cycle number.
UPDATE JMBkpStats
SET fullCycleNum = (SELECT ISNULL ((SELECT TOP 1 T1.cycle FROM #tmpJobsTable1 T1 WHERE T1.appid = JMBkpStats.appId AND T1.jobid1 < JMBkpStats.jobId  ORDER BY T1.jobId1 DESC), 1))
WHERE bkpLevel NOT IN (1,64,128) AND commCellId = 2 AND appId in (SELECT appId FROM #tmpJobsTable1) AND status IN (1,3,14,16)

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE


DROP TABLE #tmpJobsTable1

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE

;WITH bkpjobs1 AS
( SELECT j.bkpLevel, j.appId, j.jobId, 1 AS cycle, ROW_NUMBER() over ( PARTITION by  appId,fullCycleNum order by jobId ) AS rownum
FROM JMBkpStats j
WHERE j.appType IN (45, 57, 56, 58, 66, 73, 82, 83, 89, 90, 124, 131, 67, 68) and j.commCellId = 2 AND j.status IN (1,3,14,16)
)
INSERT into #tmpJobsTable2
SELECT *  FROM bkpjobs1

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE

-- UPDATE Non full jobs sequence number.
UPDATE JMBkpStats
SET cyclesequence = T2.sequence
FROM #tmpJobsTable2 T2
WHERE jobid = T2.jobid1 AND JMBkpStats.bkpLevel NOT IN (1,64,128) AND commCellId = 2

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE

DROP TABLE #tmpJobsTable2

SELECT @retVal = @@ERROR
IF @retVal <> 0 GOTO ALL_DONE

ALL_DONE:
	IF(@retVal = 0)
		COMMIT transaction
	ELSE
		BEGIN
			ROLLBACK transaction
			print 'ErrorCode: ' + CAST(@retVal as varchar)
		END
