----------CREATE INDEX SERVER POOL PSEUDO CLIENTS FOR EACH INDEX SERVER DURING UPGRADE ----------------
SET QUOTED_IDENTIFIER ON
DECLARE @analyticsServrPoolUpgrade INT = 0
DECLARE @analyticsServerPoolVersion varchar(36) = 'BE2C4E16-2A36-4D4C-8B69-194F316868974'
SELECT @analyticsServrPoolUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)
WHERE GS.SqlScriptGUID = @analyticsServerPoolVersion

IF (@analyticsServrPoolUpgrade = 0)            -- not done, do the db upgrade
BEGIN   	

	--DECLARATION
	DECLARE @curTime INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @IndexServerPoolClients TABLE (t_clientId INT PRIMARY KEY, t_clientName NVARCHAR(255), t_hostName NVARCHAR(255) ,t_poolClientId INT DEFAULT 0, 
										t_poolClientName NVARCHAR(255), t_zooKeeperCloudId INT DEFAULT 0,t_CloudId INT DEFAULT 0, t_poolCloudId INT DEFAULT 0, t_poolCloudName NVARCHAR(255))
	DECLARE @outIndexServerPoolClients TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_clientId INT, t_clientName NVARCHAR(255))		
	DECLARE @outInstance TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_instanceId INT)	
	DECLARE @outBackupSet TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_backupSetId INT)	
	DECLARE @outAppId TABLE (t_appId INT PRIMARY KEY)
	DECLARE @attributeTbl TABLE (t_attrName NVARCHAR(64), t_entityType int, t_value NVARCHAR(64), t_attrType INT)	
	IF object_id('tempdb.dbo.#clientTbl') IS NOT null DROP TABLE #clientTbl  CREATE TABLE #clientTbl(clientId INT PRIMARY KEY)

	--GET ALL CLIENTS WITH DISTRIBUTED IDA
	INSERT INTO #clientTbl (clientId)
	SELECT DISTINCT clientId FROM APP_Application (NOLOCK) WHERE appTypeId =64

	--PROPERTIES
	INSERT INTO @attributeTbl (t_attrName, t_entityType, t_value,  t_attrType)
	VALUES (N'Distributed iDA Client' , 1, N'1' , 2), ('Index Server Type', 1, N'14', 2), ('IndexingV2',1,N'1',2), ('SP Version Info', 1 ,N'11' ,1), ('Exclude from SLA', 1,N'1',2)
	
	--Embedded is no longer supported, set status =3
	UPDATE DM2Cloud
	SET status =3 
	FROM DM2Cloud DC (NOLOCK) 	
	WHERE DC.cloudType =4 AND status != 3 

	--GET ALL INDEX SERVER CLUSTER CLOUD
	INSERT INTO @IndexServerPoolClients (t_clientId, t_clientName, t_hostName, t_poolClientName, t_zooKeeperCloudId, t_CloudId, t_poolCloudName)
	SELECT DISTINCT C.id, C.name , C.net_hostname,  C.name + '_IndexStorePool', DC.zookeeperCloudId, DC.cloudId, dc.name
	FROM DM2Cloud DC (NOLOCK)	
	INNER JOIN DM2SearchServerCoreInfo S (NOLOCK)  ON DC.CloudId = S.CloudId 		
	INNER JOIN APP_Client C  (NOLOCK)  ON C.id = DC.pseudoClientId
	WHERE DC.pseudoclientid >0 AND DC.indexServerPoolClientId = 0 AND DC.CloudType =5
	
	IF NOT EXISTS ( SELECT 1 FROM @IndexServerPoolClients)
		GOTO PROC_EXIT
			
	--CLIENT
	INSERT INTO APP_Client (name, simOperatingSystemId, net_hostname, refTime, client_password, releaseId,origCCId,GUID,specialClientFlags,displayName, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, spaceCheckFlags)       
	OUTPUT INSERTED.id, inserted.name
	INTO @outIndexServerPoolClients
	SELECT  t_poolClientName,	0, t_poolClientName , @curTime,	'3cfe3eeb854e8aa64e0155bec019674d5',	16,	2	, NEWID() , 2, t_poolClientName, @curTime, 0, 0, N'', N'',  N'', 0, 0, 0, 0, 0
	FROM @IndexServerPoolClients
	WHERE t_poolClientName NOT IN (SELECT name FROM APP_Client (NOLOCK) WHERE (specialClientFlags & 0X2) >0 )

	--clientId to poolClientId association
	UPDATE @IndexServerPoolClients
	SET t_poolClientId = C.id
	FROM APP_Client C
	WHERE C.name = t_poolClientName

	--update indexServerPoolClientId into dm2cloud table
	--rename cloud name , display name
	UPDATE DM2Cloud
	SET indexServerPoolClientId = ISNULL(C.t_poolClientId,0),
		name = name + '_cluster',
		displayName = displayName + '_cluster',
		zookeeperCloudId = 0
	FROM DM2Cloud DC (NOLOCK) 
	JOIN @IndexServerPoolClients C ON C.t_clientId  = DC.pseudoClientId
	WHERE DC.cloudType = 5 AND indexServerPoolClientId = 0 
	
	--DM2CLOUD
	INSERT INTO DM2Cloud (commCellId, name, description, flags, createTime, CloudType, zookeeperCloudId, CloudProps, displayName, attribute, modifiedTime, status, pseudoClientId, indexServerPoolClientId)
	SELECT 2, C.t_poolCloudName, '', 1, @curTime, 9, t_zooKeeperCloudId,'',C.t_poolCloudName,0,0,1, P.t_clientId, 0
	FROM @outIndexServerPoolClients P
	JOIN @IndexServerPoolClients C ON P.t_clientId = C.t_poolClientId
	
	--cloudId to poolCloudId association
	UPDATE @IndexServerPoolClients
	SET t_poolCloudId = C.cloudId
	FROM DM2Cloud C
	WHERE C.name = t_poolCloudName

	--DM2SearchServerCoreInfo
	INSERT INTO DM2SearchServerCoreInfo (CoreName, CommCellId, CloudId, ClientId, CreateTime, SoftState, Enabled, Attributes,ServiceLink,CoreRoles,CollectionSize,FreeSpace,OccupiedSpace,Description,skippedItems, failedItems, numFiles, numEmails, status, CloudType, Portno, NodeProps, modifiedTime)
	SELECT 'Cloud_' + CAST(S.CloudId as varchar(10)) + '_Client_' + CAST(S.ClientId as varchar(10)) + '_Core',  2, C.t_poolCloudId, S.ClientId, GETUTCDATE(), S.SoftState, S.Enabled, S.Attributes, '', S.CoreRoles, S.CollectionSize,S.FreeSpace, S.OccupiedSpace,S.Description,S.skippedItems,S.failedItems,S.numFiles,S.numEmails,S.status, 9, S.Portno,S.NodeProps, 0
	FROM DM2SearchServerCoreInfo S 
	JOIN @IndexServerPoolClients C ON S.CloudId = C.t_CloudId
	WHERE C.t_poolCloudId > 0


	--CLIENTPROP
	INSERT INTO APP_ClientProp (componentNameId,attrName,attrType, attrVal,created, modified)
	SELECT t_poolClientId,	t_attrName,	t_attrType,	T.t_value ,	@curTime,0
	FROM @IndexServerPoolClients A
		CROSS JOIN @attributeTbl T
	WHERE T.t_entityType = 1 AND
	NOT EXISTS (SELECT 1 FROM APP_ClientProp (NOLOCK) WHERE componentNameId = A.t_poolClientId AND attrName = T.t_attrName)
	
	--INSTANCE
	INSERT INTO APP_InstanceName (name, status, origCCId,GUID, refTime, modified)
	OUTPUT inserted.id
	INTO @outInstance
	SELECT 'defaultInstanceName',	0,	2, NEWID(), @curTime, @curTime
	FROM @outIndexServerPoolClients A		
	WHERE A.t_clientId NOT IN (SELECT clientId FROM #clientTbl)

	--BACKUPSET
	INSERT INTO APP_BackupSetName (name, status, origCCId,GUID, refTime, modified)
	OUTPUT inserted.id
	INTO @outBackupSet
	SELECT 'defaultBackupSet',	0,	2, NEWID(), @curTime, @curTime
	FROM @outIndexServerPoolClients A
	WHERE A.t_clientId NOT IN (SELECT clientId FROM #clientTbl)
	
	--IDA	
	INSERT INTO APP_IDAName (clientId, appTypeId, status, refTime, modified)
	SELECT t_clientId,	64,	0, 0 , @curTime
	FROM @outIndexServerPoolClients C
	WHERE C.t_clientId NOT IN (SELECT clientId FROM APP_IDAName(NOLOCK)  WHERE appTypeId =64)

	--SUBCLIENT	
	INSERT INTO APP_Application (clientId,appTypeId,instance,backupSet,subclientName,subclientStatus,origCCId,GUID,appNumber, dataArchGrpID,logArchGrpID, refTime, modified)
	OUTPUT INSERTED.id
	INTO @outAppId
	SELECT  C.t_clientId, 64, I.t_instanceId,	B.t_backupsetId, 'default',	8	,2,	NEWID(), 0,1,1, @curTime,@curTime	
	FROM @outIndexServerPoolClients C 
	JOIN @outInstance I ON C.t_Id = I.t_Id
	JOIN @outBackupSet B ON C.t_Id =B.t_Id 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM #clientTbl)
				
	--PLATFORM
	INSERT INTO APP_Platform (clientId, platformType, install_dir, refTime)
	SELECT C.t_clientId,	4,	'N/A',	0
	FROM @outIndexServerPoolClients C 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM APP_Platform (NOLOCK) WHERE platformType =4 )
	
	--Disable backup activity for existing psuedo clients	
	UPDATE JMJobAction
	SET action = 1
	FROM @IndexServerPoolClients C 
	WHERE ClientId = C.t_poolClientId AND Optype = 4 AND apptype =0 AND action = 2

	DECLARE @drSubclientId INT = ISNULL((select TOP 1 id from APP_Application (NOLOCK) WHERE appTypeId = 1000),0)
	--JOB ACTIVITY
	INSERT INTO JMJobAction (clientId, mediaAgentId, appType, opType, action, appId, clientGroupId, enableTimeZone, enableTime, UNCenableTime,instanceID)
	SELECT C.t_clientId,	1,	0,	4,	1,	@drSubclientId,	0,	0,	0,	0,	1			
	FROM @outIndexServerPoolClients C 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 0 AND opType =4)
	UNION ALL
		SELECT C.t_clientId,	1,	0,	5,	2,	@drSubclientId,	0,	0,	0,	0,	1			
		FROM @outIndexServerPoolClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 0 AND opType =5)	
	UNION ALL
		SELECT C.t_clientId,	1,	64,	4,	2,	@drSubclientId,	0,	0,	0,	0,	1			
		FROM @outIndexServerPoolClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 64 AND opType =4)
	UNION ALL
		SELECT C.t_clientId,	1,	64,	5,	2,	@drSubclientId,	0,	0,	0,	0,	1
		FROM @outIndexServerPoolClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 64 AND opType =5)
		
	--USER - ROLES ASSOCIATION
	DECLARE @roleId INT = ISNULL((SELECT id FROM UMRoles (nolock) WHERE name = 'SystemCreatedRole_legacy_Analytics'),0)
	IF @roleId = 0
	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
		VALUES (2, 'SystemCreatedRole_legacy_Analytics', 'System created owner role for entity', 0,0,4,1, 1494445598, 0 , NEWID(), '' )
				
		SET @roleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'SystemCreatedRole_legacy_Analytics'),0)
		IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleid = @roleId)
			INSERT INTO UMRolesPermissions (roleid, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
			VALUES (@roleId,122,102,2,0,0), (@roleId,122,107,1,0,0)
	END			
	
	--AGENT MGMT PERMISSIONS FOR ADMIN USER ON PSEUDOCLIENT
	DECLARE @AnaylticsEngineAssociations TABLE (id INT IDENTITY, clientId	INT,userOrGroupId INT ,isUser INT ,permissionId INT ,roleId INT ,isCreator INT ,authorId INT )
	INSERT INTO @AnaylticsEngineAssociations
	SELECT DISTINCT t_poolClientId,userOrGroupId,isUser,permissionId,roleId,isCreator, 1
	from UMSecurityAssociations JOIN @IndexServerPoolClients ON (entityType1=3 OR entityType1 =11) and entityId1=t_clientId and entityType2=0
	UNION
	SELECT DISTINCT t_poolClientId,userOrGroupId,isUser,permissionId,roleId,isCreator, 1
	FROM UMSecurityAssociations JOIN APP_ClientGroupAssoc ON  entityType1=28 and entityId1=clientGroupId 
	JOIN @IndexServerPoolClients ON t_clientId=clientId

	DELETE from @AnaylticsEngineAssociations WHERE id IN (
		SELECT MIN(id) FROM  @AnaylticsEngineAssociations
		GROUP BY clientId	,userOrGroupId  ,isUser  ,permissionId  ,roleId  ,isCreator
		HAVING COUNT(*) > 1
	)

	MERGE UMSecurityAssociations AS UC
    USING(SELECT  clientId	,userOrGroupId  ,isUser  ,permissionId  ,roleId  ,isCreator  ,authorId FROM @AnaylticsEngineAssociations ) AS U (t_entityId1, t_userOrGroupId, t_isUser,t_permissionId,t_roleId,t_isCreator, t_authorId)
    ON (UC.permissionId = U.T_permissionId  AND U.t_roleId=UC.roleId and UC.userOrGroupId = U.t_userOrGroupId and UC.isUser = U.t_isUser AND UC.entityType1 = 3 AND UC.entityId1 = U.t_entityId1 AND UC.entityType2=0 AND UC.isCreator=U.t_isCreator )
    WHEN NOT MATCHED THEN
        INSERT (permissionId,roleId, userOrGroupId, isUser, entityType1, entityId1, isCreator,authorId)
        VALUES(t_permissionId,t_roleId, t_userOrGroupId, t_isUser, 3, t_entityId1,t_isCreator, t_authorId);				
	

PROC_EXIT:
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@analyticsServerPoolVersion, 'SCPIndexServerPoolUpgrade', 'Upgrade Index server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

DECLARE @analyticsPropertyUpdated varchar(36) = '1b9bdc36-11cd-40bf-bd1c-e62fc134cbbe'	 

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @analyticsPropertyUpdated)
BEGIN   

	-- Declare temp plan table
	DECLARE @planTbl TABLE (planId INT PRIMARY KEY, analyticsId INT, indexServerId INT DEFAULT 0) 

	-- Get all plan id which have been create without DC Policy as part of required entities 
	INSERT INTO @planTbl
	SELECT AP.id, CAST(APP2.attrVal AS INTEGER), 0 
		FROM App_Plan AP
			INNER JOIN App_PlanProp APP
				ON AP.id=APP.componentNameId AND APP.attrName='Defintion entities : required' AND APP.modified=0 AND APP.attrVal IS NOT NULL
			INNER JOIN App_PlanProp APP2
				ON AP.id=APP2.componentNameId AND APP2.attrName='Analytics Engine Cloud Id' AND APP2.modified=0 AND APP2.attrVal IS NOT NULL
		WHERE AP.subType=117506053 AND (65542 not in (SELECT _ID FROM dbo.SplitIDs(APP.attrVal)))

	UPDATE @planTbl
		SET indexServerId = (SELECT TOP 1 pseudoClientId FROM  DM2Cloud WHERE CloudId = analyticsId AND cloudType IN (1,5))
	WHERE analyticsId <> 0

	-- Update the index server for all relevant plan inplace of analytics engine
	UPDATE APP
			SET APP.attrVal=AP.indexServerId , APP.attrname='Analytics Index Server Id'
		FROM App_PlanProp APP
			INNER JOIN @planTbl AP
				ON AP.planId=APP.componentNameId AND APP.attrName='Analytics Engine Cloud Id' AND APP.modified=0 AND APP.attrVal IS NOT NULL

	-- update the list of required entites for this type of plan
	UPDATE APP
			SET APP.attrVal= '65540,65541,65542'
		FROM App_PlanProp APP
			INNER JOIN @planTbl AP
				ON AP.planId=APP.componentNameId AND APP.attrName='Defintion entities : required' AND APP.modified=0 AND APP.attrVal IS NOT NULL

	-- Mark flag as incomplete for this plan as there is no dc policy over here
	UPDATE APP
			SET APP.flag = APP.flag | 2
		FROM App_Plan APP
			INNER JOIN @planTbl AP
				ON AP.planId=APP.id
			
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@analyticsPropertyUpdated, 'APP_PlanProp Update', 'Update cloud Id with index server Id and mark plan as incompleted', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

