DECLARE @val NVARCHAR(MAX) = ''
SELECT @val = value FROM GXGlobalParam WITH (NOLOCK) WHERE name='IDX_RECON_SKIP_OLD_CYCLES' and modified=0
DECLARE @enablePruning VARCHAR(128) = 'Enable Index Pruning'
DECLARE @retCycle VARCHAR(128) = 'IndexPruning_DBRetentionCycle'
DECLARE @retDays VARCHAR(128) = 'IndexPruning_DBRetentionDays'
DECLARE @pruningType VARCHAR(128) = 'IndexPruning_Type'

-- enable pruning only if it is not enabled
IF LEN(@val) > 0
AND NOT EXISTS(SELECT value FROM GXGlobalParam WITH (NOLOCK) WHERE name = @enablePruning and modified=0)
BEGIN
	DECLARE @current_time BIGINT = (SELECT dbo.GetUnixTime(GETDATE()))
	--Step1: Enable the feature
	INSERT INTO GXGlobalParam(name,value,created,modified)
	VALUES
	(@enablePruning,1,@current_time,0),
	(@retCycle,-1,@current_time,0),
	(@retDays,-1,@current_time,0),
	(@pruningType,0,@current_time,0)
	
	--Step2: Set Pruning cycles
	IF @val = '*'
	BEGIN
		UPDATE GXGlobalParam SET value = 2 WHERE name = @retCycle
		UPDATE GXGlobalParam SET value = 0 WHERE name = @retDays
		UPDATE GXGlobalParam SET value = 1 WHERE name = @pruningType -- Defined in App.x enum IndexPruningType
	END
	ELSE
	BEGIN
		DECLARE @temp TABLE(t_Name NVARCHAR(128),t_val INT)
		INSERT INTO @temp
		VALUES
		(@enablePruning,1),
		(@retCycle,2),
		(@retDays,0),
		(@pruningType,1) -- Defined in App.x enum IndexPruningType

		INSERT INTO APP_BackupSetProp
		SELECT BS.id, t_Name, 7, t_val, @current_time, 0, 0 FROM APP_BackupSetName BS, @temp CROSS APPLY
		dbo.SplitIDString(@val) ID
		WHERE BS.GUID = ID._ID
	END
END
