--CREATE HAC CLUSTER CLIENT GROUP ONLY IF ATLEAST ONE HAC PACKAGE IS INSTALLED ON THE COMMCELL
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(1024) = N'Success'
DECLARE @unixTime INT = dbo.getUnixTime(GETDATE())

BEGIN TRY
	BEGIN TRAN
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE attrName = 'Client Group Unique Id' AND attrVal = 5 AND modified = 0 )
			AND NOT EXISTS (SELECT TOP 1 1 FROM app_clientgroup (NOLOCK) where name = 'HAC Cluster')
			AND EXISTS (SELECT TOP 1 1 FROM SimInstalledPackages (NOLOCK) WHERE simPackageId = 725)
		BEGIN	
			DECLARE @ownerId INT
			DECLARE @hacClusterGrpId INT
			SET @ownerId = ISNULL((SELECT TOP(1) id from UMUsers WITH (NOLOCK) where (flags & 64 = 64)), 1)
			DECLARE @EdgeClientsQuery nvarchar (max) 
			DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))

			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
			values('HAC Cluster', 'Select Clients which have HAC configured', 4096, 0, @ownerId, 0, '0', '', 2)		
			SET @hacClusterGrpId = SCOPE_IDENTITY()


			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@hacClusterGrpId, 'Client Group Unique Id', 7, 5, @unixTime, 0),
				(@hacClusterGrpId, 'System Created', 7, 0, @unixTime, 0)
				
			-- create smart client group for HAC Cluster
			--SCG_PKID_HAC_CLUSTER_CLIENT  = 57
			DECLARE @analyzerServerXML NVARCHAR(MAX) = '<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="85" propType="1" /> </rules> </rule></rules></scgRule>'
			DECLARE @scgExitCode INT = 0
			DECLARE @scgExitMsg VARCHAR(1024) = ''
        
			EXEC APPSCGV2GenerateQueryParams @analyzerServerXML, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @EdgeClientsQuery OUTPUT

			IF (@scgExitCode = 0)
			BEGIN
				insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
				values(@hacClusterGrpId, 
					@analyzerServerXML,
					@EdgeClientsQuery,
					1, 0, '0')

				
				
				--Set the creator with either Master role (that has all capabilities) or with System owner capabilities role (present against entityType(1) and entityID(2) in UMOwnerRoles table)
				DECLARE @edgeDriveCreatorRoleId INT
				DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
				SET @edgeDriveCreatorRoleId = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityID = 2),
														(SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)))
				EXEC sec_setCreatorForEntity @creatorUserId = 0, 
											@creatorRoleId = @edgeDriveCreatorRoleId, 
											@creatorPermissions = '', 
											@errorCode = @errorCode OUTPUT, 
											@errorString = @errorString OUTPUT, 
											@entityTYpe1 = 28,			/*CLIENT_GROUP_ENTITY*/
											@entityId1 = @hacClusterGrpId,
											@creatorUserGroupId = @masterUserGroupId,
											@loggedInUserID = @ownerId 

				DECLARE @createAsUserId INT 
				EXEC sec_getCreateAsUserId 28/*CLIENT_GROUP_ENTITY*/, 
										@hacClusterGrpId, 
										@createAsUserId OUTPUT
				UPDATE App_ClientGroup
				SET userId = @createAsUserId
				WHERE id = @hacClusterGrpId
				
			END
		END
END TRY
BEGIN CATCH
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH

IF @errorCode = 0
	COMMIT TRAN
ELSE 
	ROLLBACK TRAN			

SELECT @errorCode, @errorString
