BEGIN TRANSACTION DELETESRMDATA
SET NOCOUNT OFF
SET QUOTED_IDENTIFIER ON

DECLARE @maxRowsToPruneInBatch  INTEGER = 10000
IF object_id('tempdb.dbo.#appId') is not null DROP TABLE #appId
CREATE TABLE #appId(appId INT)

IF object_id('tempdb.dbo.#backupset') is not null DROP TABLE #backupset
CREATE TABLE #backupset(backupset INT)

IF object_id('tempdb.dbo.#instance') is not null DROP TABLE #instance
CREATE TABLE #instance(instance INT)

IF object_id('tempdb.dbo.#jobtoDelete') is not null DROP TABLE #jobtoDelete
CREATE TABLE #jobtoDelete(jobID INT, commcellId INT)

INSERT INTO #appId(appId)
SELECT ID FROM [APP_Application] where appTypeId BETWEEN 600 and 700 OR appTypeId IN (1080,1082)


INSERT INTO #backupset(backupset)
SELECT backupset FROM [APP_Application] where appTypeId BETWEEN 600 and 700 OR appTypeId IN (1080,1082)

INSERT INTO #instance(instance)
SELECT instance FROM [APP_Application] where  instance>1 and appTypeId BETWEEN 600 and 700 OR appTypeId IN (1080,1082)

DECLARE @clientPropInstalledNames TABLE (t_simPackageId int, t_attrName varchar(1024))

INSERT INTO @clientPropInstalledNames
VALUES
(401,  'SRM Services'),
(402,  'SRM Agent For Windows File Systems'),
(403,  'SRM Agent For Exchange'),
(404,  'PackageStateForId 404'),
(405,  'PackageStateForId 405'),
(406,  'PackageStateForId 406'),
(407,  'PackageStateForId 407'),
(408,  'PackageStateForId 408'),
(802,  'SRM Services DB'),
(1123, 'SRM Agent For UNIX File Systems')

IF EXISTS(SELECT * FROM #appId)
BEGIN
--SRM SUBCLIENT WILL NEVER BE HAVING VALUE IN THESE TABLE
--START
DELETE D FROM APP_RefCopyRefTime		D INNER JOIN  #appId A ON D.RefCopyAppId = A.appId
DELETE D FROM APP_ZIPWorkFlow			D INNER JOIN APP_ZIPWorkFlowName N ON  D.worklFlowId = N.id INNER JOIN #appId A ON N.ZIPVolUnit = A.appId
DELETE D FROM SchedAppZIPWorkFlow			D INNER JOIN APP_ZIPWorkFlowName N ON  D.workFlowId = N.id INNER JOIN #appId A ON N.ZIPVolUnit = A.appId
DELETE D FROM APP_ZIPWorkFlowName		D INNER JOIN  #appId A ON D.ZIPVolUnit = A.appId
DELETE D FROM QRFLRSnapPair				D INNER JOIN  #appId A ON D.PairId = A.appId
DELETE D FROM APP_ScReplicationPair		D INNER JOIN  #appId A ON D.PairId = A.appId
DELETE D FROM APP_SubClientTblsp		D INNER JOIN  #appId A ON D.componentNameId = A.appId
DELETE D FROM sqlFileSubClient			D INNER JOIN  #appId A ON D.applicationNumber = A.appId
--END
INSERT INTO #jobtoDelete(jobID,commcellId)
SELECT TOP(@maxRowsToPruneInBatch) D.jobId, D.commCellId FROM JMJobInfo			D INNER JOIN  JMBkpJobInfo B ON B.jobId = D.jobId AND B.commcellId = D.commCellId INNER JOIN  #appId A ON B.applicationId = A.appId
WHILE EXISTS(SELECT * FROM #jobtoDelete) 
BEGIN
	DELETE TOP(@maxRowsToPruneInBatch) D FROM JMJobInfo				D INNER JOIN  #jobtoDelete B ON B.jobId = D.jobId AND B.commcellId = D.commCellId
	DELETE FROM #jobtoDelete
	INSERT INTO #jobtoDelete(jobID,commcellId)
	SELECT TOP(@maxRowsToPruneInBatch) D.jobId, D.commCellId FROM JMJobInfo			D INNER JOIN  JMBkpJobInfo B ON B.jobId = D.jobId AND B.commcellId = D.commCellId INNER JOIN  #appId A ON B.applicationId = A.appId

END 

INSERT INTO #jobtoDelete(jobID,commcellId)
SELECT TOP(@maxRowsToPruneInBatch) D.jobId, D.commCellId FROM JMJobStats D INNER JOIN  JMBkpStats B ON B.jobId = D.jobId AND B.commcellId = D.commCellId  INNER JOIN  #appId A ON B.appId  = A.appId

WHILE EXISTS(SELECT * FROM #jobtoDelete) 
BEGIN
	DELETE TOP(@maxRowsToPruneInBatch) D FROM JMJobDataStats				D INNER JOIN  #jobtoDelete B ON B.jobId = D.jobId AND B.commcellId = D.commCellId
	DELETE TOP(@maxRowsToPruneInBatch) D FROM JMJobStats				D INNER JOIN  #jobtoDelete B ON B.jobId = D.jobId AND B.commcellId = D.commCellId
	DELETE FROM #jobtoDelete
	INSERT INTO #jobtoDelete(jobID,commcellId)
	SELECT TOP(@maxRowsToPruneInBatch) D.jobId, D.commCellId FROM JMJobStats D INNER JOIN  JMBkpStats B ON B.jobId = D.jobId AND B.commcellId = D.commCellId  INNER JOIN  #appId A ON B.appId  = A.appId

END 
DELETE D FROM QRApplicationDirs			D INNER JOIN  #appId A ON D.subclientId = A.appId
DELETE D FROM APP_SubClientProp			D INNER JOIN  #appId A ON D.componentNameId = A.appId
DELETE D FROM APP_ScFilterFile			D INNER JOIN  #appId A ON D.componentNameId = A.appId

--DELETE D FROM JMBkpStats				D INNER JOIN  #appId A ON D.appId  = A.appId
DELETE D FROM APP_Application			D INNER JOIN  #appId A ON D.ID = A.appId

END 

IF EXISTS(SELECT * FROM #backupset)
BEGIN

DELETE D FROM APP_BackupSetProp			D INNER JOIN  #backupset A ON D.componentNameId = A.backupset
DELETE D FROM APP_BackupSetFilterFile	D INNER JOIN  #backupset A ON D.componentNameId = A.backupset
DELETE D FROM APP_BackupSetName	D INNER JOIN  #backupset A ON D.id = A.backupset
END

IF EXISTS(SELECT * FROM #instance)
BEGIN

DELETE D FROM APP_InstanceProp			D INNER JOIN  #instance A ON D.componentNameId = A.instance
DELETE D FROM APP_InstFilterFile	D INNER JOIN  #instance A ON D.componentNameId = A.instance
DELETE D FROM APP_InstanceName	D INNER JOIN  #instance A ON D.id = A.instance
END

IF object_id('tempdb.dbo.#appTypeId') is not null DROP TABLE #appTypeId
CREATE TABLE #appTypeId(appTypeId INT)
INSERT INTO #appTypeId(appTypeId)
SELECT type FROM APP_IDAType where type BETWEEN 600 and 700 OR type IN (1080,1082)

IF EXISTS(SELECT * FROM #appTypeId)
BEGIN
-- IF object_id('tempdb.dbo.#clientId') is not null DROP TABLE #clientId
-- CREATE TABLE #clientId(clientId INT)
-- INSERT INTO #clientId(clientId)
-- select distinct clientId from APP_IdaName D INNER JOIN  #appTypeId A ON D.appTypeId  = A.appTypeId

-- DELETE FROM #clientId WHERE clientId IN ( select distinct clientId from APP_IdaName WHERE  appTypeId NOT BETWEEN 600 and 700)

DELETE D FROM APP_IDAProp				D  INNER JOIN APP_IdaName N ON  N.id= D.componentNameId INNER JOIN  #appTypeId A ON N.appTypeId  = A.appTypeId
DELETE D FROM APP_IdaName				D INNER JOIN  #appTypeId A ON D.appTypeId  = A.appTypeId
DELETE D FROM JMJobAction				D INNER JOIN  #appTypeId A ON D.appType  = A.appTypeId
DELETE D FROM APP_AppCompat				D INNER JOIN  #appTypeId A ON D.srcAppType  = A.appTypeId
DELETE D FROM UMSearchstring			D INNER JOIN  #appTypeId A ON D.appTypeId  = A.appTypeId
DELETE D FROM PatchInfo					D INNER JOIN  #appTypeId A ON D.appTypeId  = A.appTypeId
--need to confirm TM_StaticTaskValue
--DELETE D FROM TM_StaticTaskValue		D INNER JOIN  #appTypeId A ON D.appTypeId	 = A.appTypeId
--DELETE D FROM JMOpTable					D INNER JOIN  #appTypeId A ON D.appTypeType	 = A.appTypeId
DELETE D FROM SchedRestoreTask			D INNER JOIN  #appTypeId A ON D.appTypeId		 = A.appTypeId

-- IF EXISTS(SELECT * FROM #clientId)
-- BEGIN
-- DELETE D FROM patchInfo			D INNER JOIN  #clientId C ON D.clientId		 = C.clientId
-- DELETE D FROM simInstalledPackages			D INNER JOIN  #clientId C ON D.clientId		 = C.clientId
-- DELETE D FROM APP_Platform			D INNER JOIN  #clientId C ON D.clientId		 = C.clientId
-- DELETE D FROM APP_ClientGroupAssoc			D INNER JOIN  #clientId C ON D.clientId		 = C.clientId
-- DELETE D FROM APP_ClientProp			D INNER JOIN  #clientId C ON D.componentNameId		 = C.clientId
-- DELETE D FROM APP_Client			D INNER JOIN  #clientId C ON D.ID		 = C.clientId
-- END 


-- IF object_id('tempdb.dbo.#clientId') is not null DROP TABLE #clientId

END

-- delete all entries related to SRM as per @clientPropInstalledNames table 
DELETE app_clientprop 
FROM @clientPropInstalledNames cpin 
WHERE app_clientProp.attrname = cpin.t_attrname

-- delete all entries related to SRM as per @clientPropInstalledNames table 
DELETE simInstalledPackages 
FROM @clientPropInstalledNames cpin
WHERE simInstalledPackages.simPackageID = cpin.t_simPackageId

IF object_id('tempdb.dbo.#jobtoDelete') is not null DROP TABLE #jobtoDelete

IF object_id('tempdb.dbo.#appId') is not null DROP TABLE #appId
IF object_id('tempdb.dbo.#appTypeId') is not null DROP TABLE #appTypeId
IF object_id('tempdb.dbo.#backupset') is not null DROP TABLE #backupset
IF object_id('tempdb.dbo.#instance') is not null DROP TABLE #instance

SET NOCOUNT ON
IF @@ERROR = 0
	COMMIT TRANSACTION DELETESRMDATA
ELSE
BEGIN
	ROLLBACK TRANSACTION DELETESRMDATA
END




