-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- ++++++++++++++ Delete the Dangling entry from LicUsage table.      ++++++++++++++
-- ++++++++++++++ This code was moved from LicUsage.upg file.         ++++++++++++++
-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

DECLARE @output			VARCHAR(MAX)
DECLARE @newline		CHAR
DECLARE @tabDelim		CHAR

SET @newline	= char(13)
SET @tabDelim	= char(9)
SET @output		= ''

DECLARE @DanglingLicUsageToFix	TABLE (t_id INT, t_clId INT, t_appType INT, t_licType INT, t_oldRel INT)

INSERT INTO @DanglingLicUsageToFix
SELECT	L.id, L.cid, L.appType, L.licType, L.releaseId
FROM	licUsage L JOIN APP_client C ON C.id = L.cid 
WHERE	LicType NOT IN (71, 10, 26) AND OpType = 'Install' AND (C.status & 0x2) > 0 AND
	NOT EXISTS (select * from APP_iDAName where cid = clientId and appType = appTypeId)

DELETE @DanglingLicUsageToFix WHERE t_licType IN(
SELECT simLicAppType FROM simAppTypeLicTypeMap WHERE isCellLevel > 0)
	
DELETE @DanglingLicUsageToFix
WHERE	EXISTS (select * from licUsage where cid = t_clid AND LicType = 16777216 AND optype = 'Install')
	AND
	NOT EXISTS (select * from APP_Client where id = t_clid AND (status & 0x2) = 0)
	AND
	NOT EXISTS (select * from APP_iDAName where clientId = t_clid AND appTypeId = t_appType AND (status & 0x2) = 0)

DELETE D
FROM @DanglingLicUsageToFix D
INNER JOIN MMHost ON t_clId = ClientId
WHERE t_licType IN (11,71,84,132,139,168,169,67108864,33554432)


INSERT INTO @DanglingLicUsageToFix
SELECT id, cid, appType, licType, releaseId
FROM LicUsage
WHERE licType NOT IN (10, 26, 71) AND NOT EXISTS (select * from APP_client C where C.id = cid) AND optype = 'Install'

-- Covers the case to delete dangling rows for lictype 1 and 2
INSERT INTO @DanglingLicUsageToFix
SELECT	L.id, L.cid, L.appType, L.licType, L.releaseId
FROM	licUsage L JOIN APP_client C ON C.id = L.cid 
WHERE	LicType IN (1, 2) AND
	NOT EXISTS (select * from APP_iDAName where cid = clientId and appType = appTypeId)

IF EXISTS (select * from @DanglingLicUsageToFix)
BEGIN
	DELETE LicUsage FROM @DanglingLicUsageToFix WHERE Id = t_Id
	SET @output = @output + '------------------------------' + @newline
	SET @output = @output + 'Deleted dangling licUsage rows:' + @newline
	SELECT @output = @output + 	ISNULL((select name from APP_client where id = t_clId), 'DELETED_CLIENT:' + CAST(t_clId AS VARCHAR(65))) + @tabDelim +
					ISNULL((select name from APP_iDAType where type = t_appType), 'UNKNOWN AGENT') + @tabDelim +
					ISNULL((select short_name from simLicAppTypeV2 where id = t_licType), 'UNKNOWN LICENSE') + @tabDelim +
					ISNULL((select release from simAllGalaxyRel where id = t_oldRel), 'UNKNOWN RELEASE') + @newline FROM @DanglingLicUsageToFix
	PRINT @output
END	

