
set nocount on

SET ANSI_PADDING ON
GO
SET ARITHABORT ON
GO
SET QUOTED_IDENTIFIER ON
GO

BEGIN TRY

    BEGIN TRANSACTION

    declare @srmAgentlessClients table
    (
        clientId int
    )

    insert into @srmAgentlessClients    
    SELECT DISTINCT C.id FROM APP_Client C
    JOIN App_Platform P on P.clientId = C.Id and P.platformType = 4
    WHERE C.Id > 1 
    -- Mini SRM 
    and ( C.Id in (select componentNameId from APP_ClientProp where attrName = 'Mini SRM Agent' AND attrVal = '1' and modified =0))
    -- Not a virtual server discovered client
    and ( C.Id not in (select componentNameId from APP_ClientProp where attrName = 'Virtual Server Discovered Client' AND attrVal = '1' and modified =0))
    -- not a commnet agent
    and ( C.Id not in (select componentNameId from APP_ClientProp where attrName = 'CommNet Agent'

    AND attrVal = '1' and modified =0))    
    -- no package exists 
    and (C.specialClientFlags &11) =11

	IF object_id('tempdb.dbo.#sc') IS NOT null DROP TABLE #sc
    create  table #sc
    (
    client int,
    agent int,
    backupset int,
    sc int
    )
    
    IF object_id('tempdb.dbo.#deconfigClients') IS NOT null DROP TABLE #deconfigClients
    
	create table #deconfigClients
	(
	clientId int
	)     

    insert into #sc
    select clientId,apptypeId,backupSet,id from APP_Application where clientId in (select clientId
    from @srmAgentlessClients)
    
    -- agentless srm deconfigrued clients with no packages
    insert into #deconfigClients select clientId from @srmAgentlessClients where clientId not in ( select distinct client from #sc)

    delete APP_ClientGroupAssoc where clientId in (select distinct clientId from #deconfigClients)
    
    delete APP_OpWindowRule where clientId in (select distinct clientId from #deconfigClients)
    
    delete UMSearchstring where clientId in (select distinct clientId from #deconfigClients)
    
    delete APP_Platform where clientId in (select distinct clientId from #deconfigClients)
    
    delete APP_ClientProp where componentNameId in (select distinct clientId from #deconfigClients)
    
    delete APP_ExtendedProperties where clientId in (select distinct clientId from #deconfigClients)
    
    delete APP_Client where id in (select distinct clientId from #deconfigClients)




    
    --do not delete the clients which has apptypes other than SRM apptype
    delete #sc where client in (select distinct client from #sc where agent not in (600,605))



    delete APP_ScFilterFile where componentNameId in (select sc from #sc)
    
    delete APP_SubClientProp where componentNameId in (select sc from #sc)
    
    delete APP_Application where id in (select sc from #sc)
    
    delete APP_BackupSetProp where componentNameId in (select backupset from #sc)
    
    
    delete APP_BackupSetName where id in (select backupset from #sc)
    
    delete APP_IDAName where clientId in (select distinct client from #sc)
    
    delete APP_ClientGroupAssoc where clientId in (select distinct client from #sc)
    
    delete APP_OpWindowRule where clientId in (select distinct client from #sc)
    
    delete UMSearchstring where clientId in (select distinct client from #sc)
    
    delete APP_Platform where clientId in (select distinct client from #sc)
    
    delete APP_ClientProp where componentNameId in (select distinct client from #sc)
    
    delete APP_ExtendedProperties where clientId in (select distinct client from #sc)
    
    delete APP_Client where id in (select distinct client from #sc)

    COMMIT TRANSACTION
    
    drop table #sc
    
END TRY

BEGIN CATCH

    DECLARE @o_errorCode INT
    DECLARE @tmpErrorString NVARCHAR(MAX)
    
    EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
 
    SELECT @o_errorCode , @tmpErrorString 
    ROLLBACK TRANSACTION
    drop table #sc
    
END CATCH