BEGIN TRANSACTION
DECLARE @errorCode INT = 0
DECLARE @scgExitCode INT
DECLARE @scgExitMsg VARCHAR(1024)
DECLARE @scgId INTEGER
DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
DECLARE @ownerId int = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
DECLARE @masterRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)          --can we assume "1" ? 

SET NOCOUNT ON
	
IF NOT EXISTS (SELECT * from app_clientgroup where name = 'SQL App-Discovered Clients Without SQL Agent Installed')
BEGIN
			-- converted to SCG V2
			DECLARE @SQLAppDiscoveryRuleQuery nvarchar (max) --SCG V1 = 'select id from app_client where ( dbo.scgGetClientProps(id,  ''='', ''12'' ) = 1 )'

			-- CV_FLAG_SMART_CLIENT_GROUP = 0x1000
			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
			values('SQL App-Discovered Clients Without SQL Agent Installed', 'Selects Clients with a SQL instance and no SQL Agent installed', 0x1000, 0, @ownerId, 0, '0', '', 2)
			SET @scgId = SCOPE_IDENTITY()

			SET @scgExitCode = 0
			SET @scgExitMsg = ''

			-- SCG_PKID_CLIENT_PROP=2=propID
			DECLARE @sqlAppDiscoverySCGRule NVARCHAR(1024) = '<scgRule op="0"><rules><rule propID="2" filterID="100" value="13" secValue="SQL App-Discovery" propType="4" /></rules></scgRule>'
			EXEC APPSCGV2GenerateQueryParams @sqlAppDiscoverySCGRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @SQLAppDiscoveryRuleQuery OUTPUT

			IF (@scgExitCode <> 0)
			BEGIN
				PRINT 'Failed to create Clustered Machines Smart Client Group.'
				SET @errorCode = 1
				GOTO END_OF_PROC
			END

			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@scgId, 
				@sqlAppDiscoverySCGRule,
				@SQLAppDiscoveryRuleQuery,
				1, 0, '0')
			
			INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
                SELECT @masterRoleId, 0, @ownerID, 1, 28, @scgId, 1, 1
END

END_OF_PROC:

IF (@errorCode = 0)
BEGIN
	COMMIT TRANSACTION
END
ELSE
BEGIN
	ROLLBACK TRANSACTION
END


 
