

IF EXISTS (SELECT 1 FROM dbo.scgV2ClientWithOnePassEnabled('TRUE',1, 0, 0 /*inSCGId*/) ) 
	AND 
		NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '074C9E24-8DA5-482E-AD51-155BABFCB590' )
BEGIN 
	BEGIN TRY
	BEGIN TRANSACTION 
		DECLARE @errorCode INT = 0
		DECLARE @ownerId INT = ISNULL((SELECT TOP(1) id FROM UMUsers WHERE (flags & 0x40 = 0x40)), 1) 
		DECLARE @monitoringPolicyName NVARCHAR(MAX) = 'System Created-Recall Logs'
		DECLARE @clientGroupName NVARCHAR(MAX) = 'Recall Enabled'
		DECLARE @curUtcDateTime BIGINT = DATEDIFF(second, '01/01/1970', GetUTCdate())
		DECLARE @MonitoringPolicyScriptExec INT = 0
		DECLARE @scgId INT
		DECLARE @SIM_ID_GX_REL110 INT = 16
		DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
		DECLARE @createAsUserID INT     
		IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE attrName = 'Client Group Unique Id' AND attrVal = 12 AND modified = 0 ) 
			AND NOT EXISTS (SELECT 1 FROM App_ClientGroup WHERE name = @clientGroupName )
		BEGIN
			DECLARE @scgExitCode INT = 0
			DECLARE @scgExitMsg NVARCHAR(MAX) = ''
			DECLARE @ruleQuery NVARCHAR(MAX) 
			DECLARE @SCGRule NVARCHAR(MAX)
			DECLARE @masterRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)
			DECLARE @allCapability BIGINT = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(SELECT SUM(POWER(2.0, id-1)) FROM UMCapability))
			
			INSERT INTO App_ClientGroup(name, description,flag,status,userId,refTime, modified,fwPorts,origCCId)
			VALUES (@clientGroupName,'Selects OnePass enabled clients', 0x1000, 0, @ownerId, 0, 0, '', 2)
		
			SET @scgId = SCOPE_IDENTITY()	
			-- Please refer APP_SCGDefines.h for propID
			SET @SCGRule = '<scgRule op="0"><rules><rule op="0"><rules><rule filterID="1" propID="49" propType="1" /></rules></rule></rules></scgRule>'
			EXEC APPSCGV2GenerateQueryParams @SCGRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @ruleQuery OUTPUT
	
			IF (@scgExitCode <> 0)
			BEGIN
				PRINT 'Failed to create Recall Enabled Smart Client Group.'
				SET @errorcode = 1
				GOTO END_OF_PROC
			END
			
			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@scgId, 'Client Group Unique Id', 7, 12, @curUtcDateTime, 0),   
				(@scgId, 'System Created', 7, 0, @curUtcDateTime, 0)

			INSERT INTO App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			VALUES(@scgId, @SCGRule, @ruleQuery,1, 0, 0)
			
			INSERT UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
            SELECT @masterRoleId, 0, @masterUserGroupId, 0, 28, @scgId, 1, 1
			
			EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/, @scgId, @createAsUserID OUTPUT

			UPDATE APP_ClientGroup
			SET userId = @createAsUserID
			WHERE id = @scgID 
				
			EXEC AppSCGRefresh @ownerId, @scgId
			
		END
	
		--create System Created - Recall Logs policy
		DECLARE @SqlScriptGUID uniqueidentifier = '074C9E24-8DA5-482E-AD51-155BABFCB590'
		SELECT @MonitoringPolicyScriptExec = 1
		FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
		WHERE gp.SqlScriptGUID = @SqlScriptGUID
	
		IF(@MonitoringPolicyScriptExec = 0)
		BEGIN
				
				IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)
				BEGIN
							
					DECLARE @templateId INT
					DECLARE @monitoringPolicyId INT		
					DECLARE @templateName NVARCHAR(MAX)
					DECLARE @templateXMLString NVARCHAR(MAX)
					DECLARE @errorString NVARCHAR(1024) = ''
					DECLARE @cloudId INT
					DECLARE @cloudName NVARCHAR(MAX)
					DECLARE @clientGroupId INT
	
					SET @templateName = 'Recall Logs'				        				
					SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status = 4)
					IF @templateId IS NULL
						BEGIN				
							SET @errorCode	= 1
							SET @errorString = N'Recall Log template is not available'
							GOTO END_OF_PROC
						END
	
		
					INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'System created policy for Recall monitoring',1)
					SET @monitoringPolicyId =  (SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPolicyName AND status <> 3)
					
					INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,1)
					INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)
					
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture entire file',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,1,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,'%LOG_DIR%RecalledItems*%LOG_DIR%ArchiveJobStatistics*%LOG_DIR%FileScan*',@curUtcDateTime,@curUtcDateTime)  
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,@ownerId,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,0,@curUtcDateTime,@curUtcDateTime)				
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,0,@curUtcDateTime,@curUtcDateTime)
					INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Factor',7,2,@curUtcDateTime,@curUtcDateTime)				
	
					--Insert cloud info if AnalyticalEngine is already configured
					SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name
						FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)
								ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid
									WHERE roleid = 3
					IF @cloudId IS NOT NULL
					BEGIN
						INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)
						INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    
					END
				
					IF @scgId IS NOT NULL
							INSERT INTO APP_MonitorAssocEntity   VALUES(@monitoringPolicyId,2, 28, @curUtcDateTime, @scgId,0,0)
				
					INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
					VALUES(@SqlScriptGUID, 'RecallMPScriptExec', 'System Created - Recall Logs policy', @curUtcDateTime, @SIM_ID_GX_REL110, 0 , (@SIM_ID_GX_REL110 + 1))
				END                
				
		END
			
	
		END_OF_PROC:
		IF @errorCode=0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION 	   
		
	END TRY
	BEGIN CATCH
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
		PRINT N'Rolling back Transactions.'
		ROLLBACK TRANSACTION 
	END CATCH
END



