DECLARE @SqlScriptGUID uniqueidentifier = 'EC33FD20-9AF9-494A-8B4B-20D4EC52253C'
DECLARE @MonitoringPolicyScriptExec INT =0
SELECT @MonitoringPolicyScriptExec = 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @SqlScriptGUID
IF(@MonitoringPolicyScriptExec = 0)
BEGIN 
	BEGIN TRY
	BEGIN TRANSACTION 
		DECLARE @errorCode INT = 0
		DECLARE @errorString NVARCHAR(1024) = N''        
        DECLARE @SIM_ID_GX_REL110	INT =16
		DECLARE @ownerId INT = ISNULL((SELECT TOP(1) id FROM UMUsers WHERE (flags & 0x40 = 0x40)), 1) 		
		DECLARE @edgeAuditPolicyType INT = 13 -- enum MonitoringType EDGEAUDIT
		DECLARE @basePolicyId INT
		DECLARE @curUtcDateTime BIGINT = DATEDIFF(second, '01/01/1970', GetUTCdate())				
		DECLARE @mpClients TABLE(clientId INT primary key,clientName NVARCHAR(510),basePolicyId INT, policyId INT, policyName NVARCHAR(510))
		DECLARE @mpNew  TABLE(mpId INT primary key,mpName nvarchar(510))
		DECLARE @wqData TABLE(clientId INT,data xml,policyId INT)		
		
		--Update monitoring type for existing policy and add a policy prop for indicating its a base policy.
		SET @basePolicyId = (SELECT TOP 1  monitorPolicyId FROM  App_MonitoringPolicy WITH (NOLOCK) WHERE monitorPolicyName = 'EdgeAudit')
		IF @basePolicyId>0
		BEGIN
			UPDATE App_MonitoringPolicyProp SET attrval ='13' WHERE attrname='Monitoring Type' AND monitorPolicyId = @basePolicyId			
		
			--Get audit enabled edge clients
			INSERT INTO @mpClients(clientId ,clientName ,basePolicyId,policyName)
			SELECT C.id,C.name,@basePolicyId, C.name +' - Edge Audit Policy'
			FROM App_Client C WITH (NOLOCK)  INNER JOIN APP_ClientProp CP  WITH (NOLOCK) ON C.ID = CP.componentNameId
			WHERE CP.attrname like 'Edge Drive Enable Audit' AND CP.attrval='1' AND CP.modified = 0
			
			-- Create seperate policy for each client associated to base policy
			INSERT INTO APP_MonitoringPolicy(commcellId, MonitorPolicyName, created, modified, description, status)
			OUTPUT inserted.monitorPolicyId, inserted.MonitorPolicyName INTO @mpNew
			SELECT MP.commcellId, MPC.policyName, @curUtcDateTime,@curUtcDateTime,MP.description, 1/**creating in disabled state and will activate after association are complete**/
			FROM 
			@mpClients MPC INNER JOIN APP_MonitoringPolicy MP  WITH (NOLOCK) ON MPC.basePolicyId = MP.monitorPolicyId

			UPDATE MPC SET MPC.policyId = MPN.mpId, MPC.policyName = MPN.mpName
			FROM @mpClients MPC INNER JOIN @mpNew MPN ON MPN.mpName = MPC.policyName

			-- Associate edge client to newly created policy
			-- Not associating basepolicy in upgrade. if any customer needs it we can provide a script to associate
			INSERT INTO App_EdgeDriveAssociation(clientId, entityType, entityId)
			SELECT clientId,90/**LM_MONITORING_POLICY_ENTITY**/,policyId from @mpClients
			
			-- Clone prop for newly created policies
			INSERT INTO APP_MonitoringPolicyProp(monitorPolicyId, commcellId, attrName, attrType, attrVal, created, modified)
			SELECT MPC.policyId,MPP.commcellId,MPP.attrName,MPP.attrType,
			(CASE MPP.attrName WHEN 'Content' THEN '%LOG_DIR%EdgeDrive\'+MPC.policyName ELSE MPP.attrVal END),
			@curUtcDateTime,
			@curUtcDateTime
			FROM 
			@mpClients MPC INNER JOIN APP_MonitoringPolicyProp MPP  WITH (NOLOCK) ON MPC.basePolicyId = MPP.monitorPolicyId
			
			-- Mark base policy in case if needed to combine data from base and new policy
			IF NOT EXISTS(SELECT 1 FROM APP_MonitoringPolicyProp WITH (NOLOCK)  WHERE monitorPolicyId = @basePolicyId and attrname = 'IsBasePolicy')
			BEGIN			
				INSERT INTO APP_MonitoringPolicyProp(monitorPolicyId, commcellId, attrName, attrType, attrVal, created, modified)
				SELECT @basePolicyId,2,'IsBasePolicy',2,'1',@curUtcDateTime, @curUtcDateTime
			END

			-- Clone template association for newly created policies
			INSERT INTO App_MonitorTemplateAssoc(monitorPolicyId, commcellId, templateId)
			SELECT MPC.policyId,MPT.commcellId,MPT.templateId
			FROM 
			@mpClients MPC INNER JOIN APP_MonitorTemplateAssoc MPT  WITH (NOLOCK) ON MPC.basePolicyId = MPT.monitorPolicyId
			
			-- Clone client association for newly created policies
			INSERT INTO APP_MonitorAssocEntity(monitorPolicyId,commcellId,flags,created,clientGroupId,clientId,exclude)
			SELECT MPC.policyId,MPE.commcellId,MPE.flags,@curUtcDateTime,MPE.clientGroupId,MPE.clientId,MPE.exclude
			FROM 
			@mpClients MPC INNER JOIN APP_MonitorAssocEntity MPE  WITH (NOLOCK) ON MPC.basePolicyId = MPE.monitorPolicyId

			--Activate newwly created policy
			UPDATE MP SET MP.status = 0
			FROM App_MonitoringPolicy MP  WITH (NOLOCK) INNER JOIN @mpClients MPC  ON MP.monitorPolicyId = MPC.policyId

			--Push Workqueue token to all clients associated to newly created policy
			--Prepare WQ Data
			INSERT INTO @wqData
			SELECT	MPE.clientId,
					(SELECT  1 /**EDIT**/ '@operation', MPC.policyId '@monitoringPolicyId', 3 '@clientId' FOR XML PATH('TMMsg_MonitoringPolicyChangeReq'), TYPE ),
					MPC.policyId
			FROM 
			@mpClients MPC INNER JOIN APP_MonitorAssocEntity MPE  WITH (NOLOCK) ON MPC.policyId = MPE.monitorPolicyId			

			--To avoid cursors using dynamic query to execute multiple workqueue
			--Sample Workqueue data xml
			--<TMMsg_MonitoringPolicyChangeReq operation="1" monitoringPolicyId="23" clientId="3"/>
			-- roll back is not required if workqueue fails
			DECLARE @sql NVARCHAR(MAX) = N'DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))'+  NCHAR(13)
										+N'DECLARE @errCode INT = 0' + NCHAR(13) + N'DECLARE @errString NVARCHAR(1024) = N''''' +  NCHAR(13)
			SELECT @sql += N' INSERT @workQOutPutTbl'+  NCHAR(13)
					+N' EXEC AppWorkQueueSubmitRequest 8 /*WORK_TOKEN_LOGMONITORING*/, 0, 0, ' + CAST(clientId AS NVARCHAR(12)) + N', 0, N''' + CAST(data as NVARCHAR(256)) + N'''' + NCHAR(13)
					+N' SELECT @errCode = errCode, @errString = errString FROM @workQOutPutTbl'+  NCHAR(13)
				   + N' IF (@errCode > 0) BEGIN ' + NCHAR(13)
				   + N' GOTO END_CMD ' + NCHAR(13)
				   + N' END'  + NCHAR(13)
			FROM @wqData
			SET @sql += N'END_CMD:' + NCHAR(13) + N'PRINT N''WorkQueue Submitted. ErrorNo('' + CAST(@errCode AS NVARCHAR) + N'') ErrorMsg('' + @errString + N'').''' + NCHAR(13)
			
			EXEC(@sql)
		END
					
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
		VALUES(@SqlScriptGUID, 'EdgeAuditUpgradeScriptExec', 'Upgrade script to create seperate policy for audit enabled edge clients.', @curUtcDateTime, @SIM_ID_GX_REL110, 0 , (@SIM_ID_GX_REL110 + 1))
			
		END_OF_PROC:
		IF @errorCode=0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION 	   
		
	END TRY
	BEGIN CATCH
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
		PRINT N'Rolling back Transactions.'
		ROLLBACK TRANSACTION 
	END CATCH
END
