
DECLARE @scgId INTEGER
DECLARE @allCapability bigint = ISNULL((SELECT (CASE WHEN ISNUMERIC(CAST(value AS NVARCHAR(MAX))) = 1 THEN CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) ELSE NULL END) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
DECLARE @ownerId int = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
DECLARE @masterRoleId INT = ISNULL((SELECT TOP(1) id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)

DECLARE @scgExitCode INT = 0
DECLARE @scgExitMsg VARCHAR(1024) = ''
DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
DECLARE @createAsUserID INT
DECLARE @unixTime INT = dbo.getUnixTime(GETDATE())                                   
IF NOT EXISTS (SELECT 1 from app_clientgroup WHERE (flag & 0x80000) != 0)
BEGIN
			-- SCG_PKID_CLIENT_PROP=2=prodId
			DECLARE @CSClientGroupRule nvarchar (max) = '<scgRule op="0"><rules><rule op="1"><rules><rule filterID="100" propID="2" propType="4" secValue="CS Client" value="11" /></rules><rules><rule filterID="100" propID="2" propType="4" secValue="MediaAgent" value="5" /></rules><rules><rule filterID="108" propID="9" propType="6" value="&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;&lt;App_AdvanceKeyInfo&gt;&lt;packages val=&quot;726&quot; /&gt;&lt;packages val=&quot;252&quot; /&gt;&lt;packages val=&quot;263&quot; /&gt;&lt;packages val=&quot;55&quot; /&gt;&lt;/App_AdvanceKeyInfo&gt;" /></rules><rules><rule filterID="1" propID="24" propType="1" /></rules></rule></rules></scgRule>'

			DECLARE @CSClientGroupRuleQuery NVARCHAR (MAX) = ''
			EXEC APPSCGV2GenerateQueryParams @CSClientGroupRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @CSClientGroupRuleQuery OUTPUT



			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
			values('Infrastructure', 'Select CS, MA, WebConsole, WebServer, Index Gateway, Index Store, proxy clients.', 0x81000, 0, @ownerId, 0, '0', '', 2)
			SET @scgId = @@IDENTITY

			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@scgId, 
				@CSClientGroupRule,
				@CSClientGroupRuleQuery,
				1, 0, '0')

			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@scgId, 'Client Group Unique Id', 7, 3, @unixTime, 0),   
				(@scgId, 'System Created', 7, 0, @unixTime, 0)

			--can we call sec_setCreatorForEntity stored procedure from here ? 
			INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
				SELECT @masterRoleId, 0, @masterUserGroupId, 0, 28, @scgId, 1, 1

			EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/, @scgId, @createAsUserID OUTPUT

			UPDATE APP_ClientGroup
			SET userId = @createAsUserID
			WHERE id = @scgID 
				
			EXEC AppSCGRefresh 1, @scgId
END


IF NOT EXISTS (SELECT 1 from app_clientgroup WHERE (flag & 0x100000) != 0)
BEGIN
			--SCG_PKID_CLIENT_ACTS_AS_PROXY=24=prodId
			DECLARE @ProxyClientRule nvarchar (max) = '<scgRule op="0"><rules><rule op="0"><rules><rule filterID="1" propID="24" propType="1" /></rules></rule></rules></scgRule>'

			DECLARE @ProxyClientRuleQuery NVARCHAR (MAX) = ''			
			EXEC APPSCGV2GenerateQueryParams @ProxyClientRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @ProxyClientRuleQuery OUTPUT			

			insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
			values('Proxy Clients', 'Select proxy clients', 0x101000, 0, @ownerId, 0, '0', '', 2)
			SET @scgId = @@IDENTITY

			insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			values(@scgId, 
				@ProxyClientRule,
				@ProxyClientRuleQuery,
				1, 0, '0')

			-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
			INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@scgId, 'Client Group Unique Id', 7, 4, @unixTime, 0),
				(@scgId, 'System Created', 7, 0, @unixTime, 0)
					
			--can we call sec_setCreatorForEntity stored procedure from here ? 
			INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
				SELECT @masterRoleId, 0, @masterUserGroupId, 0, 28, @scgId, 1, 1

			EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/, @scgId, @createAsUserID OUTPUT

			UPDATE APP_ClientGroup
			SET userId = @createAsUserID
			WHERE id = @scgID
			
			EXEC AppSCGRefresh 1, @scgId
END

