--  This script is to Convert all existing V3 passwords to V5 password.
DISABLE TRIGGER APP_InstancePropTableChange ON APP_InstanceProp
GO

DISABLE TRIGGER APP_ClientPropTableChange ON App_ClientProp
GO

DISABLE TRIGGER APP_BackupSetPropTableChange ON APP_BackupSetProp
GO

DISABLE TRIGGER APP_IDAPropTableChange ON APP_IDAProp
GO

SET NOCOUNT ON;
SET QUOTED_IDENTIFIER ON
GO

DECLARE @curTime INT 

SET @curTime  = datediff(second, '01/01/1970', GETDATE())

--UPDATE ALL EXISTING V3 PASSWORD TO V5 PASSWORD FOR INSTANCE PROPERTIES

DECLARE @guid VARCHAR(40) = 'D0C98531-04BE-46C0-AFF9-B5696465FA91'
DECLARE @specialPropFlag INT = 32 -- Special property flag, XML, comma separated, semicolon separated
IF NOT EXISTS (SELECT * FROM GXUNIQUESQLSCRIPTEXECTRACKING GP WHERE GP.SQLSCRIPTGUID = @guid)
BEGIN
	DECLARE @i INT = 0
	WHILE @i < 3
	BEGIN
		BEGIN TRY
			BEGIN TRAN UpdatePwdToV5
					
			DECLARE @InstPropTableId INT = 41 -- APP_InstanceProp table id
			
			UPDATE AI SET attrVal = dbo.pswConvertV3ToV5(AI.attrVal) FROM APP_InstanceProp AI JOIN APP_CredProps ACP WITH(NOLOCK)
				ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = AI.attrName AND ACP.cs_attrPwdName = CHECKSUM(AI.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag
	
			DECLARE @CV_CASSANDRA_JMX_CONFIG NVARCHAR(50) = 'Cassandra gateway configuration'
			IF EXISTS(SELECT 1 FROM APP_InstanceProp INS JOIN APP_CredProps ACP WITH(NOLOCK)
					ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName 
						AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_CASSANDRA_JMX_CONFIG)
			BEGIN
				DECLARE @jmxConnection TABLE(id INT, attrVal XML, passwordV5 NVARCHAR(MAX))
				INSERT INTO @jmxConnection 
							SELECT id, attrVal, 
								dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_JMXConnection/userPassword/@password)[1]', 'NVARCHAR(MAX)'))
							FROM APP_InstanceProp INS 
							WHERE INS.attrName = @CV_CASSANDRA_JMX_CONFIG
				UPDATE @jmxConnection SET attrVal.modify('replace value of (/App_JMXConnection/userPassword/@password)[1] with sql:column("passwordV5")')
						
				UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal) 
					FROM APP_InstanceProp AI JOIN @jmxConnection A ON AI.id = A.id
			END

			DECLARE @CV_CASSANDRA_AUTH_CONFIG NVARCHAR(50) = 'Cassandra Authentication Configurations'
			IF EXISTS(SELECT 1 FROM APP_InstanceProp INS JOIN APP_CredProps ACP WITH(NOLOCK)
					ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName 
						AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_CASSANDRA_AUTH_CONFIG)
			BEGIN    
				DECLARE @authConfig TABLE(id INT, attrVal XML, keyStorePasswordV5 NVARCHAR(MAX), trustStorePasswordV5 NVARCHAR(MAX))
				INSERT INTO  @authConfig 
							SELECT id, attrVal, 
								dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_AuthConfig/sslConfig/@keyStorePass)[1]', 'NVARCHAR(MAX)')),
								dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_AuthConfig/sslConfig/@trustStorePass)[1]', 'NVARCHAR(MAX)'))
							FROM APP_InstanceProp INS 
							WHERE INS.attrName = @CV_CASSANDRA_AUTH_CONFIG
				UPDATE @authConfig SET attrVal.modify('replace value of (/App_AuthConfig/sslConfig/@keyStorePass)[1] with sql:column("keyStorePasswordV5")')
				UPDATE @authConfig SET attrVal.modify('replace value of (/App_AuthConfig/sslConfig/@trustStorePass)[1] with sql:column("trustStorePasswordV5")')    
				
				UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal) 
					FROM APP_InstanceProp AI JOIN @authConfig A ON AI.id = A.id
			END
			
		--UPDATE ALL EXISTING V3 PASSWORD TO V5 PASSWORD FOR CLIENT PROPERTIES	 	
			DECLARE @ClientPropTableId INT = 21 -- APP_ClientProp table id
 
			UPDATE AC SET attrVal = dbo.pswConvertV3ToV5(AC.attrVal) FROM App_ClientProp AC JOIN APP_CredProps ACP WITH(NOLOCK)
				ON ACP.tableId = @ClientPropTableId AND ACP.attrPwdName = AC.attrName AND ACP.cs_attrPwdName = CHECKSUM(AC.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag
			
			DECLARE @CV_CLOUD_APPS_CRED NVARCHAR(50) = 'Cloud Apps Credentials'
			IF EXISTS(SELECT 1 FROM APP_ClientProp INS JOIN APP_CredProps ACP WITH(NOLOCK)
						ON ACP.tableId = 21 AND ACP.attrPwdName = INS.attrName 
						AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_CLOUD_APPS_CRED)
			BEGIN
				DECLARE @cloudApps TABLE(id INT, attrVal XML, passwordV5 NVARCHAR(MAX))
				INSERT INTO @cloudApps 
							SELECT INS.id, attrVal, 
								dbo.pswConvertV3ToV5(
								CASE WHEN CONVERT(XML, attrVal).value('(/App_AzureResourceManager/credentials/@password)[1]', 'NVARCHAR(MAX)') IS NOT NULL
									THEN CONVERT(XML, attrVal).value('(/App_AzureResourceManager/credentials/@password)[1]', 'NVARCHAR(MAX)')
									WHEN CONVERT(XML, attrVal).value('(/App_AmazonInstanceInfo/@secretkey)[1]', 'NVARCHAR(MAX)') IS NOT NULL 
									THEN CONVERT(XML, attrVal).value('(/App_AmazonInstanceInfo/@secretkey)[1]', 'NVARCHAR(MAX)')
								END)
							FROM APP_ClientProp INS JOIN APP_CredProps ACP WITH(NOLOCK)
								ON ACP.tableId = 21 AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_CLOUD_APPS_CRED
								
				UPDATE @cloudApps SET attrVal.modify('replace value of (/App_AzureResourceManager/credentials/@password)[1] with sql:column("passwordV5")')
				UPDATE @cloudApps SET attrVal.modify('replace value of (/App_AmazonInstanceInfo/@secretkey)[1] with sql:column("passwordV5")')
				UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal) 
					FROM APP_ClientProp AI JOIN @cloudApps A ON AI.id = A.id
			END					

		--UPDATE ALL EXISTING V3 PASSWORD TO V5 PASSWORD FOR CLIENT PROPERTIES
	 
			DECLARE @BkpSetPropTableId INT = 51 -- APP_BackupSetProp table id
 
			UPDATE AB SET attrVal = dbo.pswConvertV3ToV5(AB.attrVal) FROM APP_BackupSetProp AB JOIN APP_CredProps ACP WITH(NOLOCK)	 
				ON ACP.tableId = @BkpSetPropTableId AND ACP.attrPwdName = AB.attrName AND ACP.cs_attrPwdName = CHECKSUM(AB.attrName)			 
		

		--UPDATE ALL EXISTING V3 PASSWORD TO V5 PASSWORD FOR IDA PROPERTIES

		
			DECLARE @IDAPropTableId INT = 31 -- APP_IDAProp table id
 		
			UPDATE AIP SET attrVal = dbo.pswConvertV3ToV5(AIP.attrVal) FROM APP_IDAProp AIP JOIN APP_CredProps ACP WITH(NOLOCK)
				ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = AIP.attrName	AND ACP.cs_attrPwdName = CHECKSUM(AIP.attrName)
		
		--INSERT the GUID so that script won't run again
		
			INSERT INTO GXUNIQUESQLSCRIPTEXECTRACKING(SQLSCRIPTGUID, NAME, DESCRIPTION, CREATEDTIME, CREATEDRELID, EXPIRETIME, EXPIRERELID)
				VALUES (@guid, 'Update All Password Property to V5', 'Update all V3 Instance/Client/Backupset/IDA Password Property to V5.', @curTime,  16, 0, (16 + 2))	

			

			SET @i = 3
			COMMIT TRAN UpdatePwdToV5
		END TRY
		BEGIN CATCH
			ROLLBACK TRAN UpdatePwdToV5		
			WAITFOR DELAY '00:00:05'
			SET @i = @i + 1
		END CATCH
	END
END

SET NOCOUNT OFF; 

GO

ENABLE TRIGGER APP_InstancePropTableChange ON APP_InstanceProp
GO

ENABLE TRIGGER APP_ClientPropTableChange ON App_ClientProp
GO

ENABLE TRIGGER APP_BackupSetPropTableChange ON APP_BackupSetProp
GO

ENABLE TRIGGER APP_IDAPropTableChange ON APP_IDAProp
GO

		