GO
SET QUOTED_IDENTIFIER ON
GO

--****************************************************************************************************************************
-- 100012 License has been moved from Usage based category to the CELL Level License
-- 100012 has been removed and replaced by 203

--****************************************************************************************************************************
--Update Licensing Static simLicAppTypeV2,simAppTypeLicTypeMap  table
--****************************************************************************************************************************

declare @licType     INT = 100012
DECLARE @NewLicType  INT = 203

IF NOT EXISTS(SELECT * FROM simLicAppTypeV2 WHERE id=@NewLicType)
BEGIN
	INSERT INTO simLicAppTypeV2 values (@NewLicType,'Protected Mailboxes',1)
	UPDATE simAppTypeLicTypeMap  SET simLicAppType=@NewLicType WHERE simLicAppType=@licType
END

--****************************************************************************************************************************
--Check LICAAL table...if Nothing is applied... No need to convert.
--****************************************************************************************************************************

DECLARE @LicTotal             INT = 0
declare @LicUsed              INT = 0
DECLARE @CommcellID           INT = 2
DECLARE @licEncField          VARCHAR(2048)=''
DECLARE     @licPermFld       VARCHAR(64)=''
DECLARE     @licEvalFld       VARCHAR(64)=''
DECLARE @bIsEval              INT = 0
DECLARE @aalIsEval            INT = 0
DECLARE @aalEvalDays          INT = 0
DECLARE @NewLicTotal          INT = 1
DECLARE @NewLicUsed           INT = 1


IF NOT EXISTS(SELECT * FROM LICAAL WHERE simLicAppTypeId=@NewLicType)
BEGIN
	SELECT @licEvalFld =  RTRIM(eval_fld1), @licPermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @licType AND commcellId = @CommcellID
	IF (@licEvalFld!='' or @licPermFld!='')
	BEGIN
		--****************************************************************************************************************************
		-- Fix the LicAAL table\
		-- @aalIsEval -> Returns -1 for permanent... Returns greater than Zero for Eval.
		--****************************************************************************************************************************

		declare @EncField  VARCHAR(2048) 
		IF @licPermFld != ''
		BEGIN
			SET @bIsEval = 0
			SET @EncField = @licPermFld
		END
		ELSE
		BEGIN
			SET @bIsEval = 1
			SET @EncField = @licEvalFld
		END
		
		
		EXEC dbo.xp_getAALInfo2 @EncField, @LicTotal OUTPUT, @LicUsed OUTPUT, @aalIsEval OUTPUT, @aalEvalDays OUTPUT
		EXEC dbo.xp_buildAALFld @NewLicType, @NewLicTotal, @NewLicUsed, @aalEvalDays, @bIsEval, @licEncField OUTPUT
	END
	
	IF @licEncField = ''
	BEGIN
      		--If not exist give 180 days eval licenses....
	  	SET @bIsEval = 1
		SET @aalEvalDays = 180
	  	EXEC dbo.xp_buildAALFld @NewLicType, @NewLicTotal, @NewLicUsed, @aalEvalDays, @bIsEval, @licEncField OUTPUT
	END

	IF  (@licPermFld<>'') --Perm    
		INSERT INTO LicAAL SELECT @NewLicType,'',REPLACE(@licEncField, CHAR(0), ''),@CommcellID
	ELSE
		INSERT INTO LicAAL SELECT @NewLicType,REPLACE(@licEncField, CHAR(0), ''),'',@CommcellID
END
		
--****************************************************************************************************************************
--Fix the LicUsage table
--****************************************************************************************************************************
IF NOT EXISTS(SELECT * FROM LicUsage WHERE licType=@NewLicType)
BEGIN
      declare  @STR_DASH varchar(5) = ':-'
      declare @LicUsageData varchar(100)
      DECLARE @str0       VARCHAR(32) = '0'
      DECLARE @newEncFld  VARCHAR(MAX)
      --> Step1: Check the License presence in the LicAAL table.
      --> Step2: If the License present in the LicAAL table and  not in Licusage table needs to insert the new row based on the PERM /EVal.


      --If exists conver the license to @NewLicType
      -- This is usage based license so.. It will get in to the usage based table when it's installed...

      IF EXISTS(SELECT * FROM LICUSAGE WHERE LICTYPE=@licType)
            BEGIN
                  select @LicUsageData = Name + @STR_DASH + CAST(Cid AS VARCHAR(64)) + @STR_DASH + CAST(@NewlicType AS VARCHAR(64)) + 
                                    @STR_DASH + CAST(appType AS VARCHAR(64)) + @STR_DASH + Ltrim(rtrim(opType)) + @STR_DASH + 
                                    CAST(dbo.GetUnixTime(opTimeutc) AS VARCHAR(64)) + @STR_DASH + @str0 + @STR_DASH + 
                                    CAST(Eval AS VARCHAR(64)) + @STR_DASH + CAST(dbo.GetUnixTime(ExpiryDateUTC) AS VARCHAR(64)) + 
                                    @STR_DASH + CAST(ReleaseId AS VARCHAR(64)) + @STR_DASH + CAST(SimOSID AS VARCHAR(64)) + 
                                    @STR_DASH + Build + @STR_DASH + @str0
                  from licusage where licType = @licType
                                                
                  EXEC pswEncryptionManaged @LicUsageData, @newEncFld OUTPUT
                  IF @newEncFld IS NOT NULL AND LEN(@newEncFld) > 0
                  BEGIN       
                        Update LicUsage set LicType = @NewlicType, EncryptedField=REPLACE(@newEncFld, CHAR(0), '') , UsedCapacity= 0 where LicType = @licType      
                  END
            END
      ELSE
            BEGIN
                  ----If NOT exists convert & Insert into the license table.              
                  declare @ReleaseId varchar(10) 
                  declare @simosid varchar(10)
                  declare @ExpiryDateUTC int =0
                  declare @NewApptype int = 1130                  
                  declare @buildStr varchar(15)
                  DECLARE @opTime     DATETIME =  GetUTCDate()
                  DECLARE @CSClientAppType int = 1001
                  DECLARE @CSClientID	INT = 2
                  DECLARE @optype varchar(15) = 'Install'

                  if (@bIsEval >0)  -- Eval 
                        BEGIN
                              --Get the base license info and insert into the converted license type....                          
                              set @ExpiryDateUTC = dbo.GetUNIXTime(GetDate()) + @aalEvalDays * 24 * 60 * 60                                              
                        END
                  else
                              BEGIN
                              /********************************************************************************/
                              /* GET THE LAST APPLIED LICENSE KEY FROM LICCSL AND GET THE PERM EXP/DATE/ DAYS  */
                              /********************************************************************************/
                              
                              DECLARE     @MachIDInKey            INT ,@DRMachIDInKey           INT
                              DECLARE     @newRepMachIDInKey      INT, @csIdInKey               INT
                              DECLARE     @OEMIdInKey             INT, @isCSEvalInKey           INT
                              DECLARE     @relnumInKey            INT, @keyTypeInKey            INT
                              DECLARE     @rmkcInKey              INT, @evalDaysInKey           INT, @expDateInKey      INT
							  DECLARE 	  @csGUIDInKey       VARCHAR(64)
							  DECLARE 	  @commcellFlagInKey                   INT

                              DECLARE     @enclicInKey            VARCHAR(8000),  @licTypeList VARCHAR(8000)
                              declare @i_encLicKey  VARCHAR(8000) 
                              select @i_encLicKey = EncLicKey from LicCsl where id = (select max(id) from liccsl)

                              EXEC dbo.xp_RetrieveValidateLicKeyInfo @i_encLicKey, @MachIDInKey OUTPUT, @DRMachIDInKey OUTPUT, 
                                          @newRepMachIDInKey OUTPUT, @csIdInKey OUTPUT, @OEMIdInKey OUTPUT, @isCSEvalInKey OUTPUT, 
										  @relnumInKey OUTPUT, @keyTypeInKey OUTPUT, @rmkcInKey OUTPUT, 
                                          @evalDaysInKey OUTPUT, @expDateInKey OUTPUT, @enclicInKey OUTPUT, @licTypeList OUTPUT,
										  @csGUIDInKey OUTPUT, @commcellFlagInKey OUTPUT
                              
                              /********************************************************************************/                                            
                              IF    (@expDateInKey >0)      --Perm Extn ..
                                    SET @ExpiryDateUTC = @expDateInKey
                        END

                        select @LicUsageData = Name + @STR_DASH + CAST(Cid AS VARCHAR(64)) + @STR_DASH + CAST(@NewlicType AS VARCHAR(64)) + 
                                          @STR_DASH + CAST(@NewApptype AS VARCHAR(64)) + @STR_DASH + @optype + @STR_DASH + 
                                          CAST( dbo.GetUNIXTime(@opTime) AS VARCHAR(64)) + @STR_DASH + @str0 + @STR_DASH + 
                                          CAST(1 AS VARCHAR(64)) + @STR_DASH + CAST(@ExpiryDateUTC AS VARCHAR(64)) +  -- This is Eval so Eval fields =1
                                          @STR_DASH + CAST(ReleaseId AS VARCHAR(64)) + @STR_DASH + CAST(SimOSID AS VARCHAR(64)) + 
                                          @STR_DASH + Build + @STR_DASH + @str0 
                                    from licusage where cid = @CSClientID and apptype=@CSClientAppType 

                  IF (@LicUsageData<>'')  -- One more check...
                  BEGIN
                        EXEC pswEncryptionManaged @LicUsageData, @newEncFld OUTPUT
                        IF @newEncFld IS NOT NULL AND LEN(@newEncFld) > 0
                        BEGIN       							
                              INSERT INTO LicUsage
                                SELECT Name, cid, @NewLicType, @NewApptype, @optype, @opTime, 0, @bIsEval, dbo.GetDateTime(@ExpiryDateUTC), 
                                    ReleaseId, REPLACE(@newEncFld, CHAR(0), ''), SimOSID, Build, 0, 0, 0 FROM LICUSAGE
				WHERE cid = @CSClientID and apptype=@CSClientAppType
                        END
                  END
                        
            END


			--At the End insert the Cell level license to the App_Client Prop table.
			IF NOT EXISTS(SELECT * FROM APP_ClientProp WHERE attrName='Protected Mailboxes')
				INSERT INTO APP_ClientProp(componentNameId,attrName,attrType,attrVal,created,modified)
				SELECT '2','Protected Mailboxes',2,1,dbo.GetUNIXTime(GetDate()),0

END


SCRIPT_EXIT:

--****************************************************************************************************************************
-- Delete the Old License. 
--****************************************************************************************************************************
DELETE FROM LicUsage WHERE licType = @licType
DELETE FROM LicAal WHERE simLicAppTypeId = @licType
DELETE FROM simAppTypeLicTypeMap WHERE simLicAppType = @licType
DELETE FROM simLicAppTypeV2 WHERE ID = @licType
DELETE FROM LicUsageBasedConfig WHERE attrName LIKE '%PROTECTED%'
--****************************************************************************************************************************

GO
SET QUOTED_IDENTIFIER OFF
GO
