
SET NOCOUNT ON

DECLARE @deviceListCursorFlag 	INTEGER
SET 	@deviceListCursorFlag 	= 0

DECLARE @curDeviceId	INTEGER
SET 	@curDeviceId	= 0

DECLARE @errorCode INTEGER
SET		@errorCode = 0

--Get the list of deviceIds that are associated to multiple mounthpaths
DECLARE	DeviceListCursor CURSOR STATIC FOR
SELECT DeviceId
FROM MMMountPathToStorageDevice WITH (NOLOCK)
WHERE DeviceId > 0
AND CenteraId = 0
GROUP BY DeviceId
HAVING COUNT(*) > 1

SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
		
SET	@deviceListCursorFlag = 1
OPEN DeviceListCursor

SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT

DECLARE @skippedFirstMountPath INT
SET @skippedFirstMountPath = 0

FETCH NEXT 
FROM DeviceListCursor
INTO @curDeviceId

SET	@errorCode	=	@@ERROR
IF	@errorCode != 0 GOTO CX_EXIT
	
WHILE	@@FETCH_STATUS = 0
BEGIN
	SET @skippedFirstMountPath = 0

	DECLARE @mountPathListCursorFlag INTEGER
	SET		@mountPathListCursorFlag = 0

	DECLARE @curMountPathId	INTEGER
	SET 	@curMountPathId	= 0

	--Get the list of mountPathIds that are associated to a deviceId
	DECLARE	MountPathListCursor CURSOR STATIC FOR
	SELECT mountPathId
	FROM MMMountPathToStorageDevice WITH (NOLOCK)
	WHERE deviceId = @curDeviceId

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	SET @mountPathListCursorFlag = 1
	OPEN MountPathListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH NEXT 
	FROM MountPathListCursor
	INTO @curMountPathId

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		DECLARE @newDeviceId INTEGER
		SET		@newDeviceId = 0
			
		--Skip the first mounthpath to device mapping and create new device for rest of mounth paths
		IF (@skippedFirstMountPath = 0)
		BEGIN
			FETCH NEXT 
			FROM MountPathListCursor
			INTO @curMountPathId

			IF @@FETCH_STATUS != 0
				BREAK

			SET @skippedFirstMountPath = 1
		END


	
		INSERT INTO MMDevice (AliasName, DeviceEnabled, DeviceBroken, DeviceTypeId, NumRestoresLifeTime, NumBackupsLifeTime, NumMountsLifeTime, NumErrsLifeTime, MinutesUsedLifeTime,
							  OfflineReason, SNRPartitionId, DeviceStatus, DRUId, DeviceAttributes, DRUDeviceId, RMStatus, RMStatusUpdateTime, origCCId, origDeviceId,DisplayDeviceTypeId)
		SELECT 'System Created Device', DeviceEnabled, DeviceBroken, DeviceTypeId, NumRestoresLifeTime, NumBackupsLifeTime, NumMountsLifeTime, NumErrsLifeTime, MinutesUsedLifeTime,
			   OfflineReason, SNRPartitionId, DeviceStatus, DRUId, DeviceAttributes, DRUDeviceId, RMStatus, RMStatusUpdateTime, origCCId, origDeviceId,DisplayDeviceTypeId
		FROM MMDevice
		WHERE DeviceId = @curDeviceId

		SELECT	@newDeviceId = SCOPE_IDENTITY(), @errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		UPDATE MMDevice
		SET AliasName = 'Device_' + CAST(deviceId AS VARCHAR(20))
		WHERE deviceId = @newDeviceId

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		DECLARE @deviceCtrlId INTEGER, @deviceControllerListCursorFlag INTEGER, @credentialAssocId INTEGER
		SET		@deviceCtrlId = 0
		SET		@deviceControllerListCursorFlag = 0
		SET		@credentialAssocId = 0

		INSERT INTO MMDeviceController (ClientId, DeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount, UserName, UserPassword, Folder, DeviceMounted,
										DeviceAccessible, VolumeRecoveryStatus, VolumeRecoveryTime, VolumeScsiReserved, DeviceAccessType, RMStatus, RMStatusUpdateTime, CredentialAssocId)
		SELECT ClientId, @newDeviceId, DeviceControllerActive, DeviceControllerEnabled, SNRVolumeId, UseCount, UserName, UserPassword, Folder, DeviceMounted,
										DeviceAccessible, VolumeRecoveryStatus, VolumeRecoveryTime, VolumeScsiReserved, DeviceAccessType, RMStatus, RMStatusUpdateTime, CredentialAssocId
		FROM MMDeviceController
		WHERE DeviceId = @curDeviceId

		-- If a credential was used we need to create a new credential association and re-associate with all new devicecontrollers
		DECLARE	DeviceControllerListCursor CURSOR STATIC FOR
		SELECT DeviceControllerId, CredentialAssocId
		FROM MMDeviceController WITH (NOLOCK)
		WHERE DeviceId = @newDeviceId
		AND CredentialAssocId > 0

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		SET	@deviceControllerListCursorFlag = 1
		OPEN DeviceControllerListCursor

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH NEXT 
		FROM DeviceControllerListCursor
		INTO @deviceCtrlId, @credentialAssocId

		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DECLARE @newCredentialAssocId INTEGER
			SET @newCredentialAssocId = 0

			INSERT INTO APP_CredentialAssoc (credentialId, entityType, entityId)
			SELECT credentialId, entityType, @deviceCtrlId
			FROM APP_CredentialAssoc
			WHERE assocId = @credentialAssocId

			SELECT	@newCredentialAssocId = SCOPE_IDENTITY(), @errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT

			-- Update MMDeviceController with new credential association
			UPDATE MMDeviceController
			SET CredentialAssocId = @newCredentialAssocId
			WHERE DeviceControllerId = @deviceCtrlId

			FETCH NEXT 
			FROM DeviceControllerListCursor
			INTO @deviceCtrlId, @credentialAssocId

			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		UPDATE MMMountPathToStorageDevice
		SET deviceId = @newDeviceId
		WHERE mountPathId = @curMountPathId

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		IF @deviceControllerListCursorFlag = 1
		BEGIN
			CLOSE DeviceControllerListCursor
			DEALLOCATE DeviceControllerListCursor
			SET @deviceControllerListCursorFlag = 0
		END

		FETCH NEXT 
		FROM MountPathListCursor
		INTO @curMountPathId

	END

	FETCH NEXT 
	FROM DeviceListCursor
	INTO @curDeviceId
	
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	IF @mountPathListCursorFlag = 1
	BEGIN
		CLOSE MountPathListCursor
		DEALLOCATE MountPathListCursor
		SET @mountPathListCursorFlag = 0
	END
END

CX_EXIT:
	IF @mountPathListCursorFlag = 1
	BEGIN
		CLOSE MountPathListCursor
		DEALLOCATE MountPathListCursor
	END
	
	IF @deviceListCursorFlag = 1
	BEGIN
		CLOSE DeviceListCursor
		DEALLOCATE DeviceListCursor
	END

	IF @deviceControllerListCursorFlag = 1
	BEGIN
		CLOSE DeviceControllerListCursor
		DEALLOCATE DeviceControllerListCursor
		SET @deviceControllerListCursorFlag = 0
	END

SET NOCOUNT OFF
