--****************************************************************************************************************************
-- Mac clients will consume Laptop and Desktop License instead of FS Server license
--****************************************************************************************************************************
DECLARE @nErrCode		INT = 0
DECLARE @sErrStr 		VARCHAR(MAX)
DECLARE @MACAppType  		INT = 63
DECLARE @oldlicType  		INT = 1
DECLARE @NewLicType  		INT = 2
DECLARE @licServerEvalToTal	INT = 0
DECLARE @licServerEvalUsed	INT = 0
DECLARE @licServerEvalIsEval	INT = 0
DECLARE @licServerEvalDays	INT = 0
DECLARE @licServerPermToTal	INT = 0
DECLARE @licServerPermUsed	INT = 0
DECLARE @licServerPermIsEval	INT = 0
DECLARE @licServerPermEvalDays	INT = 0
DECLARE @licLaptopEvalToTal	INT = 0
DECLARE @licLaptopEvalUsed	INT = 0
DECLARE @licLaptopEvalIsEval	INT = 0
DECLARE @licLaptopEvalDays	INT = 0
DECLARE @licLaptopPermToTal	INT = 0
DECLARE @licLaptopPermUsed	INT = 0
DECLARE @licLaptopPermIsEval	INT = 0
DECLARE @licLaptopPermEvalDays	INT = 0
DECLARE @licServerPermFld	VARCHAR(64)=''
DECLARE @licServerEvalFld	VARCHAR(64)=''
DECLARE @licLaptopPermFld	VARCHAR(64)=''
DECLARE @licLaptopEvalFld	VARCHAR(64)=''
DECLARE @numOfMACClients	INT = (SELECT COUNT(*) FROM LicUsage WHERE AppType = @MACAppType AND LicType = @oldlicType)
DECLARE @PermMACUsed		INT = 0 --(SELECT COUNT(*) FROM LicUsage WHERE AppType = @MACAppType AND LicType = @oldlicType AND OpType = 'Install' and Eval = 0 and (GETUTCDATE() < ExpiryDateUTC or dbo.GetUnixTime(ExpiryDateUTC) = 0))
DECLARE @EvalMACUsed		INT = 0 --(SELECT COUNT(*) FROM LicUsage WHERE AppType = @MACAppType AND LicType = @oldlicType AND OpType = 'Install' and Eval = 1 and GETUTCDATE() < ExpiryDateUTC)
DECLARE @currentTime		INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @isCursorOpened		INT = 0
DECLARE @CommcellID		INT = 2
DECLARE @strDash		VARCHAR(10) =':-'
DECLARE @str0       		VARCHAR(32) = '0'
DECLARE @licUsageId		INT
DECLARE @clName     		VARCHAR(256)
DECLARE @clId     		INT
DECLARE @opType			VARCHAR(256)
DECLARE @opTime     		DATETIME
DECLARE @expDateTime   		DATETIME
DECLARE @bEval     		INT
DECLARE @expDate    		INT
DECLARE @clRelId    		INT
DECLARE @clOSId     		INT
DECLARE @buildStr   		VARCHAR(256)
DECLARE @LicUsageData		VARCHAR(2048)
DECLARE @newlicEncFld		VARCHAR(2048)
DECLARE @bConsumeLic    	INT
DECLARE @newQuantity    	INT

--****************************************************************************************************************************
-- Check whether there are any MAC clients need to convert.
--****************************************************************************************************************************
IF @numOfMACClients = 0
	RETURN

--****************************************************************************************************************************
-- Check LICAAL table to get license quantities.
--****************************************************************************************************************************
SELECT @licServerEvalFld = RTRIM(eval_fld1), @licServerPermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @oldlicType AND commcellId = @CommcellID
IF LEN(@licServerPermFld) > 0
	EXEC dbo.xp_getAALInfo2 @licServerPermFld, @licServerPermToTal OUTPUT, @licServerPermUsed OUTPUT, @licServerPermIsEval OUTPUT, @licServerPermEvalDays OUTPUT
IF LEN(@licServerEvalFld) > 0
	EXEC dbo.xp_getAALInfo2 @licServerEvalFld, @licServerEvalToTal OUTPUT, @licServerEvalUsed OUTPUT, @licServerEvalIsEval OUTPUT, @licServerEvalDays OUTPUT
SET @nErrCode =   @@ERROR 
IF  @nErrCode != 0 GOTO CX_EXIT

SELECT @licLaptopEvalFld = RTRIM(eval_fld1), @licLaptopPermFld = RTRIM(perm_fld1) FROM LicAAL WHERE simLicAppTypeId = @NewLicType AND commcellId = @CommcellID
IF LEN(@licLaptopPermFld) > 0
	EXEC dbo.xp_getAALInfo2 @licLaptopPermFld, @licLaptopPermToTal OUTPUT, @licLaptopPermUsed OUTPUT, @licLaptopPermIsEval OUTPUT, @licLaptopPermEvalDays OUTPUT
IF LEN(@licLaptopEvalFld) > 0
	EXEC dbo.xp_getAALInfo2 @licLaptopEvalFld, @licLaptopEvalToTal OUTPUT, @licLaptopEvalUsed OUTPUT, @licLaptopEvalIsEval OUTPUT, @licLaptopEvalDays OUTPUT
SET @nErrCode =   @@ERROR 
IF  @nErrCode != 0 GOTO CX_EXIT

BEGIN TRY
BEGIN TRAN

--****************************************************************************************************************************
-- Update LICUSAGE table
--****************************************************************************************************************************
DECLARE MACCLientCursor CURSOR FOR SELECT id,Name,Cid,opType,opTimeutc,Eval,ExpiryDateUTC,ReleaseId,SimOSID,Build FROM LicUsage WHERE AppType = @MACAppType AND LicType = @oldlicType ORDER BY eval
OPEN MACCLientCursor
SET @isCursorOpened = 1
FETCH MACCLientCursor INTO @licUsageId, @clName, @clId, @opType, @opTime, @bEval, @expDateTime, @clRelId, @clOSId, @buildStr

WHILE @@FETCH_STATUS = 0
BEGIN
    SET @bConsumeLic = 0
    SET @expDate = dbo.GetUnixTime(@expDateTime)

    IF @opType = 'Install'
    BEGIN
	IF @bEval = 0 AND (@expDate = 0 OR @currentTime < @expDate) OR @bEval = 1 AND @currentTime < @expDate
	BEGIN
		SET @bConsumeLic = 1

		IF @bEval = 0 AND @licLaptopPermToTal >= 0 AND @PermMACUsed >= (@licLaptopPermToTal - @licLaptopPermUsed)
		BEGIN
			IF  @licLaptopEvalToTal < 0 OR @EvalMACUsed < (@licLaptopEvalToTal - @licLaptopEvalUsed)
			BEGIN
				SET @bEval = 1
				SET @expDate = @licLaptopEvalDays
			END
			ELSE
				SET @bConsumeLic = 0
		END

		IF @bEval > 0 AND @licLaptopEvalToTal >= 0 AND @EvalMACUsed >= (@licLaptopEvalToTal - @licLaptopEvalUsed)
		BEGIN
			IF  @licLaptopPermToTal < 0 OR @PermMACUsed < (@licLaptopPermToTal - @licLaptopPermUsed)
			BEGIN
				SET @bEval = 0
				SET @expDate = @licLaptopPermEvalDays
			END
			ELSE
				SET @bConsumeLic = 0 
		END
	END

	IF @bConsumeLic = 0
		SET @opType = 'UnInstall'
    END

    SET @LicUsageData = @clName + @strDash + CAST(@clId AS VARCHAR(64)) + @strDash + CAST(@NewLicType AS VARCHAR(64)) + @strDash + 
                    CAST(@MACAppType AS VARCHAR(64)) + @strDash + RTRIM(@opType) + @strDash + CAST(dbo.GetUnixTime(@opTime) AS VARCHAR(64)) + @strDash +
                    @str0 + @strDash + CAST(@bEval AS VARCHAR(64)) + @strDash + CAST(@expDate AS VARCHAR(64)) + @strDash + CAST(@clRelId AS VARCHAR(64)) + @strDash + 
                    CAST(@clOSId AS VARCHAR(64)) + @strDash + @buildStr + @strDash + @str0 

    EXEC pswEncryptionManaged @LicUsageData, @newlicEncFld OUTPUT
    IF @newlicEncFld IS NOT NULL AND LEN(@newlicEncFld) > 0
    BEGIN
	UPDATE LicUsage SET LicType = @NewLicType, opType = @opType, Eval = @bEval, ExpiryDateUTC = dbo.getDateTime(@expDate), EncryptedField = @newlicEncFld WHERE id = @licUsageId

	IF @opType = 'Install' 
	BEGIN
		IF @bEval > 0
			SET @EvalMACUsed = @EvalMACUsed + 1
		ELSE
			SET @PermMACUsed = @PermMACUsed + 1
	END
    END

    SET @nErrCode =   @@ERROR 
    IF  @nErrCode != 0 GOTO CX_EXIT    
    FETCH MACCLientCursor INTO @licUsageId, @clName, @clId, @opType, @opTime, @bEval, @expDateTime, @clRelId, @clOSId, @buildStr
END

--****************************************************************************************************************************
-- Update LICAAL table
--****************************************************************************************************************************
IF LEN(@licLaptopPermFld) > 0
BEGIN
	SET @newQuantity = @licLaptopPermUsed + @PermMACUsed
	EXEC dbo.xp_buildAALFld @NewLicType, @licLaptopPermToTal, @newQuantity, @licLaptopPermEvalDays, @licLaptopPermIsEval, @newlicEncFld OUTPUT
	UPDATE LicAAL SET perm_fld1 = @newlicEncFld WHERE simLicAppTypeId = @NewLicType AND commcellId = @CommcellID
END

IF LEN(@licLaptopEvalFld) > 0
BEGIN
	SET @newQuantity = @licLaptopEvalUsed + @EvalMACUsed
	EXEC dbo.xp_buildAALFld @NewLicType, @licLaptopEvalToTal, @newQuantity, @licLaptopEvalDays, @licLaptopEvalIsEval, @newlicEncFld OUTPUT
	UPDATE LicAAL SET eval_fld1 = @newlicEncFld WHERE simLicAppTypeId = @NewLicType AND commcellId = @CommcellID
END

IF LEN(@licServerPermFld) > 0
BEGIN
	SET @newQuantity = CASE WHEN @licServerPermUsed > @PermMACUsed THEN @licServerPermUsed - @PermMACUsed ELSE 0 END	
	EXEC dbo.xp_buildAALFld @OldLicType, @licServerPermToTal, @newQuantity, @licServerPermEvalDays, @licServerPermIsEval, @newlicEncFld OUTPUT
	UPDATE LicAAL SET perm_fld1 = @newlicEncFld WHERE simLicAppTypeId = @oldLicType AND commcellId = @CommcellID
END

IF LEN(@licServerEvalFld) > 0
BEGIN
	SET @newQuantity = CASE WHEN @licServerEvalUsed > @EvalMACUsed THEN @licServerEvalUsed - @EvalMACUsed ELSE 0 END	
	EXEC dbo.xp_buildAALFld @OldLicType, @licServerEvalToTal, @newQuantity, @licServerEvalDays, @licServerEvalIsEval, @newlicEncFld OUTPUT
	UPDATE LicAAL SET eval_fld1 = @newlicEncFld WHERE simLicAppTypeId = @oldLicType AND commcellId = @CommcellID
END

SET @nErrCode =   @@ERROR 
IF  @nErrCode != 0 GOTO CX_EXIT

COMMIT TRAN
END TRY

BEGIN CATCH
    SET @nErrCode = ERROR_NUMBER()
    SET @sErrStr = 'Failed to execute script. ERROR_NUMBER: '+ cast(@nErrCode as varchar(10)) + ' ERROR_MESSAGE: '+ERROR_MESSAGE()               
END CATCH

CX_EXIT: 
IF @isCursorOpened > 0
BEGIN
	CLOSE MACCLientCursor
	DEALLOCATE MACCLientCursor
END

IF @nErrCode > 0
BEGIN
	ROLLBACK TRAN
	RAISERROR (@sErrStr, 16, 1)
END
