----------ADD TPPM configurations for index sever with content analyzer----------------
SET QUOTED_IDENTIFIER ON
DECLARE @ContentAnalyzerTPPMUpgrade INT = 0
DECLARE @ContentAnalyzerVersion varchar(36) = '7C23CDBC-5653-45FB-85BA-09E5D8F96BBD'
SELECT @ContentAnalyzerTPPMUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)
WHERE GS.SqlScriptGUID = @ContentAnalyzerVersion

-- update the tppm configurations for the existing IS and CA 



IF (@ContentAnalyzerTPPMUpgrade = 0)            -- not done, do the db upgrade
BEGIN   	
	
	-- Need to update the cacloudid from the data source property based on the catargetURL 
	DECLARE @planIds TABLE (planId INT PRIMARY KEY)
	DECLARE @datasourceIDs TABLE (dsId INT PRIMARY KEY)
	DECLARE @planDetails TABLE (planId INT PRIMARY KEY,ISCloudID INT, CACloudIID INT)
	DECLARE @caPropertyID INT = 0 
	DECLARE @planPropertyID INT = 0 
	DECLARE @caURLPropertyID INT = 0 
	DECLARE @planId INT = 0 
	DECLARE @dsId INT = 0 

	SELECT @caPropertyID = PropertyId from SEProperty (NOLOCK) where PropertyName = 'cacloudid'
	SELECT @caURLPropertyID = PropertyId from SEProperty (NOLOCK) where PropertyName = 'catargeturl'
	SELECT @planPropertyID = PropertyId from SEProperty (NOLOCK) where PropertyName = 'dcplanid'
	
	MERGE INTO SEDataSourceProperty SP
	USING (
		SELECT *
		FROM SEDataSourceProperty SDP (NOLOCK)
		WHERE SDP.PropertyId = @caURLPropertyID AND  COALESCE(SDP.PropertyValue,'') <> ''
	) SD
	ON SP.DataSourceId = SD.DataSourceId AND SP.PropertyId  = @caPropertyID
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (DataSourceId,PropertyId,PropertyValue)
	VALUES(SD.DataSourceId,@caPropertyID,COALESCE((select CloudId from DM2SearchServerCoreInfo DM (NOLOCK)
	JOIN app_client AC (NOLOCK)
	ON DM.clientid = AC.id
	JOIN APP_ClientProp AP
	ON AP.componentNameId = AC.id 
	where AC.net_hostname = DBO.getHostnameFromUrl(SD.PropertyValue) AND DM.CloudType = 2
	AND  AP.attrName = 'contentPreviewPort' and SD.PropertyValue LIKE '%' + AP.attrVal
	),''));
	
	-- Need to update the TPPM configuaration for each plan.
	INSERT INTO @planDetails( planId,ISCloudID,CACloudIID)
	select MIN(AP1.componentNameId),DC.cloudId ,AP2.attrVal from App_PlanProp AP1 (NOLOCK)
	JOIN App_PlanProp AP2 (NOLOCK) 
	ON AP2.componentNameId = AP1.componentNameId
	JOIN DM2Cloud DC ON
	DC.pseudoClientId = AP1.attrVal
	where AP1.attrName ='Analytics Index Server Id' AND AP2.attrName ='Content Analyzer Cloud Id'
	GROUP BY DC.cloudId,AP2.attrVal
	
	INSERT INTO @planIds
	select DISTINCT planid From @planDetails

	
	WHILE EXISTS(SELECT TOP 1 planId FROM @planIds) 
	BEGIN 
	SELECT @planId = (SELECT TOP 1 planId FROM @planIds) 
		EXEC CreateTPPMForISToCA @i_dcPlanID=@planId, @i_datasourceId=@dsId
		DELETE TOP (1) FROM @planIds WHERE planId = @planId 
	END	
	
	-- Need to update the TPPM configuration for each data source which is having the cacloudid populated	
	
	-- Get data sources where CA is configured and no plan is associated
	;WITH DSWITHOUTPLAN AS 
	(
		select DISTINCT CAP.datasourceid,SEC.CloudID AS ISCloudID, CAP.PropertyValue AS CACloudID 
		FROM SEDataSourceProperty CAP (NOLOCK)
		JOIN SEDataSource SD (NOLOCK) ON 
		SD.DataSourceId = CAP.DataSourceId
		JOIN SECollectionInfo SEC (NOLOCK) ON 
		SEC.CoreId = SD.CoreId
		WHERE CAP.PropertyId  = @caPropertyID 
		AND CAP.datasourceid  NOT IN(
			SELECT DCP.datasourceid FROM SEDataSourceProperty DCP (NOLOCK)
			WHERE DCP.PropertyId  = @planPropertyID
			)
	)
	
	-- get only data source ids where the configuration is not matching with any plan 
	INSERT INTO @datasourceIDs
	SELECT MIN(DP.DataSourceId)FROM DSWITHOUTPLAN DP
	LEFT OUTER JOIN @planDetails PD ON 
	(PD.CACloudIID = DP.CACloudID AND PD.ISCloudID = DP.ISCloudID)
	WHERE PD.planId IS NULL
	GROUP BY DP.CACloudID,DP.ISCloudID

	SET @planId = 0 
	WHILE EXISTS(SELECT TOP 1 dsId FROM @datasourceIDs) 
	BEGIN 
		SELECT @dsId = (SELECT TOP 1 dsId FROM @datasourceIDs) 
		EXEC CreateTPPMForISToCA @i_dcPlanID=@planId, @i_datasourceId=@dsId
		DELETE TOP (1) FROM @datasourceIDs WHERE dsId = @dsId 
	END	

	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@ContentAnalyzerVersion, 'ContentAnalyzerTPPMUpgrade', 'Upgrade TPPM settings for Content Analyzer', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

