

--======================================================================================
-- Post Upgrade script setups SQL Change Tracking on the CommServ Database for
-- Cache Tables that are created on Entity Property Tables to improve performance
-- for getting a entity properties on one row instead of many with PIVOT operations.
--======================================================================================

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcxtools/DatabaseUpgrade/CommServer/PostUpgrade/CTCacheTableLoading.sql,v $ $Id: CTCacheTableLoading.sql,v 1.1.2.1 2018/04/11 13:17:35 chandru Exp $";


SET QUOTED_IDENTIFIER ON
GO

BEGIN

	SET NOCOUNT ON

	DECLARE @sqlCmd			NVARCHAR(MAX)
	DECLARE @exitCode		INT = 0
	DECLARE @exitMsg		VARCHAR(1024) = ''
	DECLARE @msg			VARCHAR(MAX) = ''
	DECLARE @tcMsg			VARCHAR(1024) = ''

	-- Start TRY Block for configuration Change Tracking
	BEGIN TRY
		-- Database Change Tracking is enabled, now check Change Tracking needed on required Tables
		DECLARE @TableChangeTracking TABLE (
			tblName			SYSNAME PRIMARY KEY,
			colEnabled		INT,
			minVersion		BIGINT,
			beginVersion	BIGINT,
			cleanVersion	BIGINT
		)

		-- Get list of Tables Change Tracking is enabled ON
		INSERT INTO @TableChangeTracking
			SELECT 
				so.name,
				ctt.is_track_columns_updated_on,
				ctt.min_valid_version,
				ctt.begin_version,
				ctt.cleanup_version
			FROM sys.change_tracking_tables ctt WITH(NOLOCK)
				INNER JOIN sys.objects AS so WITH(NOLOCK) ON
					ctt.object_id = so.object_id

		-- Is Change Tracking Enabled on Tables?
		DECLARE @CTEnabled_ClientProp	TINYINT = 0

		-- Now check individual tables that require change Tracking
		SELECT
			@CTEnabled_ClientProp = 1 
		FROM @TableChangeTracking
		WHERE
			tblName = 'APP_ClientProp'		-- needed for CT_ClientProperties Table syncing

		IF (@CTEnabled_ClientProp = 0)
		BEGIN
			SET @tcMsg = 'Failure to enable SQL Server Change Tracking on APP_ClientProp Table.'

			-- Enable Change Tracking on APP_ClientProp Tables
			ALTER TABLE APP_ClientProp ENABLE CHANGE_TRACKING WITH (TRACK_COLUMNS_UPDATED = OFF)

			SET @msg = 'SQL Server Change Tracking enabled for APP_ClientProp Table.'
			PRINT @msg
		END

		-- Load Change Tracking Tables
		DECLARE @reloadTbl	INT = 1
		DECLARE @startUp	INT = 0
		DECLARE @noResults	INT = 0

		IF (@CTEnabled_ClientProp = 1)
		BEGIN
			SET @tcMsg = 'Failure to load CT_ClientProperties Table.'

			-- Reload the CT_ClientProperties Cache Table
			EXEC CTClientPropertiesLoading @reloadTbl, @startUp, @exitCode OUTPUT, @exitMsg OUTPUT, @noResults

			SET @msg = 'CT_ClientProperties Table loaded.'
			PRINT @msg
		END

	END TRY
	BEGIN CATCH
		PRINT  'CHANGE TRACKING CACHE TABLE POPULATION: INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (@tcMsg <> '')
		BEGIN
			PRINT @tcMsg
		END
		RAISERROR(@tcMsg, 16, 1)
	END CATCH

END

GO

