
--======================================================================================================
-- This Script enables the CSProactiveDBMaintainanceJob SQL Agent Job while DbUpgrade is executing
--======================================================================================================
SET QUOTED_IDENTIFIER ON
GO

SET NOCOUNT ON

DECLARE @script VARCHAR(128) = 'Script: Enabling CSProactiveDBMaintainanceJob SQL Agent Job - '
DECLARE @jobName NVARCHAR(128) = N'CSProactiveDBMaintainanceJob'


DECLARE @jobId UNIQUEIDENTIFIER
DECLARE @enabled TINYINT
DECLARE @opName VARCHAR(100) = '?'
Declare @rc INT = 0

SELECT
	@jobId = job_id,
	@enabled = enabled
FROM msdb.dbo.sysjobs WITH(NOLOCK)
WHERE
	name = @jobName

PRINT @script + ' Starting for JobId [' + ISNULL(CAST(@jobId AS VARCHAR(60)), 'NULL') + ']'

IF @jobId IS NULL
BEGIN
	--PRINT @script + 'SQL Agent JobName [' + @jobName + '] not configured'
	SET @opName = 'NOT Configured'
	GOTO PROC_END
END

-- Check that PreUpgrade disabled the SQL Agent Job - Customer may have disabled on purpose so do NOT re-enabled
DECLARE @gxpId INT = 0
DECLARE @gxpVal INT = 0
SELECT
	@gxpId = id,
	@gxpVal = value
FROM GXGlobalParam WITH(NOLOCK)
WHERE
	name = @jobName + '_DbUpgrade'
	AND modified = 0

IF @gxpId = 0 OR @gxpId IS NULL
BEGIN
	-- PreUpgrade did not disable it - disabled by customer
	--PRINT @script + 'PreUpgrade check Customer has disabled JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + ']'
	SET @opName = 'Disabled'
	IF @jobId IS NOT NULL
		AND @enabled = 1
	BEGIN
		-- Disable it
		--PRINT @script + 'Disabling JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + '] for Customer choice'
		SET @opName = 'Disabled Enforced'
		
		EXEC @rc = msdb..sp_update_job @job_id = @jobId, @enabled = 0
	END
END ELSE IF @enabled = 0
BEGIN
	--PRINT @script + 'Enabling JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + ']'
	SET @opName = 'Re-enabled'
	
	EXEC @rc = msdb..sp_update_job @job_id = @jobId, @enabled = 1
END ELSE IF @enabled = 1
BEGIN
	SET @opName = 'Enabled'
END

IF @gxpVal > 0
BEGIN
	DELETE FROM GXGlobalParam WHERE id = @gxpId
END

PROC_END:
	PRINT @script + ' Completed [' + @opName + '] jobCode [' + CAST(@rc AS VARCHAR(12)) + ']'
