SET QUOTED_IDENTIFIER ON

DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

DECLARE @nowTime integer = dbo.getUnixtime(GetUTCDate())


BEGIN TRY
		BEGIN TRAN	
		
			INSERT INTO APP_CLIENTPROP
			SELECT T2.id,'Operating System Name',1,T3.osName,@nowTime,0,0
			FROM APP_CLIENT T2 
			JOIN ClientOSNameView T3 ON T3.clientId = T2.id
			LEFT OUTER JOIN 
			(
				SELECT distinct CP.componentNameId 
				FROM APP_CLIENTPROP CP WITH (NOLOCK) 				
				WHERE ATTRNAME = 'Operating System Name'				
			) P
			ON T2.id = P.componentNameId
			WHERE P.componentNameId is null
			
			
			INSERT INTO APP_CLIENTPROP
			SELECT T2.id,'Hardware Info',1,T2.cHwName,@nowTime,0,0	
			FROM		
			(
					SELECT
						q.clientId as id,
						CASE
							WHEN q.hwPos IS NOT NULL AND q.hwPos > 0 THEN SUBSTRING(q.osInfo, q.osInfoLen - q.hwPos + 1, hwPos + 1)
							ELSE
								CASE
									WHEN q.osName = N'DATA ONTAP' THEN N'Network Appliance'
									WHEN q.osName = N'Celerra' THEN N'EMC Celerra'
									ELSE q.osName
								END
						END as cHwName
						FROM 
						(
							SELECT
								c.id clientId,
								os.name osName,
								cp.attrVal osInfo,
								LEN(cp.attrVal) osInfoLen,
								(CHARINDEX('-:', REVERSE(cp.attrVal))-1) hwPos
								FROM APP_Client c
								LEFT OUTER JOIN simOperatingSystem os ON
									os.id = c.simOperatingSystemId							
								INNER JOIN APP_ClientProp cp ON		
									cp.componentNameId = c.id
									AND cp.attrname = N'Sim OS Info'
									AND cp.modified = 0
							WHERE
								c.id > 1
						) q 
			)	
			T2 			 
			 LEFT OUTER JOIN 
			(
				SELECT distinct CP.componentNameId 
				FROM APP_CLIENTPROP CP WITH (NOLOCK) 		
				WHERE ATTRNAME = 'Hardware Info'				
			) P
			ON  T2.id = P.componentNameId
			WHERE P.componentNameId is null	

END TRY
BEGIN CATCH
--CATCH_HANDLING_MACRO
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
	IF @errorCode = 0
		COMMIT TRAN
	ELSE 
		ROLLBACK TRAN
ERROR_EXIT:
SELECT @errorCode, @errorString
