IF NOT EXISTS (SELECT * from app_clientgroup where name = 'Content Analyzer Cloud')
BEGIN
	DECLARE @ownerId INT
	DECLARE @analyzerServerGrpId INT
	DECLARE @errorCode int
	DECLARE @errorString VARCHAR(1024)
	SET @ownerId = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
	DECLARE @EdgeClientsQuery nvarchar (max) 
	DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))

	insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
	values('Content Analyzer Cloud', 'Select Clients which have content extractor configured', 4096, 0, @ownerId, 0, '0', '', 2)		
	SET @analyzerServerGrpId = (select id from app_clientgroup where name ='Content Analyzer Cloud')
	
	-- create smart client group for ANALYZER Servers
	--SCG_PKID_ANALYZER_SERVERS_CLIENT  = 54
	DECLARE @analyzerServerXML NVARCHAR(MAX) = '<scgRule op="0"><rules><rule op="0"><rules> <rule filterID="1" propID="54" propType="1" /> </rules> </rule></rules></scgRule>'
	DECLARE @scgExitCode INT = 0
	DECLARE @scgExitMsg VARCHAR(1024) = ''
        
	EXEC APPSCGV2GenerateQueryParams @analyzerServerXML, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @EdgeClientsQuery OUTPUT

	IF (@scgExitCode = 0)
	BEGIN
		insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
		values(@analyzerServerGrpId, 
			@analyzerServerXML,
			@EdgeClientsQuery,
			1, 0, '0')

		
		
		--Set the creator with either Master role (that has all capabilities) or with System owner capabilities role (present against entityType(1) and entityID(2) in UMOwnerRoles table)
		DECLARE @edgeDriveCreatorRoleId INT
		DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
		SET @edgeDriveCreatorRoleId = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityID = 2),
												(SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)))
		EXEC sec_setCreatorForEntity @creatorUserId = 0, 
									@creatorRoleId = @edgeDriveCreatorRoleId, 
									@creatorPermissions = '', 
									@errorCode = @errorCode OUTPUT, 
									@errorString = @errorString OUTPUT, 
									@entityTYpe1 = 28,			/*CLIENT_GROUP_ENTITY*/
									@entityId1 = @analyzerServerGrpId,
									@creatorUserGroupId = @masterUserGroupId,
									@loggedInUserID = @ownerID

		DECLARE @createAsUserId INT 
		EXEC sec_getCreateAsUserId 28/*CLIENT_GROUP_ENTITY*/, 
								@analyzerServerGrpId, 
								@createAsUserId OUTPUT
		UPDATE App_ClientGroup
		SET userId = @createAsUserId
		WHERE id = @analyzerServerGrpId
		
	END
END
