----------CREATE PSEUDO CLIENTS FOR EACH SUCH CLIENTS----------------
SET QUOTED_IDENTIFIER ON
DECLARE @analyticsServerUpgrade INT = 0
DECLARE @analyticsServerVersion varchar(36) = 'BF69DCDC-909A-4E6F-8DCD-528BA93CE856'
SELECT @analyticsServerUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)
WHERE GS.SqlScriptGUID = @analyticsServerVersion

IF (@analyticsServerUpgrade = 0)            -- not done, do the db upgrade
BEGIN   	

	--DECLARATION
	DECLARE @curTime INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @analyticsClients TABLE (t_clientId INT PRIMARY KEY, t_clientName NVARCHAR(255), t_hostName NVARCHAR(255) ,t_pseudoClientId INT DEFAULT 0, t_pseudoClientName NVARCHAR(255))
	DECLARE @outAnalyticsClients TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_clientId INT, t_clientName NVARCHAR(255))	
	DECLARE @outInstance TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_instanceId INT)	
	DECLARE @outBackupSet TABLE (t_Id INT IDENTITY(1,1) PRIMARY KEY, t_backupSetId INT)	
	DECLARE @outAppId TABLE (t_appId INT PRIMARY KEY)
	DECLARE @attributeTbl TABLE (t_attrName NVARCHAR(64), t_entityType int, t_value NVARCHAR(64), t_attrType INT)	
	IF object_id('tempdb.dbo.#clientTbl') IS NOT null DROP TABLE #clientTbl  CREATE TABLE #clientTbl(clientId INT PRIMARY KEY)

	--GET ALL CLIENTS WITH DISTRIBUTED IDA
	INSERT INTO #clientTbl (clientId)
	SELECT DISTINCT clientId FROM APP_Application (NOLOCK) WHERE appTypeId =64

	--PROPERTIES
	INSERT INTO @attributeTbl (t_attrName, t_entityType, t_value,  t_attrType)
	VALUES (N'Distributed iDA Client' , 1, N'1' , 2), ('Index Server Type', 1, N'15', 7), ('Index Server ClientId', 1 ,N'0',7), ('IndexingV2',1,N'1',2), ('SP Version Info', 1 ,N'11' ,1), ('Exclude from SLA', 1,N'1',2),
	('Distributed Cluster Type', 2, N'6', 7), ('Solr Index Client Id', 2 ,N'0' ,10)
	
	--GET ALL CLIENTS WHERE ANALYTICS ENGINE IS CONFIGURED		
	INSERT INTO @analyticsClients (t_clientId, t_clientName, t_hostName, t_pseudoClientName)
	SELECT DISTINCT componentNameId, C.name , C.net_hostname,  C.name + '_AnalyticsServer'
	FROM APP_ClientProp CP (NOLOCK)
	INNER JOIN APP_Client C  (NOLOCK)  ON CP.componentNameId = C.id
	INNER JOIN DM2SearchServerCoreInfo S (NOLOCK)  ON C.id =S.ClientId
	INNER JOIN DM2CloudCoreRole CR  (NOLOCK)  ON CR.CloudId = S.CloudId
	INNER JOIN DM2Cloud DC  (NOLOCK)  ON DC.CloudId = S.CloudId
	WHERE attrName = 'AnalyticSearchEngineEnabled' AND attrVal ='1' AND cp.modified = 0	AND DC.pseudoclientid=0
	
	IF NOT EXISTS ( SELECT 1 FROM @analyticsClients)
		GOTO PROC_EXIT

	--GET SMART CLIENT GROUPID FOR ANALYTICS 
	DECLARE @idxServerCGId INT  = ISNULL((SELECT id FROM APP_ClientGroup (NOLOCK) WHERE NAME = 'Index Servers'),0)

	IF @idxServerCGId = 0
	BEGIN
		EXEC AppSmartClientGroupForCloud 6
		SET @idxServerCGId = ISNULL((SELECT id FROM APP_ClientGroup (NOLOCK) WHERE NAME = 'Index Servers'),0)
	END
	
	
	--CLIENT
	INSERT INTO APP_Client (name, simOperatingSystemId, net_hostname, refTime, client_password, releaseId,origCCId,GUID,specialClientFlags,displayName, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, spaceCheckFlags)       
	OUTPUT INSERTED.id, inserted.name
	INTO @outAnalyticsClients
	SELECT  t_pseudoClientName,	0, t_pseudoClientName , @curTime,	'3cfe3eeb854e8aa64e0155bec019674d5',	16,	2	, NEWID() , 2, t_pseudoClientName, @curTime, 0, 0, N'', N'',  N'', 0, 0, 0, 0, 0
	FROM @analyticsClients
	WHERE t_pseudoClientName NOT IN (SELECT name FROM APP_Client (NOLOCK) WHERE (specialClientFlags & 0X2) >0 )

	--MAP PSEUDO CLIENTID TO INDEX SERVER CLIENT 
	UPDATE @analyticsClients
	SET t_pseudoClientId = C.id
	FROM APP_Client C
	WHERE C.name = t_pseudoClientName

	--update pseudoClientId into dm2cloud table
	UPDATE DM2Cloud
	SET pseudoClientId = ISNULL(C.t_pseudoClientId,0)
	FROM DM2SearchServerCoreInfo S (NOLOCK) 
	JOIN @analyticsClients C ON S.ClientId = C.t_clientId
	WHERE DM2Cloud.cloudType = 1 AND pseudoClientId = 0 AND  S.CloudId = DM2Cloud.cloudId

	--CLIENTPROP
	INSERT INTO APP_ClientProp (componentNameId,attrName,attrType, attrVal,created, modified)
	SELECT t_pseudoClientId,	t_attrName,	t_attrType,	(CASE WHEN  t_attrName = 'Index Server ClientId' THEN A.t_clientId ELSE T.t_value END) ,	@curTime,0
	FROM @analyticsClients A
		CROSS JOIN @attributeTbl T
	WHERE T.t_entityType = 1 AND
	NOT EXISTS (SELECT 1 FROM APP_ClientProp (NOLOCK) WHERE componentNameId = A.t_pseudoClientId AND attrName = T.t_attrName)
	
	--INSTANCE
	INSERT INTO APP_InstanceName (name, status, origCCId,GUID, refTime, modified)
	OUTPUT inserted.id
	INTO @outInstance
	SELECT 'dynamicIndexInstance',	0,	2, NEWID(), @curTime, @curTime
	FROM @outAnalyticsClients A		
	WHERE A.t_clientId NOT IN (SELECT clientId FROM #clientTbl)

	--INSTANCEPROP
	INSERT INTO APP_InstanceProp (componentNameId,attrName, attrType, attrVal,created, modified)					
	select I.t_instanceId, T.t_attrName, t_attrType,	 (CASE WHEN  t_attrName = 'Solr Index Client Id' THEN C.t_clientId ELSE T.t_value END) ,	@curTime,0
	FROM @outInstance I
	CROSS JOIN @attributeTbl T
	JOIN @outAnalyticsClients A	ON I.t_Id = A.t_id	
	JOIN @analyticsClients C ON A.t_clientId = C.t_pseudoClientId
	WHERE T.t_entityType = 2 AND
	NOT EXISTS (SELECT 1 FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = I.t_instanceId AND attrName = T.t_attrName)

	--BACKUPSET
	INSERT INTO APP_BackupSetName (name, status, origCCId,GUID, refTime, modified)
	OUTPUT inserted.id
	INTO @outBackupSet
	SELECT 'defaultBackupSet',	0,	2, NEWID(), @curTime, @curTime
	FROM @outAnalyticsClients A
	WHERE A.t_clientId NOT IN (SELECT clientId FROM #clientTbl)
	
	--IDA	
	INSERT INTO APP_IDAName (clientId, appTypeId, status, refTime, modified)
	SELECT t_clientId,	64,	0, 0 , @curTime
	FROM @outAnalyticsClients C
	WHERE C.t_clientId NOT IN (SELECT clientId FROM APP_IDAName(NOLOCK)  WHERE appTypeId =64)

	--SUBCLIENT	
	INSERT INTO APP_Application (clientId,appTypeId,instance,backupSet,subclientName,subclientStatus,origCCId,GUID,appNumber, dataArchGrpID,logArchGrpID, refTime, modified)
	OUTPUT INSERTED.id
	INTO @outAppId
	SELECT  C.t_clientId, 64, I.t_instanceId,	B.t_backupsetId, 'default',	8	,2,	NEWID(), 0,1,1, @curTime,@curTime	
	FROM @outAnalyticsClients C 
	JOIN @outInstance I ON C.t_Id = I.t_Id
	JOIN @outBackupSet B ON C.t_Id =B.t_Id 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM #clientTbl)

	--CONTENTS		
	INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified)
	SELECT DISTINCT  p.t_appId,  1, '\%'+ RM.roleTypeName +'%', @curTime, 0
	FROM @outAppId P
	JOIN APP_Application APP (NOLOCK) ON P.t_appId = APP.id
	JOIN DM2Cloud S (NOLOCK) ON  S.pseudoClientId = APP.clientId
	JOIN DM2CloudCoreRole CR (NOLOCK) ON CR.CloudId =S.CloudId
	JOIN DM2CloudRoleMaster RM (NOLOCK) ON CR.roleId =RM.roleType
	WHERE NOT EXISTS  (SELECT 1 FROM APP_ScFilterFile (NOLOCK) WHERE componentNameId = P.t_appId AND fileName = '\%'+ RM.roleTypeName +'%')

	--ACCESS NODES						
	INSERT INTO APP_SubClientProp (componentNameId,attrName, attrType, attrVal,created, modified)
	SELECT P.t_AppId , 'Solr Index Client Id',	10,	N'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_DataAccessNodes><dataAccessNodes _type_="3" clientId="'+ CAST (C.t_clientId AS nvarchar(20))  +'" clientName="' + C.t_clientName+'" hostName="'+ C.t_hostName+'"/></App_DataAccessNodes>', @curTime, 0
	FROM @outAppId P
	JOIN APP_Application APP (NOLOCK) ON P.t_appId = APP.id
	JOIN @analyticsClients C ON APP.clientId = C.t_pseudoClientId
	WHERE P.t_appId NOT IN (SELECT componentNameId FROM APP_SubClientProp (NOLOCK) WHERE attrName = 'Solr Index Client Id')
	
	--PLATFORM
	INSERT INTO APP_Platform (clientId, platformType, install_dir, refTime)
	SELECT C.t_clientId,	4,	'N/A',	0
	FROM @outAnalyticsClients C 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM APP_Platform (NOLOCK) WHERE platformType =4 )

	--APP_ClientGroupAssoc	
	INSERT INTO APP_ClientGroupAssoc (clientGroupId, clientId)
	SELECT @idxServerCGId, C.t_clientId
	FROM @outAnalyticsClients C 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientGroupId = @idxServerCGId )
	
	--Disable backup activity for existing psuedo clients	
	UPDATE JMJobAction
	SET action = 1
	FROM @analyticsClients C 
	WHERE ClientId = C.t_pseudoClientId AND Optype = 4 AND apptype =0 AND action = 2

	DECLARE @drSubclientId INT = ISNULL((select TOP 1 id from APP_Application (NOLOCK) WHERE appTypeId = 1000),0)
	--JOB ACTIVITY
	INSERT INTO JMJobAction (clientId, mediaAgentId, appType, opType, action, appId, clientGroupId, enableTimeZone, enableTime, UNCenableTime,instanceID)
	SELECT C.t_clientId,	1,	0,	4,	1,	@drSubclientId,	0,	0,	0,	0,	1			
	FROM @outAnalyticsClients C 
	WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 0 AND opType =4)
	UNION ALL
		SELECT C.t_clientId,	1,	0,	5,	2,	@drSubclientId,	0,	0,	0,	0,	1			
		FROM @outAnalyticsClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 0 AND opType =5)	
	UNION ALL
		SELECT C.t_clientId,	1,	64,	4,	2,	@drSubclientId,	0,	0,	0,	0,	1			
		FROM @outAnalyticsClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 64 AND opType =4)
	UNION ALL
		SELECT C.t_clientId,	1,	64,	5,	2,	@drSubclientId,	0,	0,	0,	0,	1
		FROM @outAnalyticsClients C 
		WHERE C.t_clientId NOT IN (SELECT clientId FROM JMJobAction (NOLOCK) WHERE appType = 64 AND opType =5)
		
	--USER - ROLES ASSOCIATION
	DECLARE @roleId INT = ISNULL((SELECT id FROM UMRoles (nolock) WHERE name = 'SystemCreatedRole_legacy_Analytics'),0)
	IF @roleId = 0
	BEGIN
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
		VALUES (2, 'SystemCreatedRole_legacy_Analytics', 'System created owner role for entity', 0,0,4,1, 1494445598, 0 , NEWID(), '' )
				
		SET @roleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'SystemCreatedRole_legacy_Analytics'),0)
		IF NOT EXISTS (SELECT 1 FROM UMRolesPermissions (NOLOCK) WHERE roleid = @roleId)
			INSERT INTO UMRolesPermissions (roleid, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
			VALUES (@roleId,122,102,2,0,0), (@roleId,122,107,1,0,0)
	END			
	
	--AGENT MGMT PERMISSIONS FOR ADMIN USER ON PSEUDOCLIENT
	DECLARE @AnaylticsEngineAssociations TABLE (id INT IDENTITY, clientId	INT,userOrGroupId INT ,isUser INT ,permissionId INT ,roleId INT ,isCreator INT ,authorId INT )
	INSERT INTO @AnaylticsEngineAssociations
	SELECT DISTINCT t_pseudoClientId,userOrGroupId,isUser,permissionId,roleId,0,1
	from UMSecurityAssociations JOIN @analyticsClients ON (entityType1=3 OR entityType1 =11) and entityId1=t_clientId and entityType2=0
	UNION
	SELECT DISTINCT t_pseudoClientId,userOrGroupId,isUser,permissionId,roleId,0,1
	FROM UMSecurityAssociations JOIN APP_ClientGroupAssoc ON  entityType1=28 and entityId1=clientGroupId 
	JOIN @analyticsClients ON t_clientId=clientId

	DELETE from @AnaylticsEngineAssociations WHERE id IN (
		SELECT MIN(id) FROM  @AnaylticsEngineAssociations
		GROUP BY clientId	,userOrGroupId  ,isUser  ,permissionId  ,roleId  ,isCreator
		HAVING COUNT(*) > 1
	)

	MERGE UMSecurityAssociations AS UC
    USING(SELECT  clientId	,userOrGroupId  ,isUser  ,permissionId  ,roleId  ,isCreator  ,authorId FROM @AnaylticsEngineAssociations ) AS U (t_entityId1, t_userOrGroupId, t_isUser,t_permissionId,t_roleId,t_isCreator, t_authorId)
    ON (UC.permissionId = U.T_permissionId  AND U.t_roleId=UC.roleId and UC.userOrGroupId = U.t_userOrGroupId and UC.isUser = U.t_isUser AND UC.entityType1 = 3 AND UC.entityId1 = U.t_entityId1 AND UC.entityType2=0 AND UC.isCreator=U.t_isCreator )
    WHEN NOT MATCHED THEN
        INSERT (permissionId,roleId, userOrGroupId, isUser, entityType1, entityId1, isCreator,authorId)
        VALUES(t_permissionId,t_roleId, t_userOrGroupId, t_isUser, 3, t_entityId1,t_isCreator, t_authorId);		

	--STORE PSEUDO CLOUD CLIENT ID INSTEAD OF MA ID
	UPDATE APP_IDAProp 
	SET attrVal = C.pseudoClientId
	FROM APP_IDAProp IP
	 JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.ClientId  = CAST (attrVal AS INT)
	JOIN DM2Cloud C (NOLOCK) ON S.CloudId= C.CloudId
	WHERE attrName = 'OnePass Index Server' and modified = 0
		
	--LICENSE
	DECLARE @psuedoClientId INT
	DECLARE @psuedoClientName NVARCHAR(2048)  = N''	
	DECLARE @STR_DASH       VARCHAR(10) = ':-'
	DECLARE @encryptedRawField NVARCHAR(1024)
	DECLARE @encryptedField NVARCHAR(1024)

	DECLARE @isEvalLicense INT = 0
	IF EXISTS (SELECT 1 FROM LicUsage (NOLOCK) WHERE CID = 2 AND eval = 1 )			
		SET @isEvalLicense = 1

	DECLARE GetIncrementalCur CURSOR
		FOR select t_pseudoClientId, t_pseudoClientName from @analyticsClients

	OPEN GetIncrementalCur
	FETCH NEXT FROM GetIncrementalCur INTO @psuedoClientId, @psuedoClientName	
	WHILE @@FETCH_STATUS=0 
	BEGIN			
			--license 
			IF NOT EXISTS (SELECT 1 FROM LicUsage (NOLOCK) WHERE LicType = 16777216 AND AppType = 1001 AND CID = @psuedoClientId )
			BEGIN
				SET @encryptedRawField = @psuedoClientName   + @STR_DASH + 
					CAST(@psuedoClientId AS VARCHAR(64)) + @STR_DASH + 
					CAST(16777216 AS VARCHAR(64)) + @STR_DASH + 
					CAST(1001 AS VARCHAR(64)) + @STR_DASH + 
					'install'  + @STR_DASH + 
					CAST(dbo.GetUnixTime(GETUTCDATE()) AS VARCHAR(64)) + @STR_DASH +
					CAST(0 AS VARCHAR(64)) + @STR_DASH +
					CAST(@isEvalLicense AS VARCHAR(64)) + @STR_DASH +
					CAST(dbo.GetUnixTime(0) AS VARCHAR(64)) + @STR_DASH +
					CAST(16 AS VARCHAR(64)) + @STR_DASH + 
					CAST(0 AS VARCHAR(64)) + @STR_DASH + 
					'0(BUILD80)' + @STR_DASH + 
					CAST(0 AS VARCHAR(64))  

				EXEC pswEncryptionManaged @encryptedRawField, @encryptedField OUTPUT

				INSERT INTO LicUsage (Name, CId, LicType, AppType, OpType, OpTimeUTC, TokensUsed, Eval, ExpiryDateUTC, ReleaseId, EncryptedField, SimOSID, Build, InstallFlag, UserID, UsedCapacity)
				VALUES ( @psuedoClientName,	@psuedoClientId,	16777216,	1001,	'Install',  GETUTCDATE(),	0,	0,	'1970-01-01 00:00:00.000',	16,	 @encryptedField,	0,	'0(BUILD80)',	0	,0,	0)
			END

			IF NOT EXISTS (SELECT 1 FROM LicUsage (NOLOCK) WHERE LicType = 1 AND AppType =64 AND CID = @psuedoClientId )
			BEGIN

				SET @encryptedRawField = @psuedoClientName   + @STR_DASH + 
					CAST(@psuedoClientId AS VARCHAR(64)) + @STR_DASH + 
					CAST(1 AS VARCHAR(64)) + @STR_DASH + 
					CAST(64 AS VARCHAR(64)) + @STR_DASH + 
					'install'  + @STR_DASH + 
					CAST(dbo.GetUnixTime(GETUTCDATE()) AS VARCHAR(64)) + @STR_DASH +
					CAST(0 AS VARCHAR(64)) + @STR_DASH +
					CAST(@isEvalLicense AS VARCHAR(64)) + @STR_DASH +
					CAST(dbo.GetUnixTime(0) AS VARCHAR(64)) + @STR_DASH +
					CAST(16 AS VARCHAR(64)) + @STR_DASH + 
					CAST(0 AS VARCHAR(64)) + @STR_DASH + 
					'0(BUILD80)' + @STR_DASH + 
					CAST(0 AS VARCHAR(64))  

				EXEC pswEncryptionManaged @encryptedRawField, @encryptedField OUTPUT

				INSERT INTO LicUsage (Name, CId, LicType, AppType, OpType, OpTimeUTC, TokensUsed, Eval, ExpiryDateUTC, ReleaseId, EncryptedField, SimOSID, Build, InstallFlag, UserID, UsedCapacity)
				VALUES ( @psuedoClientName,	@psuedoClientId,	1,	64,	'Install',  GETUTCDATE(),	0,	0,	'1970-01-01 00:00:00.000',	16,	@encryptedField, 0,'0(BUILD80)',	0	,0,	0)
			END			
			FETCH NEXT FROM GetIncrementalCur INTO @psuedoClientId, @psuedoClientName
		END
			
	CLOSE GetIncrementalCur
	DEALLOCATE GetIncrementalCur		

PROC_EXIT:
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@analyticsServerVersion, 'SCPAnalyticsServerUpgrade', 'Upgrade analytics server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END


DECLARE @dcUpgrade INT = 0
DECLARE @dcVersion varchar(36) = '434D96BF-F57A-431A-B850-64DE77650BE1'
SELECT @dcUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)
WHERE GS.SqlScriptGUID = @dcVersion

IF (@dcUpgrade = 0)            -- not done, do the db upgrade
BEGIN   	
	IF NOT EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE NAME = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID')
	BEGIN
		DECLARE	@indexServerClientId	INT = 0
		DECLARE	@maId	INT = ISNULL((SELECT TOP 1 CAST( value AS INT) FROM GXGlobalParam (NOLOCK) WHERE NAME = 'DOWNLOAD_CENTER_CLIENT_ID_RETRY' AND modified = 0),0)
		IF @maId !=0
		BEGIN
			SET @indexServerClientId = ISNULL((SELECT TOP 1 pseudoClientId FROM DM2Cloud DC (NOLOCK) 
											JOIN DM2SearchServerCoreInfo S (NOLOCK) ON DC.CloudId= S.CloudId
											WHERE S.clientId= @maId AND S.cloudType IN (1)),0)
			IF @indexServerClientId !=0				
			BEGIN															
				DECLARE @nowTime INT = datediff(second, '01/01/1970', GETDATE())	
    			INSERT INTO GXGlobalParam(name, value, created, modified)	            			
        		VALUES ('DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID', @indexServerClientId, @nowTime, 0)                			

				UPDATE GXGlobalParam 
				SET name = 'DOWNLOAD_CENTER_CLIENT_ID_DONOTUSE'  
				WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID_RETRY'	AND modified = 0
			END
		END
	END

	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
	VALUES(@dcVersion, 'SCPDCIndexServerUpgrade', 'Upgrade DC index server', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))
END

--One time update of physical index server client to Pseudoclient for edgeclients
-- This update should be right after cloud upgrade
DECLARE @updatePseudoClient uniqueidentifier = 'FE3F9CB4-4BE1-41BB-9D97-80B3D3AF95AB'
DECLARE @currentUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @updatePseudoClient)
BEGIN

	UPDATE EA
	SET EA.entityId = CL.pseudoClientId, EA.entityType = 3 /**CLIENT_ENTITY**/
	FROM App_EdgeDriveAssociation EA
    INNER JOIN DM2SearchServerCoreInfo DM(nolock) ON EA.entityId = DM.ClientId
    INNER JOIN DM2Cloud CL(nolock) ON DM.CloudId = CL.cloudId
    INNER JOIN DM2CloudCoreRole R(nolock) ON DM.CloudId = R.CloudId
    INNER JOIN DM2CloudRoleMaster RM(nolock) ON RM.roleType = R.roleId AND RM.roleTypeName in ('EDGE DRIVE','NFS Index')
    INNER JOIN APP_Client C ON C.id = DM.ClientId
    INNER JOIN SimInstalledPackages SIP ON SIP.ClientId =  C.id AND SIP.simPackageID in (252 /**N_WIN_PACKAGE_DM2_WEB_SERVICE**/,263 /**N_WIN_PACKAGE_INDEXING_SERVER **/)  
	WHERE CL.CloudType = 1 /**CloudServerType::AnalyticsEngine**/ AND EA.entityType=11 /**MEDIAAGENT_ENTITY**/     

    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
    VALUES(@updatePseudoClient, 'UpdateEdgeClientIndexServerAssociation', 'Enable edge audit and notification feature', @currentUtcDateTime, 16, 0 , (16 + 1))
END
