SET QUOTED_IDENTIFIER ON


DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())

BEGIN TRY
	Begin tran
		declare @guid uniqueidentifier = 'CE2F64A9-B97B-44B8-81AC-BDB442E870A5'
		DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

		DECLARE @globalParamAdminConsoleSetup INT = 0
		SELECT @globalParamAdminConsoleSetup = 1
		FROM
			GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)
		WHERE
			gp.SqlScriptGUID = @guid

		IF (@globalParamAdminConsoleSetup = 0)        -- not done, create the default alerts.
		BEGIN
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
				VALUES(@guid, 'skipRegistrationAndLinking', 'One time tblscript to fill skipRegistrationAndLinking key on upgraded setups', @curUtcDateTime, 11, 0 , 13)

			IF object_id('tempdb.dbo.#clientIdListWithWc') IS NOT null DROP TABLE #clientIdListWithWc
			Create table #clientIdListWithWc(clientId int primary key(clientId))

			-- N_WIN_PACKAGE_WEB_CONSOLE : 726
			-- #define N_UNIX_PACKAGE_WEB_CONSOLE	1135 macro 
			declare @keyName nvarchar(max)='skipRegistrationAndLinking'
			declare @relativePath nvarchar(max)='WebConsole'
			
			Insert into #clientIdListWithWc
			SELECT DISTINCT clientId FROM simInstalledPackages 
			inner join app_client C on simInstalledPackages.ClientId = C.id and (c.status&4)=0
			and (simPackageId = 726 or simpackageId = 1135 )
			left join App_advancesettings on 
			App_advancesettings.entityId = simInstalledPackages.ClientId and 
			App_advancesettings.keyname = @keyName and 
			App_advancesettings.relativePath = @relativePath

			-- Write into additional settings and push additional settings token.
			Insert into App_advancesettings(entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			SELECT DISTINCT clientId,@keyName, 'BOOLEAN', @relativePath, 'true', 1, 0, 3, 0, 0 
			FROM #clientIdListWithWc

			INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			SELECT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @curUtcDateTime, 0, 0, 0, -1
            FROM #clientIdListWithWc

			IF object_id('tempdb.dbo.#clientIdListWithWc') IS NOT null DROP TABLE #clientIdListWithWc
		End  


		-- Script to add black listed Groups flag to Laptop Admins Group
		DECLARE @disableAutomaticDefaultPlanSetup    VARCHAR(40) = '09affbd7-a638-43df-aeee-b59a5ea43d24'

		IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @disableAutomaticDefaultPlanSetup)
		BEGIN
			UPDATE GXGlobalParam  SET value = '0'
				WHERE name = 'Set Default Plan Automatically' and value='1'
			   

			-- Update script table , so that this code doesn't execute anymore'
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
			VALUES(@disableAutomaticDefaultPlanSetup, 'DefaultPlanSetup', 'Disable automatic default plan setup setup', @nowTime, 11, 0 , 13)
		END

END TRY
BEGIN CATCH
--CATCH_HANDLING_MACRO
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
	IF @errorCode = 0
		COMMIT TRAN
	ELSE 
		ROLLBACK TRAN
ERROR_EXIT:
SELECT @errorCode, @errorString
