SET QUOTED_IDENTIFIER OFF

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_patternId1	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @userId 	INTEGER

	DECLARE @currentTime	INTEGER

	DECLARE @xmlText		XML

	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL

		DROP TABLE #TM_IDTable

	SELECT 0 as id, 0 as type INTO #TM_IDTable

DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    
-- Do this only for OEM 113 - Edge brand

IF @oem <> 113
   return



	DECLARE @dloClientGroup	INT = ISNULL((SELECT MAX(id) FROM APP_ClientGroup WHERE flag&4096=4096 AND name = 'Laptop Clients'), 0)
	
	IF	@dloClientGroup = 0

	BEGIN

		SET @errStr = 'ERROR: Could not find Laptop Clients group'

		GOTO ERROR_EXIT

	END
	-----------------------------------------------------------------------------

	-- System Created Schedule Policy for DLO

	IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags&0x100 = 0x100)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

		OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable	

		VALUES			   ("System Created for Laptop Clients",				-- Task Name

							4,		-- Task Type

							0x100,								-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

							3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

							"System created schedule policy for Laptop clients",		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							1,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

		SET @l_taskId1 = (SELECT id FROM #TM_IDTable WHERE type = 1)
		
		
		-- Association is all laptop clients
		INSERT INTO TM_AssocEntity (assocType,
									taskId,
									flags,
									created,
									clientGroupId,
									clientId,
									apptypeId,
									instanceId,
									backupsetId,
									subclientId,
									policyId,
									copyId,
									srmReportSet,
									srmReportType,
									exclude,
									trackingPolicyId,
									MediaAgentId,
									agentlessPolicyId,
									workflowId,
									sidbStoreId,
									libraryId,
									logMonitoringPolicyId)
		VALUES						(28,			-- CLIENT_GROUP_ENTITY
									 @l_taskId1,
									 0,
									 @currentTime,
									 @dloClientGroup,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0,
									 0)
		
		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_AssocEntity'

			GOTO ERROR_EXIT

		END


		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

		OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable	

		VALUES				   ("",									-- SubTask Name

								@l_taskId1,						-- Task ID

								2,							-- SubTask Type

								2,							-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END
		
		

		SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable WHERE type = 2)

		-- Pattern 1:

		-- OSC schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

		OUTPUT	INSERTED.patternId , 3 INTO #TM_IDTable				   

		VALUES				  ("",							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

							   1024,						-- Freq Type

							   0,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   0,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,					-- Active Start Date

							   0,							-- Active Start Time

							   '1970-01-01 00:00:00',				-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   "",							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),	-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END


		SET @l_patternId1 = (SELECT id FROM #TM_IDTable WHERE type = 3)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					  		(@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId1,

										 '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="2" incLevel="1" isSpHasInLineCopy="0" sybaseSkipFullafterLogBkp="0" runIncrementalBackup="1" doNotTruncateLog="0" runSILOBackup="0"><mediaOpt /><dataOpt followMountPoints="1" createNewIndex="0" useCatalogServer="1" skipConsistencyCheck="0" enforceTransactionLogUsage="0" /></backupOpts><commonOpts><automaticSchedulePattern minSyncInterval="0" minSyncIntervalMinutes="2" maxBackupInterval="72" minBackupInterval="36" maxBackupIntervalMinutes="0" ignoreOpWindowPastMaxInterval="0" minBackupIntervalMinutes="0"><minNetworkBandwidth enabled="0" /><stopIfOnBattery enabled="0" /><acPower enabled="0" /><stopSleepIfBackUp enabled="0" /><cpuUtilization enabled="0" /><specfificNetwork enabled="0" /><newOrModifiedFile enabled="0" /><wiredNetworkConnection enabled="0" /><emergencyBackup emergencyBackupCommandName=""><emergencyBackup enabled="0" /></emergencyBackup></automaticSchedulePattern><perfJobOpts /></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created  Schedule Policy-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100003,			-- BKP_OPTION

									   15,

									   6296592)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100004,			-- BKP_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000011')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100005,			-- BKP_NAS_OPTION

									   15,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   140015,			-- COM_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000011')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   177623377,			-- options[1]/backupOpts[1]/@isSpHasInLineCopy

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   236666161,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/minNetworkBandwidth[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   312510015,			-- options[1]/backupOpts[1]/@runIncrementalBackup

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   362764450,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncIntervalMinutes

									   8,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   416206437,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/wiredNetworkConnection[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   458405394,			-- options[1]/backupOpts[1]/@backupLevel

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   589118090,			-- options[1]/backupOpts[1]/@runSILOBackup

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   649116404,			-- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   697451464,			-- options[1]/backupOpts[1]/dataOpt[1]/@enforceTransactionLogUsage

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   703512134,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@maxBackupInterval

									   8,

									   72)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   756999446,			-- options[1]/backupOpts[1]/@incLevel

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   800343273,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/emergencyBackup[1]/@emergencyBackupCommandName

									   0,

									   '')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   850125934,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/stopSleepIfBackUp[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   974354278,			-- options[1]/backupOpts[1]/@doNotTruncateLog

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1110217321,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minBackupIntervalMinutes

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1197257326,			-- options[1]/backupOpts[1]/dataOpt[1]/@skipConsistencyCheck

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1205284996,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/specfificNetwork[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1197257326,			-- options[1]/backupOpts[1]/dataOpt[1]/@skipConsistencyCheck

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1205284996,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/specfificNetwork[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1266111406,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/cpuUtilization[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1712751984,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@maxBackupIntervalMinutes

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1515007811,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/acPower[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1545679425,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncInterval

									   8,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1611532840,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/@minSyncInterval

									   8,

									   36)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1641015063,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/stopIfOnBattery[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1667682014,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/newOrModifiedFile[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1712751984,			-- options[1]/commonOpts[1]/automaticSchedulePattern[1]/emergencyBackup[1]/emergencyBackup[1]/@enabled

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1735011734,			-- options[1]/backupOpts[1]/@sybaseSkipFullafterLogBkp

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1817749836,			-- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   2045937773,			-- options[1]/backupOpts[1]/dataOpt[1]/@createNewIndex

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   2055741185,			-- options[1]/backupOpts[1]/@truncateLogsOnSource

									   0,

									   0)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 

		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

		WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)


		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: System Created Schedule Policy -- Failed to insert in TM_JobOptions'

			GOTO ERROR_EXIT

		END

	
	END

------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------

END 

ALL_DONE:

ERROR_EXIT:

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL

		DROP TABLE #TM_IDTable

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr


