SET QUOTED_IDENTIFIER OFF

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @l_taskId1		INTEGER

	DECLARE @l_subTaskId1	INTEGER

	DECLARE @l_subTaskId2	INTEGER

	DECLARE @l_patternId1	INTEGER

	DECLARE @l_patternId2	INTEGER

	DECLARE @l_taskId2		INTEGER

	DECLARE @l_subTaskId3	INTEGER

	DECLARE @l_subTaskId4	INTEGER

	DECLARE @l_patternId3	INTEGER

	DECLARE @l_patternId4	INTEGER

	DECLARE @currentDate	DATETIME

	DECLARE @userId 	INTEGER

	DECLARE @currentTime	INTEGER

	DECLARE @xmlText		XML

	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)

	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())

	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL

		DROP TABLE #TM_IDTable

	SELECT 0 as id, 0 as type INTO #TM_IDTable

	-----------------------------------------------------------------------------

	-- Created by default for MSP brand for DLO

	IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags&0x1000 = 0x1000)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

		OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable	

		VALUES			   ("Morning at 7:00 AM",				-- Task Name

							4,		-- Task Type

							0x1000,								-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

							3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

							"Created by default for MSP brand",		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							1,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

		SET @l_taskId1 = (SELECT id FROM #TM_IDTable WHERE type = 1)

		INSERT INTO TM_AssocFilter (taskId,

									filter_type,

									filter_value,

									flags)

		VALUES						(@l_taskId1,

									2,		--filter_type

									106,	--filter_value

									0)		--flags

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_AssocFilter'

			GOTO ERROR_EXIT

		END
		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

		OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable	

		VALUES				   ("Morning incremental",		-- SubTask Name

								@l_taskId1,					-- Task ID

								2,							-- SubTask Type

								2,							-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END
		
		

		SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable WHERE type = 2)

		-- Pattern 1:

		-- OSC schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

		OUTPUT	INSERTED.patternId , 3 INTO #TM_IDTable				   

		VALUES				  ("",							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

							   8,							-- Freq Type

							   63,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,					-- Active Start Date

							   25200,							-- Active Start Time

							   '1970-01-01 00:00:00',				-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   "Every week on Sunday,Monday,Tuesday,Wednesday,Thursday,Friday at 7:00 AM",							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),	-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END


		SET @l_patternId1 = (SELECT id FROM #TM_IDTable WHERE type = 3)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					  		(@l_patternId1,				-- Pattern ID

									@l_subTaskId1,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId1,

										 '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="2" sybaseSkipFullafterLogBkp="0" incLevel="1" runIncrementalBackup="1" runSILOBackup="0" doNotTruncateLog="0"><vsaBackupOptions backupFailedVMsOnly="0" /><mediaOpt /><dataOpt useCatalogServer="1" followMountPoints="1" enforceTransactionLogUsage="0" skipConsistencyCheck="0" autoCopy="0" /></backupOpts><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100003,			-- BKP_OPTION

									   15,

									   6296592)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100004,			-- BKP_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   100005,			-- BKP_NAS_OPTION

									   15,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   140015,			-- COM_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END


		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   312510015,			-- options[1]/backupOpts[1]/@runIncrementalBackup

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   458405394,			-- options[1]/backupOpts[1]/@backupLevel

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   649116404,			-- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   756999446,			-- options[1]/backupOpts[1]/@incLevel 

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId1,

									   1817749836,			-- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

		OUTPUT	INSERTED.subTaskId , 4 INTO #TM_IDTable	

		VALUES				   ("Morning weekly full",		-- SubTask Name

								@l_taskId1,					-- Task ID

								2,							-- SubTask Type

								2,							-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END
		
		

		SET @l_subTaskId2 = (SELECT id FROM #TM_IDTable WHERE type = 4)

		-- Pattern 1:

		-- OSC schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

		OUTPUT	INSERTED.patternId , 5 INTO #TM_IDTable				   

		VALUES				  ("",							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

							   8,							-- Freq Type

							   64,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,					-- Active Start Date

							   25200,							-- Active Start Time

							   '1970-01-01 00:00:00',				-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   "Every week on Saturday at 7:00 AM",							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),	-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END


		SET @l_patternId2 = (SELECT id FROM #TM_IDTable WHERE type = 5)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					  		(@l_patternId2,				-- Pattern ID

									@l_subTaskId2,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId2,

										 '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="1" sybaseSkipFullafterLogBkp="0" incLevel="1" runIncrementalBackup="1" runSILOBackup="0" doNotTruncateLog="0"><vsaBackupOptions backupFailedVMsOnly="0" /><mediaOpt /><dataOpt useCatalogServer="1" followMountPoints="1" enforceTransactionLogUsage="0" skipConsistencyCheck="0" autoCopy="0" /></backupOpts><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId2)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId2, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   100003,			-- BKP_OPTION

									   15,

									   6296592)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   100004,			-- BKP_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   100005,			-- BKP_NAS_OPTION

									   15,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   140015,			-- COM_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END


		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   312510015,			-- options[1]/backupOpts[1]/@runIncrementalBackup

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   458405394,			-- options[1]/backupOpts[1]/@backupLevel

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   649116404,			-- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   756999446,			-- options[1]/backupOpts[1]/@incLevel 

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId2,

									   1817749836,			-- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, OPT.subTaskId, 0, @currentTime, 0 

		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

		WHERE subTaskId IN (@l_subTaskId1, @l_subTaskId2) AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)


		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_JobOptions'

			GOTO ERROR_EXIT

		END

	
	END

	IF NOT EXISTS (SELECT * FROM TM_Task WHERE flags&0x2000 = 0x2000)

	BEGIN

		-- Schedule Policy	
		INSERT INTO TM_Task(taskName,


							taskType,

							flags,	

							status,	

							created,	

							modified,

							alertId,	

							ownerId,	

							runUserId,	

							initiatedFrom,	

							sequenceNumber,

							localeId,

							description,

							deleted,

							disabled,

							uninstalled,

							invalid,

							defaultTask,

							savedReport,

							serial,

							policyType,

							origCCId,

							GUID,

							isEZOperation,

							isAgentlessSRM,

							hidden)

		OUTPUT	INSERTED.taskId , 6 INTO #TM_IDTable	

		VALUES			   ("Evening at 7:00 PM",				-- Task Name

							4,		-- Task Type

							0x2000,								-- Task Flags

							0,								-- Status

							0,								-- Created

							0,								-- Modified

							0,								-- Alert ID

							@userId,							-- Owner ID

							@userId,							-- Run User ID

							3,			-- Initiated From

							0,								-- Seq No

							0,								-- Locale ID

							"Created by default for MSP brand",		-- Description

							0,								-- Deleted

							0,								-- Disabled

							0,								-- Uninstalled

							0,								-- Invalid

							1,								-- Default Task ???

							0,								-- Saved Report

							0,								-- Serial

							0,								-- Policy Type

							DEFAULT,						-- Original CC ID

							newid(),						-- GUID

							0,								-- isEZOperation

							0,								-- isAgentlessSRM

							0)								-- hidden

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Task'

			GOTO ERROR_EXIT

		END

		SET @l_taskId2 = (SELECT id FROM #TM_IDTable WHERE type = 6)

		INSERT INTO TM_AssocFilter (taskId,

									filter_type,

									filter_value,

									flags)

		VALUES						(@l_taskId2,

									2,		--filter_type

									106,	--filter_value

									0)		--flags

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_AssocFilter'

			GOTO ERROR_EXIT

		END

		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

		OUTPUT	INSERTED.subTaskId , 7 INTO #TM_IDTable	

		VALUES				   ("Evening incremental",		-- SubTask Name

								@l_taskId2,					-- Task ID

								2,							-- SubTask Type

								2,							-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END
		
		

		SET @l_subTaskId3 = (SELECT id FROM #TM_IDTable WHERE type = 7)

		-- Pattern 1:

		-- OSC schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

		OUTPUT	INSERTED.patternId , 8 INTO #TM_IDTable				   

		VALUES				  ("",							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

							   8,							-- Freq Type

							   63,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,					-- Active Start Date

							   68400,							-- Active Start Time

							   '1970-01-01 00:00:00',				-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   "Every week on Sunday,Monday,Tuesday,Wednesday,Thursday,Friday at 7:00 PM",							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),	-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END


		SET @l_patternId3 = (SELECT id FROM #TM_IDTable WHERE type = 8)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					  		(@l_patternId3,				-- Pattern ID

									@l_subTaskId3,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId3,

										 '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="2" sybaseSkipFullafterLogBkp="0" incLevel="1" runIncrementalBackup="1" runSILOBackup="0" doNotTruncateLog="0"><vsaBackupOptions backupFailedVMsOnly="0" /><mediaOpt /><dataOpt useCatalogServer="1" followMountPoints="1" enforceTransactionLogUsage="0" skipConsistencyCheck="0" autoCopy="0" /></backupOpts><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId2, @l_subTaskId3, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   100003,			-- BKP_OPTION

									   15,

									   6296592)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   100004,			-- BKP_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   100005,			-- BKP_NAS_OPTION

									   15,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   140015,			-- COM_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END


		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   312510015,			-- options[1]/backupOpts[1]/@runIncrementalBackup

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   458405394,			-- options[1]/backupOpts[1]/@backupLevel

									   7,

									   2)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   649116404,			-- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   756999446,			-- options[1]/backupOpts[1]/@incLevel 

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId3,

									   1817749836,			-- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		-- Schedule 1 :

		-- Incremental Schedule						
		INSERT INTO TM_SubTask (subTaskName,


	 				 			taskId,

								subTaskType	,	

								operationType,	

								flags		,	

								subTaskOrder,

								deleted,

 		 						uninstalled,

								defaultTask)

		OUTPUT	INSERTED.subTaskId , 9 INTO #TM_IDTable	

		VALUES				   ("Evening weekly full",		-- SubTask Name

								@l_taskId2,					-- Task ID

								2,							-- SubTask Type

								2,							-- Operation Type

								0,							-- Flags

								0,							-- SubTask Order

								0,							-- Deleted

								0,							-- Uninstalled

								0)							-- Default Task ???

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTask'

			GOTO ERROR_EXIT

		END
		
		

		SET @l_subTaskId4 = (SELECT id FROM #TM_IDTable WHERE type = 9)

		-- Pattern 1:

		-- OSC schedule
		INSERT INTO TM_Pattern(name,


							   ownerId,

							   status,

							   flags,

							   freq_type,

							   freq_interval,

							   freq_relative_interval,

							   freq_recurrence_factor,

							   freq_subday_interval,

							   skipOccurence,

							   skipDayNumber,

							   active_start_date,

							   active_start_time,

							   active_end_date,

							   active_end_time,

							   active_end_occurence,

							   created,

							   modified,

							   tzId,

							   calendarId,

							   description,

							   local_start_date,

							   local_end_date,

							   disabled,

							   deleted,

							   scheduling,

							   freq_restart_interval)

		OUTPUT	INSERTED.patternId , 10 INTO #TM_IDTable				   

		VALUES				  ("",							-- Name

							   @userId,						-- Owner ID

							   0,							-- Status

							   0,							-- Flags

							   8,							-- Freq Type

							   64,							-- Freq Interval

							   0,							-- Freq Relative Interval

							   1,							-- Freq Recurrence Factor

							   0,							-- Freq Subday Interval

							   0,							-- Skip Occurrence

							   0,							-- Skip Day Number

							   @currentDate,					-- Active Start Date

							   68400,							-- Active Start Time

							   '1970-01-01 00:00:00',				-- Active End Date	

							   0,							-- Active End Time

							   0,							-- Active End Occurrence

							   0,							-- Created

							   0,							-- Modified

							   1000,					-- Time Zone Id 

							   1,							-- Calendar Id

							   "Every week on Saturday at 7:00 PM",							-- Description

							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),	-- Local Start Date

							   0,							-- Local End Date

							   0,							-- Disabled

							   0,							-- Deleted

							   0,							-- Scheduling

							   0)							-- Freq Restart Interval

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_Pattern '

			GOTO ERROR_EXIT

		END


		SET @l_patternId4 = (SELECT id FROM #TM_IDTable WHERE type = 10)

		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,


									subTaskId,

									flags,

						   			disabled,

									deleted,

									scheduling)

		VALUES					  		(@l_patternId4,				-- Pattern ID

									@l_subTaskId4,				-- SubTask ID

									0,							-- Flags

									0,							-- Disabled

									0,							-- Deleted

									0)							-- Scheduling

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_PatternAssoc '

			GOTO ERROR_EXIT

		END

		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,


										 xmlValue)

		VALUES							(@l_subTaskId4,

										 '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" backupLevel="1" sybaseSkipFullafterLogBkp="0" incLevel="1" runIncrementalBackup="1" runSILOBackup="0" doNotTruncateLog="0"><vsaBackupOptions backupFailedVMsOnly="0" /><mediaOpt /><dataOpt useCatalogServer="1" followMountPoints="1" enforceTransactionLogUsage="0" skipConsistencyCheck="0" autoCopy="0" /></backupOpts><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskXMLOptions '

			GOTO ERROR_EXIT

		END

		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId1)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId2, @l_subTaskId4, 0, @currentTime, 0 


		SET @errCode = @@ERROR

		IF  @errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand-- Failed to insert in TM_JobXMLOptions'

			GOTO ERROR_EXIT

		END

		-- SubTask Options
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   100003,			-- BKP_OPTION

									   15,

									   6296592)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   100004,			-- BKP_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   100005,			-- BKP_NAS_OPTION

									   15,

									   4)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END
		
		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   140015,			-- COM_EXTENDED

									   1,

									   '1000000000100100000000000000000100000000000000000010000000000000010')

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END


		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   312510015,			-- options[1]/backupOpts[1]/@runIncrementalBackup

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   458405394,			-- options[1]/backupOpts[1]/@backupLevel

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,


									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   649116404,			-- options[1]/backupOpts[1]/dataOpt[1]/@useCatalogServer 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   756999446,			-- options[1]/backupOpts[1]/@incLevel 

									   7,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_SubTaskOptions(subTaskID,

									  optionID,

									  type,

									  value)

		VALUES						  (@l_subTaskId4,

									   1817749836,			-- options[1]/backupOpts[1]/dataOpt[1]/@followMountPoints 

									   0,

									   1)

		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_SubTaskOptions'

			GOTO ERROR_EXIT

		END

		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId2, OPT.subTaskId, 0, @currentTime, 0 

		FROM TM_SubTaskOptions AS OPT

		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value

		WHERE subTaskId IN (@l_subTaskId3, @l_subTaskId4) AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)


		SET @errCode = @@ERROR

		IF	@errCode <> 0

		BEGIN

			SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to insert in TM_JobOptions'

			GOTO ERROR_EXIT

		END

	
	END

	--Set lock down
	EXEC  AppInsertGlobalParam
            @isPIT = 1,
            @createdTime = @currentTime,
            @name = N'Secure Agent Install',
            @newValue = N'1'

	SET @errCode = @@ERROR

	IF	@errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: Created by default for MSP brand -- Failed to set Secure Agent Install'

		GOTO ERROR_EXIT

	END

------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------

END 

ALL_DONE:

ERROR_EXIT:

	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL

		DROP TABLE #TM_IDTable

PRINT 'Errorcode = '+CAST(@errCode AS nvarchar(10)) + ' Error= ' + @errStr


